/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.commons.AnalyzerAdapter;

public class BetterAnalyzerAdapter
extends AnalyzerAdapter {
    private final List<Object> lastFrameLocals = new ArrayList<Object>();
    private final List<Object> lastFrameStack = new ArrayList<Object>();

    protected BetterAnalyzerAdapter(int api, String owner, int access, String name, String descriptor, @Nullable MethodVisitor methodVisitor) {
        super(api, owner, access, name, descriptor, methodVisitor);
        for (Object local : this.locals) {
            if (local.equals(Opcodes.TOP)) continue;
            this.lastFrameLocals.add(local);
        }
    }

    @Override
    public void visitFrame(int type, int numLocal, Object[] local, int numStack, Object[] stack) {
        switch (type) {
            case -1: {
                super.visitFrame(type, numLocal, local, numStack, stack);
                return;
            }
            case 3: {
                this.lastFrameStack.clear();
                break;
            }
            case 4: {
                this.lastFrameStack.clear();
                this.lastFrameStack.add(stack[0]);
                break;
            }
            case 1: {
                Collections.addAll(this.lastFrameLocals, local);
                this.lastFrameStack.clear();
                break;
            }
            case 2: {
                this.lastFrameLocals.subList(this.lastFrameLocals.size() - numLocal, this.lastFrameLocals.size()).clear();
                this.lastFrameStack.clear();
                break;
            }
            case 0: {
                this.lastFrameLocals.clear();
                Collections.addAll(this.lastFrameLocals, local);
                this.lastFrameStack.clear();
                Collections.addAll(this.lastFrameStack, stack);
                break;
            }
            default: {
                throw new AssertionError((Object)("Illegal frame type: " + type));
            }
        }
        super.visitFrame(-1, this.lastFrameLocals.size(), this.lastFrameLocals.toArray(), this.lastFrameStack.size(), this.lastFrameStack.toArray());
    }
}

