/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis.index;

import cuchaz.enigma.analysis.index.EntryIndex;
import cuchaz.enigma.analysis.index.InheritanceIndex;
import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.analysis.index.JarIndexer;
import cuchaz.enigma.analysis.index.ReferenceIndex;
import cuchaz.enigma.api.view.entry.MethodEntryView;
import cuchaz.enigma.api.view.index.BridgeMethodIndexView;
import cuchaz.enigma.translation.representation.AccessFlags;
import cuchaz.enigma.translation.representation.MethodDescriptor;
import cuchaz.enigma.translation.representation.TypeDescriptor;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.MethodDefEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Nullable;

public class BridgeMethodIndex
implements JarIndexer,
BridgeMethodIndexView {
    private final EntryIndex entryIndex;
    private final InheritanceIndex inheritanceIndex;
    private final ReferenceIndex referenceIndex;
    private final ConcurrentMap<MethodEntry, MethodEntry> bridgeToSpecialized = new ConcurrentHashMap<MethodEntry, MethodEntry>();
    private final ConcurrentMap<MethodEntry, MethodEntry> specializedToBridge = new ConcurrentHashMap<MethodEntry, MethodEntry>();

    public BridgeMethodIndex(EntryIndex entryIndex, InheritanceIndex inheritanceIndex, ReferenceIndex referenceIndex) {
        this.entryIndex = entryIndex;
        this.inheritanceIndex = inheritanceIndex;
        this.referenceIndex = referenceIndex;
    }

    public void findBridgeMethods() {
        for (MethodEntry methodEntry : this.entryIndex.getMethods()) {
            MethodDefEntry methodDefEntry = (MethodDefEntry)methodEntry;
            AccessFlags access = methodDefEntry.getAccess();
            if (access == null || !access.isSynthetic()) continue;
            this.indexSyntheticMethod(methodDefEntry, access);
        }
    }

    @Override
    public void processIndex(JarIndex index) {
        HashMap<MethodEntry, MethodEntry> copiedAccessToBridge = new HashMap<MethodEntry, MethodEntry>(this.specializedToBridge);
        copiedAccessToBridge.entrySet().parallelStream().forEach(entry -> {
            MethodEntry specializedEntry = (MethodEntry)entry.getKey();
            MethodEntry bridgeEntry = (MethodEntry)entry.getValue();
            if (bridgeEntry.getName().equals(specializedEntry.getName())) {
                return;
            }
            MethodEntry renamedSpecializedEntry = specializedEntry.withName(bridgeEntry.getName());
            this.specializedToBridge.put(renamedSpecializedEntry, (MethodEntry)copiedAccessToBridge.get(specializedEntry));
        });
    }

    private void indexSyntheticMethod(MethodDefEntry syntheticMethod, AccessFlags access) {
        MethodEntry specializedMethod = this.findSpecializedMethod(syntheticMethod);
        if (specializedMethod == null) {
            return;
        }
        if (access.isBridge() || this.isPotentialBridge(syntheticMethod, specializedMethod)) {
            this.bridgeToSpecialized.put(syntheticMethod, specializedMethod);
            this.specializedToBridge.put(specializedMethod, syntheticMethod);
        }
    }

    private MethodEntry findSpecializedMethod(MethodEntry method) {
        Collection<MethodEntry> referencedMethods = this.referenceIndex.getMethodsReferencedBy(method);
        if (referencedMethods.size() != 1) {
            return null;
        }
        return referencedMethods.stream().findFirst().orElse(null);
    }

    private boolean isPotentialBridge(MethodDefEntry bridgeMethod, MethodEntry specializedMethod) {
        AccessFlags bridgeAccess = bridgeMethod.getAccess();
        if (bridgeAccess.isPrivate() || bridgeAccess.isFinal() || bridgeAccess.isStatic()) {
            return false;
        }
        MethodDescriptor bridgeDesc = bridgeMethod.getDesc();
        MethodDescriptor specializedDesc = specializedMethod.getDesc();
        List<TypeDescriptor> bridgeArguments = bridgeDesc.getArgumentDescs();
        List<TypeDescriptor> specializedArguments = specializedDesc.getArgumentDescs();
        if (bridgeArguments.size() != specializedArguments.size()) {
            return false;
        }
        for (int i = 0; i < bridgeArguments.size(); ++i) {
            if (this.areTypesBridgeCompatible(bridgeArguments.get(i), specializedArguments.get(i))) continue;
            return false;
        }
        return this.areTypesBridgeCompatible(bridgeDesc.getReturnDesc(), specializedDesc.getReturnDesc());
    }

    private boolean areTypesBridgeCompatible(TypeDescriptor bridgeDesc, TypeDescriptor specializedDesc) {
        if (bridgeDesc.equals(specializedDesc)) {
            return true;
        }
        if (bridgeDesc.isType() && specializedDesc.isType()) {
            ClassEntry bridgeType = bridgeDesc.getTypeEntry();
            ClassEntry accessedType = specializedDesc.getTypeEntry();
            InheritanceIndex.Relation relation = this.inheritanceIndex.computeClassRelation(accessedType, bridgeType);
            return relation != InheritanceIndex.Relation.UNRELATED;
        }
        return false;
    }

    public boolean isBridgeMethod(MethodEntry entry) {
        return this.bridgeToSpecialized.containsKey(entry);
    }

    public boolean isSpecializedMethod(MethodEntry entry) {
        return this.specializedToBridge.containsKey(entry);
    }

    @Nullable
    public MethodEntry getBridgeFromSpecialized(MethodEntry specialized) {
        return (MethodEntry)this.specializedToBridge.get(specialized);
    }

    public MethodEntry getSpecializedFromBridge(MethodEntry bridge) {
        return (MethodEntry)this.bridgeToSpecialized.get(bridge);
    }

    @Override
    @Nullable
    public MethodEntryView getBridgeFromSpecialized(MethodEntryView specialized) {
        return this.getBridgeFromSpecialized((MethodEntry)specialized);
    }

    @Override
    @Nullable
    public MethodEntryView getSpecializedFromBridge(MethodEntryView bridge) {
        return this.getSpecializedFromBridge((MethodEntry)bridge);
    }

    public Map<MethodEntry, MethodEntry> getSpecializedToBridge() {
        return Collections.unmodifiableMap(this.specializedToBridge);
    }

    public Map<MethodEntry, MethodEntry> getBridgeToSpecialized() {
        return Collections.unmodifiableMap(this.bridgeToSpecialized);
    }
}

