/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis.index;

import cuchaz.enigma.analysis.index.JarIndexer;
import cuchaz.enigma.api.view.entry.ClassDefEntryView;
import cuchaz.enigma.api.view.entry.ClassEntryView;
import cuchaz.enigma.api.view.entry.EntryView;
import cuchaz.enigma.api.view.index.EntryIndexView;
import cuchaz.enigma.translation.representation.AccessFlags;
import cuchaz.enigma.translation.representation.entry.ClassDefEntry;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.FieldDefEntry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.LocalVariableEntry;
import cuchaz.enigma.translation.representation.entry.MethodDefEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Nullable;

public class EntryIndex
implements JarIndexer,
EntryIndexView {
    private final ConcurrentMap<ClassEntry, AccessFlags> classes = new ConcurrentHashMap<ClassEntry, AccessFlags>();
    private final ConcurrentMap<FieldEntry, AccessFlags> fields = new ConcurrentHashMap<FieldEntry, AccessFlags>();
    private final ConcurrentMap<MethodEntry, AccessFlags> methods = new ConcurrentHashMap<MethodEntry, AccessFlags>();
    private final ConcurrentMap<ClassEntry, ClassDefEntry> definitions = new ConcurrentHashMap<ClassEntry, ClassDefEntry>();

    @Override
    public void indexClass(ClassDefEntry classEntry) {
        this.definitions.put(classEntry, classEntry);
        this.classes.put(classEntry, classEntry.getAccess());
    }

    @Override
    public void indexMethod(MethodDefEntry methodEntry) {
        this.methods.put(methodEntry, methodEntry.getAccess());
    }

    @Override
    public void indexField(FieldDefEntry fieldEntry) {
        this.fields.put(fieldEntry, fieldEntry.getAccess());
    }

    public boolean hasClass(ClassEntry entry) {
        return this.classes.containsKey(entry);
    }

    public boolean hasMethod(MethodEntry entry) {
        return this.methods.containsKey(entry);
    }

    public boolean hasField(FieldEntry entry) {
        return this.fields.containsKey(entry);
    }

    public boolean hasEntry(Entry<?> entry) {
        if (entry instanceof ClassEntry) {
            ClassEntry classEntry = (ClassEntry)entry;
            return this.hasClass(classEntry);
        }
        if (entry instanceof MethodEntry) {
            MethodEntry methodEntry = (MethodEntry)entry;
            return this.hasMethod(methodEntry);
        }
        if (entry instanceof FieldEntry) {
            FieldEntry fieldEntry = (FieldEntry)entry;
            return this.hasField(fieldEntry);
        }
        if (entry instanceof LocalVariableEntry) {
            LocalVariableEntry localVariableEntry = (LocalVariableEntry)entry;
            return this.hasMethod((MethodEntry)localVariableEntry.getParent());
        }
        return false;
    }

    @Nullable
    public AccessFlags getMethodAccess(MethodEntry entry) {
        return (AccessFlags)this.methods.get(entry);
    }

    @Nullable
    public AccessFlags getFieldAccess(FieldEntry entry) {
        return (AccessFlags)this.fields.get(entry);
    }

    @Nullable
    public AccessFlags getClassAccess(ClassEntry entry) {
        return (AccessFlags)this.classes.get(entry);
    }

    @Nullable
    public AccessFlags getEntryAccess(Entry<?> entry) {
        if (entry instanceof MethodEntry) {
            MethodEntry methodEntry = (MethodEntry)entry;
            return this.getMethodAccess(methodEntry);
        }
        if (entry instanceof FieldEntry) {
            FieldEntry fieldEntry = (FieldEntry)entry;
            return this.getFieldAccess(fieldEntry);
        }
        if (entry instanceof LocalVariableEntry) {
            LocalVariableEntry localVariableEntry = (LocalVariableEntry)entry;
            return this.getMethodAccess((MethodEntry)localVariableEntry.getParent());
        }
        return null;
    }

    public ClassDefEntry getDefinition(ClassEntry entry) {
        return (ClassDefEntry)this.definitions.get(entry);
    }

    public Collection<ClassEntry> getClasses() {
        return this.classes.keySet();
    }

    public Collection<MethodEntry> getMethods() {
        return this.methods.keySet();
    }

    public Collection<FieldEntry> getFields() {
        return this.fields.keySet();
    }

    @Override
    public boolean hasEntry(EntryView entry) {
        if (entry instanceof ClassEntry) {
            return this.classes.containsKey(entry);
        }
        if (entry instanceof FieldEntry) {
            return this.fields.containsKey(entry);
        }
        if (entry instanceof MethodEntry) {
            return this.methods.containsKey(entry);
        }
        return false;
    }

    @Override
    public int getAccess(EntryView entry) {
        AccessFlags access;
        if (entry instanceof ClassEntry) {
            ClassEntry classEntry = (ClassEntry)entry;
            access = this.getClassAccess(classEntry);
        } else if (entry instanceof FieldEntry) {
            FieldEntry fieldEntry = (FieldEntry)entry;
            access = this.getFieldAccess(fieldEntry);
        } else if (entry instanceof MethodEntry) {
            MethodEntry methodEntry = (MethodEntry)entry;
            access = this.getMethodAccess(methodEntry);
        } else {
            return 0;
        }
        return access == null ? 0 : access.getFlags();
    }

    @Override
    public ClassDefEntryView getDefinition(ClassEntryView entry) {
        return this.getDefinition((ClassEntry)entry);
    }
}

