/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis.index;

import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.ReferenceTargetType;
import cuchaz.enigma.analysis.index.EntryIndex;
import cuchaz.enigma.analysis.index.InheritanceIndex;
import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.analysis.index.JarIndexer;
import cuchaz.enigma.analysis.index.ReferenceIndex;
import cuchaz.enigma.translation.representation.AccessFlags;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.FieldDefEntry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.MethodDefEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class PackageVisibilityIndex
implements JarIndexer {
    private final ConcurrentMap<ClassEntry, List<ClassEntry>> connections = new ConcurrentHashMap<ClassEntry, List<ClassEntry>>();
    private final List<Set<ClassEntry>> partitions = new ArrayList<Set<ClassEntry>>();
    private final Map<ClassEntry, Set<ClassEntry>> classPartitions = new HashMap<ClassEntry, Set<ClassEntry>>();

    private static boolean requiresSamePackage(AccessFlags entryAcc, EntryReference ref, InheritanceIndex inheritanceIndex) {
        if (entryAcc.isPublic()) {
            return false;
        }
        if (entryAcc.isProtected()) {
            ClassEntry contextClass = ref.context.getContainingClass();
            ClassEntry referencedClass = ref.entry.getContainingClass();
            if (!inheritanceIndex.getAncestors(contextClass).contains(referencedClass)) {
                return true;
            }
            if (ref.targetType.getKind() == ReferenceTargetType.Kind.NONE) {
                return false;
            }
            return ref.targetType.getKind() != ReferenceTargetType.Kind.UNINITIALIZED && !((ReferenceTargetType.ClassType)ref.targetType).getEntry().equals(contextClass) && !inheritanceIndex.getAncestors(((ReferenceTargetType.ClassType)ref.targetType).getEntry()).contains(contextClass);
        }
        return true;
    }

    private void addConnection(ClassEntry classA, ClassEntry classB) {
        if (classA != classB) {
            JarIndex.synchronizedAdd(this.connections, classA, classB);
            JarIndex.synchronizedAdd(this.connections, classB, classA);
        }
    }

    private void buildPartition(Set<ClassEntry> unassignedClasses, Set<ClassEntry> partition, ClassEntry member) {
        List memberConnections = (List)this.connections.get(member);
        if (memberConnections == null) {
            return;
        }
        for (ClassEntry connected : memberConnections) {
            if (!unassignedClasses.remove(connected)) continue;
            partition.add(connected);
            this.buildPartition(unassignedClasses, partition, connected);
        }
    }

    private void addConnections(EntryIndex entryIndex, ReferenceIndex referenceIndex, InheritanceIndex inheritanceIndex) {
        entryIndex.getFields().parallelStream().forEach(entry -> {
            AccessFlags entryAcc = entryIndex.getFieldAccess((FieldEntry)entry);
            if (!entryAcc.isPublic() && !entryAcc.isPrivate()) {
                for (EntryReference<FieldEntry, MethodDefEntry> ref : referenceIndex.getReferencesToField((FieldEntry)entry)) {
                    if (!PackageVisibilityIndex.requiresSamePackage(entryAcc, ref, inheritanceIndex)) continue;
                    this.addConnection(((FieldEntry)ref.entry).getContainingClass(), ((MethodDefEntry)ref.context).getContainingClass());
                }
            }
        });
        entryIndex.getMethods().parallelStream().forEach(entry -> {
            AccessFlags entryAcc = entryIndex.getMethodAccess((MethodEntry)entry);
            if (!entryAcc.isPublic() && !entryAcc.isPrivate()) {
                for (EntryReference<MethodEntry, MethodDefEntry> ref : referenceIndex.getReferencesToMethod((MethodEntry)entry)) {
                    if (!PackageVisibilityIndex.requiresSamePackage(entryAcc, ref, inheritanceIndex)) continue;
                    this.addConnection(((MethodEntry)ref.entry).getContainingClass(), ((MethodDefEntry)ref.context).getContainingClass());
                }
            }
        });
        entryIndex.getClasses().parallelStream().forEach(entry -> {
            AccessFlags entryAcc = entryIndex.getClassAccess((ClassEntry)entry);
            if (!entryAcc.isPublic() && !entryAcc.isPrivate()) {
                for (EntryReference entryReference : referenceIndex.getFieldTypeReferencesToClass((ClassEntry)entry)) {
                    if (!PackageVisibilityIndex.requiresSamePackage(entryAcc, entryReference, inheritanceIndex)) continue;
                    this.addConnection(((ClassEntry)entryReference.entry).getContainingClass(), ((FieldDefEntry)entryReference.context).getContainingClass());
                }
                for (EntryReference entryReference : referenceIndex.getMethodTypeReferencesToClass((ClassEntry)entry)) {
                    if (!PackageVisibilityIndex.requiresSamePackage(entryAcc, entryReference, inheritanceIndex)) continue;
                    this.addConnection(((ClassEntry)entryReference.entry).getContainingClass(), ((MethodDefEntry)entryReference.context).getContainingClass());
                }
            }
            for (ClassEntry classEntry : inheritanceIndex.getParents((ClassEntry)entry)) {
                AccessFlags parentAcc = entryIndex.getClassAccess(classEntry);
                if (parentAcc == null || parentAcc.isPublic() || parentAcc.isPrivate()) continue;
                this.addConnection((ClassEntry)entry, classEntry);
            }
            ClassEntry outerClass = entry.getOuterClass();
            if (outerClass != null) {
                this.addConnection((ClassEntry)entry, outerClass);
            }
        });
    }

    private void addPartitions(EntryIndex entryIndex) {
        HashSet<ClassEntry> unassignedClasses = new HashSet<ClassEntry>(entryIndex.getClasses());
        while (!unassignedClasses.isEmpty()) {
            Iterator iterator = unassignedClasses.iterator();
            ClassEntry initialEntry = (ClassEntry)iterator.next();
            iterator.remove();
            HashSet<ClassEntry> partition = new HashSet<ClassEntry>();
            partition.add(initialEntry);
            this.buildPartition(unassignedClasses, partition, initialEntry);
            this.partitions.add(partition);
            for (ClassEntry entry : partition) {
                this.classPartitions.put(entry, partition);
            }
        }
    }

    public Collection<Set<ClassEntry>> getPartitions() {
        return this.partitions;
    }

    public Set<ClassEntry> getPartition(ClassEntry classEntry) {
        return this.classPartitions.get(classEntry);
    }

    @Override
    public void processIndex(JarIndex index) {
        EntryIndex entryIndex = index.getEntryIndex();
        ReferenceIndex referenceIndex = index.getReferenceIndex();
        InheritanceIndex inheritanceIndex = index.getInheritanceIndex();
        this.addConnections(entryIndex, referenceIndex, inheritanceIndex);
        this.addPartitions(entryIndex);
    }
}

