/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.code;

import org.jetbrains.java.decompiler.code.BytecodeVersion;
import org.jetbrains.java.decompiler.code.Instruction;
import org.jetbrains.java.decompiler.code.InstructionSequence;

public class SwitchInstruction
extends Instruction {
    private int[] destinations;
    private int[] values;
    private int defaultDestination;

    public SwitchInstruction(int opcode, int group, boolean wide, BytecodeVersion bytecodeVersion, int[] operands, int length) {
        super(opcode, group, wide, bytecodeVersion, operands, length);
    }

    @Override
    public void initInstruction(InstructionSequence seq) {
        this.defaultDestination = seq.getPointerByRelOffset(this.operands[0]);
        int prefix = this.opcode == 170 ? 3 : 2;
        int len = this.operands.length - prefix;
        int low = 0;
        if (this.opcode == 171) {
            len /= 2;
        } else {
            low = this.operands[1];
        }
        this.destinations = new int[len];
        this.values = new int[len];
        int i = 0;
        int k = 0;
        while (i < len) {
            if (this.opcode == 171) {
                this.values[i] = this.operands[prefix + k];
                ++k;
            } else {
                this.values[i] = low + k;
            }
            this.destinations[i] = seq.getPointerByRelOffset(this.operands[prefix + k]);
            ++i;
            ++k;
        }
    }

    public int[] getDestinations() {
        return this.destinations;
    }

    public int[] getValues() {
        return this.values;
    }

    public int getDefaultDestination() {
        return this.defaultDestination;
    }

    @Override
    public SwitchInstruction clone() {
        SwitchInstruction copy = (SwitchInstruction)super.clone();
        copy.defaultDestination = this.defaultDestination;
        copy.destinations = (int[])this.destinations.clone();
        copy.values = (int[])this.values.clone();
        return copy;
    }
}

