/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.flow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.ValidationHelper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectEdge;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectNode;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectNodeType;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchAllStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DoStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DummyExitStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SequenceStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SwitchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SynchronizedStatement;
import org.jetbrains.java.decompiler.util.DotExporter;
import org.jetbrains.java.decompiler.util.collections.ListStack;
import org.jetbrains.java.decompiler.util.collections.VBStyleCollection;

public class FlattenStatementsHelper {
    private final Map<Statement, DirectNode> mapRegularDestinationNodes = new HashMap<Statement, DirectNode>();
    private final Map<Statement, DirectNode> mapContinueDestinationNodes = new HashMap<Statement, DirectNode>();
    private final List<Edge> indirectEdges = new ArrayList<Edge>();
    private final Map<DirectNode, Statement> mapPosIfBranch = new HashMap<DirectNode, Statement>();
    private final ListStack<List<DirectNode>> tryNodesStack = new ListStack();
    private final ListStack<DirectNode> finallyNodesStack = new ListStack();
    private DirectGraph graph;
    private RootStatement root;

    public static DirectGraph build(RootStatement root) {
        return new FlattenStatementsHelper().buildDirectGraph(root);
    }

    public DirectGraph buildDirectGraph(RootStatement root) {
        this.root = root;
        this.graph = new DirectGraph();
        this.graph.first = this.flattenStatement(root);
        DummyExitStatement dummyexit = root.getDummyExit();
        DirectNode node = this.createDirectNode(dummyexit);
        this.addDestination(dummyexit, node);
        this.setEdges();
        this.graph.sortReversePostOrder();
        return this.graph;
    }

    private void addDestination(Statement stat, DirectNode node) {
        this.addDestination(stat, node, Edge.Type.REGULAR);
    }

    private void addDestination(Statement stat, DirectNode node, Edge.Type type) {
        switch (type) {
            case REGULAR: {
                this.mapRegularDestinationNodes.put(stat, node);
                break;
            }
            case CONTINUE: {
                this.mapContinueDestinationNodes.put(stat, node);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected edge type: " + type);
            }
        }
    }

    private DirectNode createDirectNode(Statement stat) {
        DirectNode directNode = this.createDirectNode(stat, DirectNodeType.DIRECT);
        if (stat instanceof BasicBlockStatement) {
            directNode.block = (BasicBlockStatement)stat;
        }
        return directNode;
    }

    private DirectNode createDirectNode(Statement stat, List<Exprent> exprents) {
        DirectNode node = this.createDirectNode(stat);
        if (exprents != null) {
            node.exprents = exprents;
        }
        return node;
    }

    private DirectNode createDirectNode(Statement stat, DirectNodeType type) {
        DirectNode node = DirectNode.forStat(type, stat, this.finallyNodesStack.isEmpty() ? null : this.finallyNodesStack.peek());
        this.graph.nodes.addWithKey(node, node.id);
        if (!this.tryNodesStack.isEmpty()) {
            this.tryNodesStack.peek().add(node);
        }
        return node;
    }

    private DirectNode createDirectNode(Statement stat, DirectNodeType type, List<Exprent> exprents) {
        DirectNode node = this.createDirectNode(stat, type);
        if (exprents != null) {
            node.exprents = exprents;
        }
        return node;
    }

    private DirectNode flattenStatement(Statement stat) {
        switch (stat.type) {
            case BASIC_BLOCK: {
                StatEdge predEdge;
                List<StatEdge> basicPreds;
                DirectNode node = this.createDirectNode(stat);
                this.addDestination(stat, node);
                if (stat.getExprents() != null) {
                    node.exprents = stat.getExprents();
                }
                if (stat.getLastBasicType() == Statement.LastBasicType.IF) {
                    if (!stat.hasAnyDirectSuccessor()) {
                        throw new IllegalStateException("Empty successor list for node " + node.id);
                    }
                    this.mapPosIfBranch.put(node, stat.getFirstDirectSuccessor().getDestination());
                }
                if ((basicPreds = stat.getAllPredecessorEdges()).size() == 1 && (predEdge = basicPreds.get(0)).getType() == 1 && predEdge.getSource() instanceof SequenceStatement) {
                    this.addEdgeIfPossible(predEdge.getSource().getBasichead(), stat);
                }
                this.addEdges(node, stat.getSuccessorEdges(0x40000000));
                return node;
            }
            case CATCH_ALL: 
            case TRY_CATCH: {
                CatchStatement catchStat;
                List<Exprent> resources;
                int endCatchIndex;
                DirectNode node = this.createDirectNode(stat, DirectNodeType.TRY);
                this.addDestination(stat, node);
                boolean isFinally = stat instanceof CatchAllStatement && ((CatchAllStatement)stat).isFinally();
                VBStyleCollection<Statement, Integer> stats = stat.getStats();
                int n = endCatchIndex = isFinally ? stats.size() - 1 : stats.size();
                if (stat instanceof CatchStatement && !(resources = (catchStat = (CatchStatement)stat).getResources()).isEmpty()) {
                    node.exprents = resources;
                }
                if (isFinally) {
                    this.finallyNodesStack.push(this.createDirectNode(stat, DirectNodeType.FINALLY));
                }
                ArrayList tryNodes = new ArrayList();
                this.tryNodesStack.add(tryNodes);
                DirectNode tryBlock = this.flattenStatement(stat.getFirst());
                node.addSuccessor(DirectEdge.of(node, tryBlock));
                ValidationHelper.validateTrue(tryNodes == this.tryNodesStack.pop(), "tryNodesStack is broken");
                if (!this.tryNodesStack.isEmpty()) {
                    this.tryNodesStack.peek().addAll(tryNodes);
                }
                DirectNode combinedCatchNode = this.createDirectNode(stat, DirectNodeType.COMBINED_CATCH);
                for (DirectNode innerTryNode : tryNodes) {
                    innerTryNode.addSuccessor(DirectEdge.exception(innerTryNode, combinedCatchNode));
                }
                node.addSuccessor(DirectEdge.of(node, combinedCatchNode));
                for (int i = 1; i < endCatchIndex; ++i) {
                    Statement st = (Statement)stats.get(i);
                    DirectNode catchNode = this.createDirectNode(st, DirectNodeType.CATCH);
                    DirectNode handlerNode = this.flattenStatement(st);
                    combinedCatchNode.addSuccessor(DirectEdge.of(combinedCatchNode, catchNode));
                    catchNode.addSuccessor(DirectEdge.of(catchNode, handlerNode));
                }
                if (isFinally) {
                    Statement st = (Statement)stats.get(endCatchIndex);
                    DirectNode finallyNode = this.finallyNodesStack.pop();
                    ValidationHelper.validateTrue(finallyNode.statement == stat && finallyNode.type == DirectNodeType.FINALLY, "stackFinally is broken");
                    combinedCatchNode.addSuccessor(DirectEdge.of(combinedCatchNode, finallyNode));
                    this.finallyNodesStack.push(this.createDirectNode(stat, DirectNodeType.FINALLY_END));
                    DirectNode finallyBlockNode = this.flattenStatement(st);
                    finallyNode.addSuccessor(DirectEdge.of(finallyNode, finallyBlockNode));
                    DirectNode finallyEndNode = this.finallyNodesStack.pop();
                    ValidationHelper.validateTrue(finallyEndNode.statement == stat && finallyEndNode.type == DirectNodeType.FINALLY_END, "stackFinally is broken");
                }
                return node;
            }
            case DO: {
                List<StatEdge> prededges;
                Statement dest;
                if (!stat.hasBasicSuccEdge() && stat.hasSuccessor(1) && (dest = stat.getSuccessorEdges(1).get(0).getDestination()).getAllPredecessorEdges().size() == 1 && !(prededges = stat.getPredecessorEdges(1)).isEmpty()) {
                    StatEdge prededge = prededges.get(0);
                    this.addEdgeIfPossible(prededge.getSource(), dest);
                }
                DirectNode body = this.flattenStatement(stat.getFirst());
                DoStatement doStat = (DoStatement)stat;
                DoStatement.Type loopType = doStat.getLooptype();
                switch (loopType) {
                    case INFINITE: {
                        this.addDestination(stat, body);
                        this.addDestination(stat, body, Edge.Type.CONTINUE);
                        return body;
                    }
                    case WHILE: {
                        DirectNode conditionNode = this.createDirectNode(stat, DirectNodeType.CONDITION, doStat.getConditionExprentList());
                        conditionNode.addSuccessor(DirectEdge.of(conditionNode, body));
                        this.addDestination(stat, conditionNode);
                        this.addDestination(stat, conditionNode, Edge.Type.CONTINUE);
                        this.addEdge(conditionNode, stat.getFirstSuccessor());
                        return conditionNode;
                    }
                    case DO_WHILE: {
                        DirectNode conditionNode = this.createDirectNode(stat, DirectNodeType.CONDITION, doStat.getConditionExprentList());
                        conditionNode.addSuccessor(DirectEdge.of(conditionNode, body));
                        this.addDestination(stat, body);
                        this.addDestination(stat, conditionNode, Edge.Type.CONTINUE);
                        this.handleLoopEnd(stat, body);
                        this.addEdge(conditionNode, stat.getFirstSuccessor());
                        return body;
                    }
                    case FOR: {
                        DirectNode initNode = this.createDirectNode(stat, DirectNodeType.INIT);
                        if (doStat.getInitExprent() != null) {
                            initNode.exprents = doStat.getInitExprentList();
                        }
                        DirectNode conditionNode = this.createDirectNode(stat, DirectNodeType.CONDITION, doStat.getConditionExprentList());
                        DirectNode incrementNode = this.createDirectNode(stat, DirectNodeType.INCREMENT, doStat.getIncExprentList());
                        this.addDestination(stat, initNode);
                        this.addDestination(stat, incrementNode, Edge.Type.CONTINUE);
                        conditionNode.addSuccessor(DirectEdge.of(conditionNode, body));
                        initNode.addSuccessor(DirectEdge.of(initNode, conditionNode));
                        incrementNode.addSuccessor(DirectEdge.of(incrementNode, conditionNode));
                        this.handleLoopEnd(stat, body);
                        this.addEdge(conditionNode, stat.getFirstSuccessor());
                        return initNode;
                    }
                    case FOR_EACH: {
                        DirectNode inc = this.createDirectNode(stat, DirectNodeType.INCREMENT, doStat.getIncExprentList());
                        DirectNode init = this.createDirectNode(stat, DirectNodeType.FOREACH_VARDEF, doStat.getInitExprentList());
                        this.addDestination(stat, inc);
                        this.addDestination(stat, init, Edge.Type.CONTINUE);
                        init.addSuccessor(DirectEdge.of(init, body));
                        inc.addSuccessor(DirectEdge.of(inc, init));
                        this.handleLoopEnd(stat, body);
                        this.addEdge(init, stat.getFirstSuccessor());
                        return inc;
                    }
                }
                throw new RuntimeException("Unknown loop type: " + loopType);
            }
            case SYNCHRONIZED: {
                List<Exprent> tailexprlst = ((SynchronizedStatement)stat).getHeadexprentList();
                Statement first = stat.getFirst();
                DirectNode firstNode = this.createDirectNode(first, first.getExprents());
                this.addDestination(first, firstNode);
                this.addDestination(stat, firstNode);
                if (tailexprlst != null && tailexprlst.get(0) != null) {
                    DirectNode tail = this.createDirectNode(stat, DirectNodeType.TAIL, tailexprlst);
                    firstNode.addSuccessor(DirectEdge.of(firstNode, tail));
                    this.addEdges(tail, first.getAllDirectSuccessorEdges());
                } else {
                    this.addEdges(firstNode, first.getAllDirectSuccessorEdges());
                }
                this.flattenStatement((Statement)stat.getStats().get(1));
                this.handleTailedStat(stat);
                return firstNode;
            }
            case SWITCH: {
                DirectNode firstNode;
                SwitchStatement switchSt = (SwitchStatement)stat;
                List<Exprent> tailexprlst = switchSt.getHeadexprentList();
                Statement first = stat.getFirst();
                DirectNode outNode = firstNode = this.createDirectNode(first, first.getExprents());
                this.addDestination(first, firstNode);
                this.addDestination(stat, firstNode);
                if (tailexprlst != null && tailexprlst.get(0) != null) {
                    DirectNode tail = this.createDirectNode(stat, DirectNodeType.TAIL, tailexprlst);
                    firstNode.addSuccessor(DirectEdge.of(firstNode, tail));
                    outNode = tail;
                }
                this.handleTailedStat(stat);
                for (int i = 1; i < stat.getStats().size(); ++i) {
                    this.flattenStatement((Statement)stat.getStats().get(i));
                }
                List<List<StatEdge>> caseEdges = switchSt.getCaseEdges();
                List<List<Exprent>> caseValues = switchSt.getCaseValues();
                List<Statement> caseStatements = switchSt.getCaseStatements();
                if (caseEdges.size() != caseValues.size() && (caseEdges.size() + 1 != caseValues.size() || caseValues.get(caseValues.size() - 1).size() != 1 || caseValues.get(caseValues.size() - 1).get(0) != null)) {
                    throw new IllegalStateException("Case edges and case values do not match");
                }
                for (int i = 0; i < caseEdges.size(); ++i) {
                    List<Exprent> values = caseValues.get(i);
                    List<StatEdge> thisCaseEdges = caseEdges.get(i);
                    Statement thisCaseStatement = caseStatements.get(i);
                    ArrayList<Exprent> finalVals = null;
                    if (values != null) {
                        finalVals = new ArrayList<Exprent>();
                        for (Exprent value : values) {
                            if (value == null) continue;
                            finalVals.add(value);
                        }
                    }
                    DirectNode caseNode = this.createDirectNode(thisCaseStatement, DirectNodeType.CASE, finalVals);
                    outNode.addSuccessor(DirectEdge.of(outNode, caseNode));
                    this.addEdges(caseNode, thisCaseEdges);
                }
                if (caseEdges.size() < caseValues.size()) {
                    this.addEdge(outNode, switchSt.getDefaultEdge());
                }
                return firstNode;
            }
            case IF: {
                DirectNode firstNode;
                IfStatement ifStat = (IfStatement)stat;
                List<Exprent> tailexprlst = ifStat.getHeadexprentList();
                Statement first = stat.getFirst();
                DirectNode outNode = firstNode = this.createDirectNode(first, first.getExprents());
                this.addDestination(first, firstNode);
                this.addDestination(stat, firstNode);
                if (tailexprlst != null && tailexprlst.get(0) != null) {
                    DirectNode tail = this.createDirectNode(stat, DirectNodeType.TAIL, tailexprlst);
                    firstNode.addSuccessor(DirectEdge.of(firstNode, tail));
                    outNode = tail;
                }
                this.mapPosIfBranch.put(outNode, ifStat.getIfEdge().getDestination());
                this.handleTailedStat(stat);
                for (int i = 1; i < stat.getStats().size(); ++i) {
                    this.flattenStatement((Statement)stat.getStats().get(i));
                }
                this.addEdges(outNode, first.getAllDirectSuccessorEdges());
                if (ifStat.iftype == 0 && stat.hasAnyDirectSuccessor()) {
                    this.addEdge(outNode, stat.getFirstDirectSuccessor());
                }
                return firstNode;
            }
            case SEQUENCE: 
            case ROOT: {
                DirectNode firstBlock = this.flattenStatement(stat.getFirst());
                int statsize = stat.getStats().size();
                for (int i = 1; i < statsize; ++i) {
                    this.flattenStatement((Statement)stat.getStats().get(i));
                }
                this.addDestination(stat, firstBlock);
                return firstBlock;
            }
        }
        throw new RuntimeException("Unexpected statement type");
    }

    private void handleTailedStat(Statement stat) {
        StatEdge predEdge;
        List<StatEdge> basicPreds = stat.getAllPredecessorEdges();
        if (basicPreds.size() == 1 && (predEdge = basicPreds.get(0)).getType() == 1 && predEdge.getSource() instanceof SequenceStatement) {
            this.addEdgeIfPossible(predEdge.getSource().getBasichead(), stat);
        }
    }

    private void handleLoopEnd(Statement stat, DirectNode body) {
        for (Edge edge : this.indirectEdges) {
            if (edge.stat != stat || edge.type != Edge.Type.CONTINUE) continue;
            return;
        }
        this.indirectEdges.add(new Edge(body, stat, Edge.Type.CONTINUE));
    }

    private void addEdges(DirectNode sourceNode, List<StatEdge> lstSuccEdges) {
        for (StatEdge edge : lstSuccEdges) {
            this.addEdge(sourceNode, edge);
        }
    }

    private void addEdge(DirectNode sourceNode, StatEdge edge) {
        int edgeType = edge.getType();
        Statement destination = edge.getDestination();
        this.saveEdge(sourceNode, destination, edgeType);
    }

    private void saveEdge(DirectNode sourceNode, Statement destination, int edgeType) {
        this.indirectEdges.add(new Edge(sourceNode, destination, edgeType));
    }

    private void addEdgeIfPossible(Statement predEdge, Statement stat) {
        DirectNode lastBasic = this.mapRegularDestinationNodes.get(predEdge);
        if (lastBasic != null) {
            this.indirectEdges.add(new Edge(lastBasic, stat, Edge.Type.REGULAR));
        }
    }

    private void setEdges() {
        for (Edge edge : this.indirectEdges) {
            DirectNode source = edge.source;
            DirectNode dest = this.getDestination(edge);
            if (dest == null) {
                DotExporter.toDotFile(this.graph, this.root.mt, "errorDGraph");
                throw new IllegalStateException("Could not find destination nodes for stat id " + edge.stat + " from source " + source);
            }
            if (edge.type == Edge.Type.FINALLY_EXIT) {
                if (source.tryFinally == null || source.tryFinally.type != DirectNodeType.FINALLY_END) continue;
                dest = source.tryFinally;
            }
            DirectEdge diedge = edge.type == Edge.Type.EXCEPTION ? DirectEdge.exception(source, dest) : DirectEdge.of(source, dest);
            source.addSuccessor(diedge);
            if (!this.mapPosIfBranch.containsKey(source) || edge.stat == this.mapPosIfBranch.get(source)) continue;
            this.graph.mapNegIfBranch.put(source.id, dest.id);
        }
    }

    public DirectNode getDirectNode(Statement stat) {
        return this.mapRegularDestinationNodes.get(stat);
    }

    private DirectNode getDestination(Edge edge) {
        return (edge.type == Edge.Type.CONTINUE ? this.mapContinueDestinationNodes : this.mapRegularDestinationNodes).get(edge.stat);
    }

    private static class Edge {
        public DirectNode source;
        public Statement stat;
        final Type type;

        Edge(DirectNode source, Statement stat, int edgetype) {
            this.source = source;
            this.stat = stat;
            this.type = edgetype == 8 ? Type.CONTINUE : (edgetype == 32 ? Type.FINALLY_EXIT : (edgetype == 2 ? Type.EXCEPTION : Type.REGULAR));
        }

        Edge(DirectNode source, Statement stat, Type type) {
            this.source = source;
            this.stat = stat;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Edge edge = (Edge)o;
            return this.type == edge.type && Objects.equals(this.source, edge.source) && Objects.equals(this.stat, edge.stat);
        }

        public String toString() {
            return "Source: " + this.source + " Dest: " + this.stat + " Edge: " + this.type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.source, this.stat, this.type});
        }

        static enum Type {
            REGULAR,
            CONTINUE,
            EXCEPTION,
            FINALLY_EXIT;

        }
    }
}

