/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.network.packet;

import cuchaz.enigma.network.Message;
import cuchaz.enigma.network.ServerPacketHandler;
import cuchaz.enigma.network.packet.Packet;
import cuchaz.enigma.network.packet.PacketHelper;
import cuchaz.enigma.network.packet.RenameS2CPacket;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.utils.validation.PrintValidatable;
import cuchaz.enigma.utils.validation.Validatable;
import cuchaz.enigma.utils.validation.ValidationContext;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class RenameC2SPacket
implements Packet<ServerPacketHandler> {
    private Entry<?> entry;
    private String newName;
    private boolean refreshClassTree;

    RenameC2SPacket() {
    }

    public RenameC2SPacket(Entry<?> entry, String newName, boolean refreshClassTree) {
        this.entry = entry;
        this.newName = newName;
        this.refreshClassTree = refreshClassTree;
    }

    @Override
    public void read(DataInput input) throws IOException {
        this.entry = PacketHelper.readEntry(input);
        this.newName = PacketHelper.readString(input);
        this.refreshClassTree = input.readBoolean();
    }

    @Override
    public void write(DataOutput output) throws IOException {
        PacketHelper.writeEntry(output, this.entry);
        PacketHelper.writeString(output, this.newName);
        output.writeBoolean(this.refreshClassTree);
    }

    @Override
    public void handle(ServerPacketHandler handler) {
        ValidationContext vc = new ValidationContext();
        vc.setActiveElement((Validatable)PrintValidatable.INSTANCE);
        boolean valid = handler.getServer().canModifyEntry(handler.getClient(), this.entry);
        if (valid) {
            EntryMapping previous = handler.getServer().getMappings().getDeobfMapping(this.entry);
            handler.getServer().getMappings().mapFromObf(vc, this.entry, previous != null ? previous.withName(this.newName) : new EntryMapping(this.newName));
            valid = vc.canProceed();
        }
        if (!valid) {
            handler.getServer().sendCorrectMapping(handler.getClient(), this.entry, this.refreshClassTree);
            return;
        }
        handler.getServer().log(handler.getServer().getUsername(handler.getClient()) + " renamed " + this.entry + " to " + this.newName);
        int syncId = handler.getServer().lockEntry(handler.getClient(), this.entry);
        handler.getServer().sendToAllExcept(handler.getClient(), new RenameS2CPacket(syncId, this.entry, this.newName, this.refreshClassTree));
        handler.getServer().sendMessage(Message.rename(handler.getServer().getUsername(handler.getClient()), this.entry, this.newName));
    }
}

