/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.network.packet;

import cuchaz.enigma.translation.representation.MethodDescriptor;
import cuchaz.enigma.translation.representation.TypeDescriptor;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.LocalVariableEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class PacketHelper {
    private static final int ENTRY_CLASS = 0;
    private static final int ENTRY_FIELD = 1;
    private static final int ENTRY_METHOD = 2;
    private static final int ENTRY_LOCAL_VAR = 3;
    private static final int MAX_STRING_LENGTH = 65535;

    public static Entry<?> readEntry(DataInput input) throws IOException {
        return PacketHelper.readEntry(input, null, true);
    }

    public static Entry<?> readEntry(DataInput input, Entry<?> parent, boolean includeParent) throws IOException {
        int type = input.readUnsignedByte();
        if (includeParent && input.readBoolean()) {
            parent = PacketHelper.readEntry(input, null, true);
        }
        String name = PacketHelper.readString(input);
        String javadocs = null;
        if (input.readBoolean()) {
            javadocs = PacketHelper.readString(input);
        }
        switch (type) {
            case 0: {
                if (parent != null && !(parent instanceof ClassEntry)) {
                    throw new IOException("Class requires class parent");
                }
                return new ClassEntry((ClassEntry)parent, name, javadocs);
            }
            case 1: {
                if (!(parent instanceof ClassEntry)) {
                    throw new IOException("Field requires class parent");
                }
                TypeDescriptor desc = new TypeDescriptor(PacketHelper.readString(input));
                return new FieldEntry((ClassEntry)parent, name, desc, javadocs);
            }
            case 2: {
                if (!(parent instanceof ClassEntry)) {
                    throw new IOException("Method requires class parent");
                }
                MethodDescriptor desc = new MethodDescriptor(PacketHelper.readString(input));
                return new MethodEntry((ClassEntry)parent, name, desc, javadocs);
            }
            case 3: {
                if (!(parent instanceof MethodEntry)) {
                    throw new IOException("Local variable requires method parent");
                }
                int index = input.readUnsignedShort();
                boolean parameter = input.readBoolean();
                return new LocalVariableEntry((MethodEntry)parent, index, name, parameter, javadocs);
            }
        }
        throw new IOException("Received unknown entry type " + type);
    }

    public static void writeEntry(DataOutput output, Entry<?> entry) throws IOException {
        PacketHelper.writeEntry(output, entry, true);
    }

    public static void writeEntry(DataOutput output, Entry<?> entry, boolean includeParent) throws IOException {
        if (entry instanceof ClassEntry) {
            output.writeByte(0);
        } else if (entry instanceof FieldEntry) {
            output.writeByte(1);
        } else if (entry instanceof MethodEntry) {
            output.writeByte(2);
        } else if (entry instanceof LocalVariableEntry) {
            output.writeByte(3);
        } else {
            throw new IOException("Don't know how to serialize entry of type " + entry.getClass().getSimpleName());
        }
        if (includeParent) {
            output.writeBoolean(entry.getParent() != null);
            if (entry.getParent() != null) {
                PacketHelper.writeEntry(output, entry.getParent(), true);
            }
        }
        PacketHelper.writeString(output, entry.getName());
        output.writeBoolean(entry.getJavadocs() != null);
        if (entry.getJavadocs() != null) {
            PacketHelper.writeString(output, entry.getJavadocs());
        }
        if (entry instanceof FieldEntry) {
            PacketHelper.writeString(output, ((FieldEntry)entry).getDesc().toString());
        } else if (entry instanceof MethodEntry) {
            PacketHelper.writeString(output, ((MethodEntry)entry).getDesc().toString());
        } else if (entry instanceof LocalVariableEntry) {
            LocalVariableEntry localVar = (LocalVariableEntry)entry;
            output.writeShort(localVar.getIndex());
            output.writeBoolean(localVar.isArgument());
        }
    }

    public static String readString(DataInput input) throws IOException {
        int length = input.readUnsignedShort();
        byte[] bytes = new byte[length];
        input.readFully(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static void writeString(DataOutput output, String str) throws IOException {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        if (bytes.length > 65535) {
            throw new IOException("String too long, was " + bytes.length + " bytes, max " + 65535 + " allowed");
        }
        output.writeShort(bytes.length);
        output.write(bytes);
    }
}

