/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.network.packet;

import cuchaz.enigma.network.ClientPacketHandler;
import cuchaz.enigma.network.packet.ConfirmChangeC2SPacket;
import cuchaz.enigma.network.packet.Packet;
import cuchaz.enigma.network.packet.PacketHelper;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.translation.mapping.tree.EntryTreeNode;
import cuchaz.enigma.translation.mapping.tree.HashEntryTree;
import cuchaz.enigma.translation.representation.entry.Entry;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class SyncMappingsS2CPacket
implements Packet<ClientPacketHandler> {
    private EntryTree<EntryMapping> mappings;

    SyncMappingsS2CPacket() {
    }

    public SyncMappingsS2CPacket(EntryTree<EntryMapping> mappings) {
        this.mappings = mappings;
    }

    @Override
    public void read(DataInput input) throws IOException {
        this.mappings = new HashEntryTree();
        int size = input.readInt();
        for (int i = 0; i < size; ++i) {
            this.readEntryTreeNode(input, null);
        }
    }

    private void readEntryTreeNode(DataInput input, Entry<?> parent) throws IOException {
        Entry<?> entry = PacketHelper.readEntry(input, parent, false);
        EntryMapping mapping = null;
        if (input.readBoolean()) {
            String name = input.readUTF();
            if (input.readBoolean()) {
                String javadoc = input.readUTF();
                mapping = new EntryMapping(name, javadoc);
            } else {
                mapping = new EntryMapping(name);
            }
        }
        this.mappings.insert(entry, mapping);
        int size = input.readUnsignedShort();
        for (int i = 0; i < size; ++i) {
            this.readEntryTreeNode(input, entry);
        }
    }

    @Override
    public void write(DataOutput output) throws IOException {
        List roots = this.mappings.getRootNodes().collect(Collectors.toList());
        output.writeInt(roots.size());
        for (EntryTreeNode node : roots) {
            SyncMappingsS2CPacket.writeEntryTreeNode(output, (EntryTreeNode<EntryMapping>)node);
        }
    }

    private static void writeEntryTreeNode(DataOutput output, EntryTreeNode<EntryMapping> node) throws IOException {
        PacketHelper.writeEntry(output, node.getEntry(), false);
        EntryMapping value = (EntryMapping)node.getValue();
        output.writeBoolean(value != null);
        if (value != null) {
            PacketHelper.writeString(output, value.getTargetName());
            output.writeBoolean(value.getJavadoc() != null);
            if (value.getJavadoc() != null) {
                PacketHelper.writeString(output, value.getJavadoc());
            }
        }
        Collection children = node.getChildNodes();
        output.writeShort(children.size());
        for (EntryTreeNode child : children) {
            SyncMappingsS2CPacket.writeEntryTreeNode(output, (EntryTreeNode<EntryMapping>)child);
        }
    }

    @Override
    public void handle(ClientPacketHandler controller) {
        controller.openMappings(this.mappings);
        controller.sendPacket(new ConfirmChangeC2SPacket(0));
    }
}

