/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.network;

import cuchaz.enigma.Enigma;
import cuchaz.enigma.EnigmaProfile;
import cuchaz.enigma.EnigmaProject;
import cuchaz.enigma.ProgressListener;
import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.network.EnigmaServer;
import cuchaz.enigma.translation.mapping.EntryRemapper;
import cuchaz.enigma.translation.mapping.serde.MappingFormat;
import cuchaz.enigma.translation.mapping.serde.MappingParseException;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.utils.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.ValueConverter;

public class DedicatedEnigmaServer
extends EnigmaServer {
    private final EnigmaProfile profile;
    private final MappingFormat mappingFormat;
    private final Path mappingsFile;
    private final PrintWriter log;
    private BlockingQueue<Runnable> tasks = new LinkedBlockingDeque<Runnable>();

    public DedicatedEnigmaServer(byte[] jarChecksum, char[] password, EnigmaProfile profile, MappingFormat mappingFormat, Path mappingsFile, PrintWriter log, EntryRemapper mappings, int port) {
        super(jarChecksum, password, mappings, port);
        this.profile = profile;
        this.mappingFormat = mappingFormat;
        this.mappingsFile = mappingsFile;
        this.log = log;
    }

    @Override
    protected void runOnThread(Runnable task) {
        this.tasks.add(task);
    }

    @Override
    public void log(String message) {
        super.log(message);
        this.log.println(message);
    }

    public static void main(String[] args) {
        DedicatedEnigmaServer server;
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec jarOpt = parser.accepts("jar", "Jar file to open at startup; if there are multiple jars, the order must be the same between the server and all clients").withRequiredArg().required().withValuesConvertedBy(PathConverter.INSTANCE);
        ArgumentAcceptingOptionSpec librariesOpt = parser.accepts("library", "Library file used by the jar").withRequiredArg().withValuesConvertedBy(PathConverter.INSTANCE);
        ArgumentAcceptingOptionSpec mappingsOpt = parser.accepts("mappings", "Mappings file to open at startup").withRequiredArg().required().withValuesConvertedBy(PathConverter.INSTANCE);
        ArgumentAcceptingOptionSpec profileOpt = parser.accepts("profile", "Profile json to apply at startup").withRequiredArg().withValuesConvertedBy(PathConverter.INSTANCE);
        ArgumentAcceptingOptionSpec portOpt = parser.accepts("port", "Port to run the server on").withOptionalArg().ofType(Integer.class).defaultsTo((Object)34712, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec passwordOpt = parser.accepts("password", "The password to join the server").withRequiredArg().defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec logFileOpt = parser.accepts("log", "The log file to write to").withRequiredArg().withValuesConvertedBy(PathConverter.INSTANCE).defaultsTo((Object)Paths.get("log.txt", new String[0]), (Object[])new Path[0]);
        OptionSet parsedArgs = parser.parse(args);
        List jars = parsedArgs.valuesOf((OptionSpec)jarOpt);
        Path mappingsFile = (Path)parsedArgs.valueOf((OptionSpec)mappingsOpt);
        Path profileFile = (Path)parsedArgs.valueOf((OptionSpec)profileOpt);
        int port = (Integer)parsedArgs.valueOf((OptionSpec)portOpt);
        char[] password = ((String)parsedArgs.valueOf((OptionSpec)passwordOpt)).toCharArray();
        if (password.length > 255) {
            System.err.println("Password too long, must be at most 255 characters");
            System.exit(1);
        }
        Path logFile = (Path)parsedArgs.valueOf((OptionSpec)logFileOpt);
        System.out.println("Starting Enigma server");
        try {
            EntryRemapper mappings;
            byte[] checksum = Utils.zipSha1((Path[])jars.toArray(new Path[0]));
            EnigmaProfile profile = EnigmaProfile.read((Path)profileFile);
            Enigma enigma = Enigma.builder().setProfile(profile).build();
            System.out.println("Indexing Jar...");
            EnigmaProject project = enigma.openJars(jars, parsedArgs.valuesOf((OptionSpec)librariesOpt), ProgressListener.none());
            MappingFormat mappingFormat = MappingFormat.ENIGMA_DIRECTORY;
            if (!Files.exists(mappingsFile, new LinkOption[0])) {
                mappings = EntryRemapper.empty((JarIndex)project.getJarIndex());
            } else {
                System.out.println("Reading mappings...");
                mappingFormat = Files.isDirectory(mappingsFile, new LinkOption[0]) ? MappingFormat.ENIGMA_DIRECTORY : MappingFormat.ENIGMA_FILE;
                mappings = EntryRemapper.mapped((JarIndex)project.getJarIndex(), (EntryTree)mappingFormat.read(mappingsFile, ProgressListener.none(), profile.getMappingSaveParameters(), project.getJarIndex()));
            }
            PrintWriter log = new PrintWriter(Files.newBufferedWriter(logFile, new OpenOption[0]));
            server = new DedicatedEnigmaServer(checksum, password, profile, mappingFormat, mappingsFile, log, mappings, port);
            server.start();
            System.out.println("Server started");
        }
        catch (MappingParseException | IOException e) {
            System.err.println("Error starting server!");
            e.printStackTrace();
            System.exit(1);
            return;
        }
        Executors.newScheduledThreadPool(1).scheduleAtFixedRate(() -> server.runOnThread(() -> server.saveMappings()), 0L, 1L, TimeUnit.MINUTES);
        Runtime.getRuntime().addShutdownHook(new Thread(server::saveMappings));
        try {
            while (true) {
                server.tasks.take().run();
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }

    @Override
    public synchronized void stop() {
        super.stop();
        System.exit(0);
    }

    private void saveMappings() {
        this.mappingFormat.write((EntryTree)this.getMappings().getObfToDeobf(), this.getMappings().takeMappingDelta(), this.mappingsFile, ProgressListener.none(), this.profile.getMappingSaveParameters());
        this.log.flush();
    }

    public static class PathConverter
    implements ValueConverter<Path> {
        public static final ValueConverter<Path> INSTANCE = new PathConverter();

        PathConverter() {
        }

        public Path convert(String path) {
            if (path.startsWith("~")) {
                Path dirHome = Paths.get(System.getProperty("user.home"), new String[0]);
                if (path.startsWith("~/")) {
                    return dirHome.resolve(path.substring(2));
                }
                return dirHome.getParent().resolve(path.substring(1));
            }
            return Paths.get(path, new String[0]);
        }

        public Class<? extends Path> valueType() {
            return Path.class;
        }

        public String valuePattern() {
            return "path";
        }
    }
}

