/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.config;

import com.bulenkov.darcula.DarculaLaf;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import cuchaz.enigma.source.DecompilerService;
import cuchaz.enigma.source.Decompilers;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class Config {
    private static final File DIR_HOME = new File(System.getProperty("user.home"));
    private static final File ENIGMA_DIR = new File(DIR_HOME, ".enigma");
    private static final File CONFIG_FILE = new File(ENIGMA_DIR, "config.json");
    private static final Config INSTANCE = new Config();
    private final transient Gson gson;
    public AlphaColorEntry obfuscatedColor;
    public AlphaColorEntry obfuscatedColorOutline;
    public AlphaColorEntry proposedColor;
    public AlphaColorEntry proposedColorOutline;
    public AlphaColorEntry deobfuscatedColor;
    public AlphaColorEntry deobfuscatedColorOutline;
    public Integer editorBackground;
    public Integer highlightColor;
    public Integer caretColor;
    public Integer selectionHighlightColor;
    public Integer stringColor;
    public Integer numberColor;
    public Integer operatorColor;
    public Integer delimiterColor;
    public Integer typeColor;
    public Integer identifierColor;
    public Integer defaultTextColor;
    public Integer lineNumbersBackground;
    public Integer lineNumbersSelected;
    public Integer lineNumbersForeground;
    public String language = "en_us";
    public LookAndFeel lookAndFeel = LookAndFeel.DEFAULT;
    public float scaleFactor = 1.0f;
    public Decompiler decompiler = Decompiler.PROCYON;

    private Config() {
        this.gson = new GsonBuilder().registerTypeAdapter(Integer.class, (Object)new IntSerializer()).registerTypeAdapter(Integer.class, (Object)new IntDeserializer()).registerTypeAdapter(Config.class, type -> this).setPrettyPrinting().create();
        try {
            this.loadConfig();
        }
        catch (IOException ignored) {
            try {
                this.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void loadConfig() throws IOException {
        if (!ENIGMA_DIR.exists()) {
            ENIGMA_DIR.mkdirs();
        }
        File configFile = new File(ENIGMA_DIR, "config.json");
        boolean loaded = false;
        if (configFile.exists()) {
            try {
                this.gson.fromJson(Files.asCharSource((File)configFile, (Charset)Charset.defaultCharset()).read(), Config.class);
                loaded = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!loaded) {
            this.reset();
            Files.touch((File)configFile);
        }
        this.saveConfig();
    }

    public void saveConfig() throws IOException {
        Files.asCharSink((File)CONFIG_FILE, (Charset)Charset.defaultCharset(), (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)this.gson.toJson((Object)this));
    }

    public void reset() throws IOException {
        this.lookAndFeel = LookAndFeel.DEFAULT;
        this.lookAndFeel.apply(this);
        this.decompiler = Decompiler.PROCYON;
        this.language = "en_us";
        this.saveConfig();
    }

    public static Config getInstance() {
        return INSTANCE;
    }

    private static class IntDeserializer
    implements JsonDeserializer<Integer> {
        private IntDeserializer() {
        }

        public Integer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            return (int)Long.parseLong(json.getAsString().replace("#", ""), 16);
        }
    }

    private static class IntSerializer
    implements JsonSerializer<Integer> {
        private IntSerializer() {
        }

        public JsonElement serialize(Integer src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive("#" + Integer.toHexString(src).toUpperCase());
        }
    }

    public static enum Decompiler {
        PROCYON("Procyon", Decompilers.PROCYON),
        CFR("CFR", Decompilers.CFR);

        public final DecompilerService service;
        public final String name;

        private Decompiler(String name, DecompilerService service) {
            this.name = name;
            this.service = service;
        }
    }

    public static enum LookAndFeel {
        DEFAULT("Default"),
        DARCULA("Darcula"),
        SYSTEM("System"),
        NONE("None (JVM default)");

        private static javax.swing.LookAndFeel NONE_LAF;
        private final String name;

        private LookAndFeel(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setGlobalLAF() {
            try {
                switch (this) {
                    case NONE: {
                        UIManager.setLookAndFeel(NONE_LAF);
                        break;
                    }
                    case DEFAULT: {
                        UIManager.setLookAndFeel(new MetalLookAndFeel());
                        break;
                    }
                    case DARCULA: {
                        UIManager.setLookAndFeel((javax.swing.LookAndFeel)new DarculaLaf());
                        break;
                    }
                    case SYSTEM: {
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    }
                }
            }
            catch (Exception e) {
                throw new Error("Failed to set global look and feel", e);
            }
        }

        public static boolean isDarkLaf() {
            JPanel panel = new JPanel();
            panel.setSize(new Dimension(10, 10));
            panel.doLayout();
            BufferedImage image = new BufferedImage(panel.getSize().width, panel.getSize().height, 1);
            panel.printAll(image.getGraphics());
            Color c = new Color(image.getRGB(0, 0));
            int b = (int)(0.3 * (double)c.getRed() + 0.59 * (double)c.getGreen() + 0.11 * (double)c.getBlue());
            return b < 85;
        }

        public void apply(Config config) {
            boolean isDark;
            boolean bl = isDark = this == DARCULA || LookAndFeel.isDarkLaf();
            if (!isDark) {
                config.lineNumbersForeground = 0x333300;
                config.lineNumbersBackground = 0xEEEEFF;
                config.lineNumbersSelected = 0xCCCCEE;
                config.obfuscatedColor = new AlphaColorEntry(0xFFDCDC, 1.0f);
                config.obfuscatedColorOutline = new AlphaColorEntry(0xA05050, 1.0f);
                config.proposedColor = new AlphaColorEntry(0, 0.075f);
                config.proposedColorOutline = new AlphaColorEntry(0, 0.15f);
                config.deobfuscatedColor = new AlphaColorEntry(0xDCFFDC, 1.0f);
                config.deobfuscatedColorOutline = new AlphaColorEntry(0x50A050, 1.0f);
                config.editorBackground = 0xFFFFFF;
                config.highlightColor = 0x3333EE;
                config.caretColor = 0;
                config.selectionHighlightColor = 0;
                config.stringColor = 0xCC6600;
                config.numberColor = 0x999933;
                config.operatorColor = 0;
                config.delimiterColor = 0;
                config.typeColor = 0;
                config.identifierColor = 0;
                config.defaultTextColor = 0;
            } else {
                config.lineNumbersForeground = 0xA4A4A3;
                config.lineNumbersBackground = 0x313335;
                config.lineNumbersSelected = 0x606366;
                config.obfuscatedColor = new AlphaColorEntry(0xFF5555, 0.3f);
                config.obfuscatedColorOutline = new AlphaColorEntry(0xFF5555, 0.5f);
                config.deobfuscatedColor = new AlphaColorEntry(5307003, 0.3f);
                config.deobfuscatedColorOutline = new AlphaColorEntry(5307003, 0.5f);
                config.proposedColor = new AlphaColorEntry(0x606366, 0.3f);
                config.proposedColorOutline = new AlphaColorEntry(0x606366, 0.5f);
                config.editorBackground = 2632246;
                config.highlightColor = 16742854;
                config.caretColor = 0xF8F8F2;
                config.selectionHighlightColor = 0xF8F8F2;
                config.stringColor = 15858316;
                config.numberColor = 12424185;
                config.operatorColor = 0xF8F8F2;
                config.delimiterColor = 0xF8F8F2;
                config.typeColor = 0xF8F8F2;
                config.identifierColor = 0xF8F8F2;
                config.defaultTextColor = 0xF8F8F2;
            }
        }

        static {
            NONE_LAF = UIManager.getLookAndFeel();
        }
    }

    public static class AlphaColorEntry {
        public Integer rgb;
        public float alpha = 1.0f;

        public AlphaColorEntry(Integer rgb, float alpha) {
            this.rgb = rgb;
            this.alpha = alpha;
        }

        public Color get() {
            if (this.rgb == null) {
                return new Color(0, 0, 0, 0);
            }
            Color baseColor = new Color(this.rgb);
            return new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), (int)(255.0f * this.alpha));
        }
    }
}

