/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.dialog;

import cuchaz.enigma.utils.I18n;
import java.awt.Frame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class CreateServerDialog {
    public static Result show(Frame parentComponent) {
        int port;
        JTextField portField = new JTextField(String.valueOf(34712), 10);
        JPanel portRow = new JPanel();
        portRow.add(new JLabel(I18n.translate((String)"prompt.port")));
        portRow.add(portField);
        JPasswordField passwordField = new JPasswordField(20);
        JPanel passwordRow = new JPanel();
        passwordRow.add(new JLabel(I18n.translate((String)"prompt.password")));
        passwordRow.add(passwordField);
        int response = JOptionPane.showConfirmDialog(parentComponent, new Object[]{portRow, passwordRow}, I18n.translate((String)"prompt.create_server.title"), 2);
        if (response != 0) {
            return null;
        }
        try {
            port = Integer.parseInt(portField.getText());
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(parentComponent, I18n.translate((String)"prompt.port.nan"), I18n.translate((String)"prompt.create_server.title"), 0);
            return null;
        }
        if (port < 0 || port >= 65536) {
            JOptionPane.showMessageDialog(parentComponent, I18n.translate((String)"prompt.port.invalid"), I18n.translate((String)"prompt.create_server.title"), 0);
            return null;
        }
        char[] password = passwordField.getPassword();
        if (password.length > 255) {
            JOptionPane.showMessageDialog(parentComponent, I18n.translate((String)"prompt.password.too_long"), I18n.translate((String)"prompt.create_server.title"), 0);
            return null;
        }
        return new Result(port, password);
    }

    public static class Result {
        private final int port;
        private final char[] password;

        public Result(int port, char[] password) {
            this.port = port;
            this.password = password;
        }

        public int getPort() {
            return this.port;
        }

        public char[] getPassword() {
            return this.password;
        }
    }
}

