/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.annotation.Nullable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;

public class ClosableTabTitlePane {
    private final JPanel ui = new JPanel(new FlowLayout(1, 2, 2));
    private final JButton closeButton;
    private final JLabel label;
    private ChangeListener cachedChangeListener;
    private JTabbedPane parent;

    public ClosableTabTitlePane(String text, final Runnable onClose) {
        this.ui.setOpaque(false);
        this.label = new JLabel(text);
        this.ui.add(this.label);
        this.closeButton = new JButton();
        this.closeButton.setFocusPainted(false);
        this.closeButton.setFocusable(false);
        this.closeButton.setOpaque(true);
        this.closeButton.setIcon(UIManager.getIcon("InternalFrame.closeIcon"));
        this.closeButton.putClientProperty("paintActive", Boolean.TRUE);
        this.closeButton.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.closeButton.putClientProperty("AccessibleName", "Close");
        this.closeButton.setMaximumSize(new Dimension(this.closeButton.getIcon().getIconWidth(), this.closeButton.getIcon().getIconHeight()));
        this.ui.add(this.closeButton);
        this.closeButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) || SwingUtilities.isMiddleMouseButton(e)) {
                    onClose.run();
                }
            }
        });
        this.ui.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isMiddleMouseButton(e)) {
                    onClose.run();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (ClosableTabTitlePane.this.parent != null) {
                    Point pt = new Point(e.getXOnScreen(), e.getYOnScreen());
                    SwingUtilities.convertPointFromScreen(pt, ClosableTabTitlePane.this.parent);
                    MouseEvent e1 = new MouseEvent(ClosableTabTitlePane.this.parent, e.getID(), e.getWhen(), e.getModifiersEx(), (int)pt.getX(), (int)pt.getY(), e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
                    ClosableTabTitlePane.this.parent.dispatchEvent(e1);
                }
            }
        });
        this.ui.putClientProperty(ClosableTabTitlePane.class, this);
    }

    public void setTabbedPane(JTabbedPane pane) {
        if (this.parent != null) {
            pane.removeChangeListener(this.cachedChangeListener);
        }
        if (pane != null) {
            this.updateState(pane);
            this.cachedChangeListener = e -> this.updateState(pane);
            pane.addChangeListener(this.cachedChangeListener);
        }
        this.parent = pane;
    }

    public void setText(String text) {
        this.label.setText(text);
    }

    public String getText() {
        return this.label.getText();
    }

    private void updateState(JTabbedPane pane) {
        int selectedIndex = pane.getSelectedIndex();
        boolean isActive = selectedIndex != -1 && pane.getTabComponentAt(selectedIndex) == this.ui;
        this.closeButton.setEnabled(isActive);
        this.closeButton.putClientProperty("paintActive", isActive);
        this.ui.repaint();
    }

    public JPanel getUi() {
        return this.ui;
    }

    @Nullable
    public static ClosableTabTitlePane byUi(Component c) {
        Object prop;
        if (c instanceof JComponent && (prop = ((JComponent)c).getClientProperty(ClosableTabTitlePane.class)) instanceof ClosableTabTitlePane) {
            return (ClosableTabTitlePane)prop;
        }
        return null;
    }
}

