/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;
import sun.swing.SwingUtilities2;

public class DarculaMenuUI
extends BasicMenuUI {
    private Window parentWindow;
    private Listener listener;
    private RolloverListener rolloverListener = new RolloverListener();
    private boolean rollover;
    private Color selectionInactiveBackground;

    public static ComponentUI createUI(JComponent c) {
        return new DarculaMenuUI();
    }

    public DarculaMenuUI() {
        this.listener = new Listener();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        c.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                Window parentWindow;
                if (DarculaMenuUI.this.parentWindow != null) {
                    DarculaMenuUI.this.parentWindow.removeWindowFocusListener(DarculaMenuUI.this.listener);
                }
                if (DarculaMenuUI.this.menuItem != null && (parentWindow = SwingUtilities.getWindowAncestor(DarculaMenuUI.this.menuItem)) != null) {
                    DarculaMenuUI.this.parentWindow = parentWindow;
                    parentWindow.addWindowFocusListener(DarculaMenuUI.this.listener);
                }
            }
        });
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.selectionInactiveBackground = UIManager.getColor("MenuItem.selectionInactiveBackground");
        this.menuItem.setRolloverEnabled(true);
        this.menuItem.addMouseListener(this.rolloverListener);
    }

    @Override
    protected void uninstallDefaults() {
        this.menuItem.removeMouseListener(this.rolloverListener);
        super.uninstallDefaults();
    }

    @Override
    protected void paintText(Graphics g2, JMenuItem menuItem, Rectangle textRect, String text) {
        Window parentWindow;
        if (((JMenu)menuItem).isTopLevelMenu() && (parentWindow = SwingUtilities.getWindowAncestor(menuItem)) != null && !parentWindow.isActive()) {
            FontMetrics fm = SwingUtilities2.getFontMetrics((JComponent)menuItem, g2);
            int mnemIndex = menuItem.getDisplayedMnemonicIndex();
            g2.setColor(this.disabledForeground);
            SwingUtilities2.drawStringUnderlineCharAt(menuItem, g2, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
            return;
        }
        super.paintText(g2, menuItem, textRect, text);
    }

    @Override
    public void uninstallUI(JComponent c) {
        if (this.parentWindow != null) {
            this.parentWindow.removeWindowFocusListener(this.listener);
            this.parentWindow = null;
        }
        super.uninstallUI(c);
    }

    @Override
    protected void paintBackground(Graphics g2, JMenuItem menuItem, Color bgColor) {
        ButtonModel model = menuItem.getModel();
        Color oldColor = g2.getColor();
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        if (menuItem.isOpaque()) {
            if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                g2.setColor(bgColor);
            } else if (this.rollover) {
                g2.setColor(model.isEnabled() ? bgColor : this.selectionInactiveBackground);
            } else {
                g2.setColor(menuItem.getBackground());
            }
            g2.fillRect(0, 0, menuWidth, menuHeight);
            g2.setColor(oldColor);
        } else if (this.rollover) {
            g2.setColor(model.isEnabled() ? bgColor : this.selectionInactiveBackground);
            g2.fillRect(0, 0, menuWidth, menuHeight);
            g2.setColor(oldColor);
        } else if (model.isArmed()) {
            g2.setColor(bgColor);
            g2.fillRect(0, 0, menuWidth, menuHeight);
            g2.setColor(oldColor);
        }
    }

    private class RolloverListener
    extends MouseAdapter {
        private RolloverListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            AbstractButton b = (AbstractButton)e.getSource();
            if (b.isRolloverEnabled() && !SwingUtilities.isLeftMouseButton(e)) {
                DarculaMenuUI.this.rollover = true;
                DarculaMenuUI.this.menuItem.repaint();
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            AbstractButton b = (AbstractButton)e.getSource();
            if (b.isRolloverEnabled()) {
                DarculaMenuUI.this.rollover = false;
                DarculaMenuUI.this.menuItem.repaint();
            }
        }
    }

    private class Listener
    implements WindowFocusListener {
        private Listener() {
        }

        @Override
        public void windowGainedFocus(WindowEvent e) {
            DarculaMenuUI.this.menuItem.repaint();
        }

        @Override
        public void windowLostFocus(WindowEvent e) {
            DarculaMenuUI.this.menuItem.repaint();
        }
    }
}

