/*
 * Decompiled with CFR 0.152.
 */
package com.github.swingdpi;

import com.github.swingdpi.UiScaling;
import com.github.swingdpi.plaf.BasicTweaker;
import com.github.swingdpi.plaf.MetalTweaker;
import com.github.swingdpi.plaf.NimbusTweaker;
import com.github.swingdpi.plaf.Tweaker;
import com.github.swingdpi.plaf.WindowsTweaker;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.util.Collections;
import java.util.IdentityHashMap;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class UiDefaultsScaler {
    private final Tweaker delegate;

    private UiDefaultsScaler(Tweaker delegate) {
        this.delegate = delegate;
    }

    public static void updateAndApplyGlobalScaling(int scalingInPercent, boolean alsoTweak) {
        float scaleFactor = (float)scalingInPercent / 100.0f;
        BasicTweaker tweaker = UiDefaultsScaler.createTweakerForCurrentLook(scaleFactor);
        tweaker.setDoExtraTweaks(alsoTweak);
        UiDefaultsScaler scaler = new UiDefaultsScaler(tweaker);
        scaler.applyScalingAndTweaks();
        UiScaling.setScaling(scalingInPercent);
    }

    private void applyScalingAndTweaks() {
        this.delegate.initialTweaks();
        this.modifyDefaults(this.delegate);
        this.delegate.finalTweaks();
    }

    private static BasicTweaker createTweakerForCurrentLook(float dpiScaling) {
        String testString = UIManager.getLookAndFeel().getName().toLowerCase();
        if (testString.contains("windows")) {
            return new WindowsTweaker(dpiScaling, testString.contains("classic"));
        }
        if (testString.contains("metal")) {
            return new MetalTweaker(dpiScaling);
        }
        if (testString.contains("nimbus")) {
            return new NimbusTweaker(dpiScaling);
        }
        return new BasicTweaker(dpiScaling);
    }

    private void modifyDefaults(Tweaker tweaker) {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        IdentityHashMap identityMap = new IdentityHashMap();
        for (Object key : Collections.list(defaults.keys())) {
            Object newValue;
            Object original = defaults.get(key);
            if (identityMap.keySet().contains(original) || (newValue = this.modifyValueUsingDelegate(tweaker, key, original)) == null || newValue == original) continue;
            defaults.put(key, newValue);
        }
    }

    private Object modifyValueUsingDelegate(Tweaker tweaker, Object key, Object original) {
        if (original instanceof Font) {
            return tweaker.modifyFont(key, (Font)original);
        }
        if (original instanceof Icon) {
            return tweaker.modifyIcon(key, (Icon)original);
        }
        if (original instanceof Dimension) {
            return tweaker.modifyDimension(key, (Dimension)original);
        }
        if (original instanceof Integer) {
            return tweaker.modifyInteger(key, (Integer)original);
        }
        if (original instanceof Insets) {
            return tweaker.modifyInsets(key, (Insets)original);
        }
        return null;
    }
}

