/*
 * Decompiled with CFR 0.152.
 */
package com.github.swingdpi.util;

import com.github.swingdpi.UiScaling;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ScaledTable
extends JTable {
    private Integer uiScaleWhenRowHeightSet = null;

    public ScaledTable() {
    }

    public ScaledTable(TableModel dm) {
        super(dm);
    }

    public ScaledTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
    }

    public ScaledTable(int numRows, int numColumns) {
        super(numRows, numColumns);
    }

    public ScaledTable(Vector<?> rowData, Vector<?> columnNames) {
        super(rowData, columnNames);
    }

    public ScaledTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
    }

    public ScaledTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.resetDefaultRowHeight();
        this.rescaleRowHeightIfExplicitlySet();
    }

    private void resetDefaultRowHeight() {
        int height = UiScaling.scale(19);
        LookAndFeel.installProperty(this, "rowHeight", height);
    }

    private void rescaleRowHeightIfExplicitlySet() {
        if (this.uiScaleWhenRowHeightSet != null && this.uiScaleWhenRowHeightSet != UiScaling.getScaling()) {
            this.setRowHeight(this.getRowHeight() * UiScaling.getScaling() / this.uiScaleWhenRowHeightSet);
        }
    }

    @Override
    public void setRowHeight(int scaledRowHeight) {
        super.setRowHeight(scaledRowHeight);
        this.uiScaleWhenRowHeightSet = UiScaling.getScaling();
    }
}

