/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.languages.TextLocation;
import com.strobel.decompiler.languages.java.JavaFormattingOptions;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.JavaModifierToken;
import com.strobel.decompiler.languages.java.ast.NodeType;
import com.strobel.decompiler.languages.java.ast.TokenRole;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Role;

public class JavaTokenNode
extends AstNode {
    private TextLocation _startLocation;
    public static final JavaTokenNode NULL = new NullJavaTokenNode();

    public JavaTokenNode(TextLocation startLocation) {
        this._startLocation = VerifyArgument.notNull(startLocation, "startLocation");
    }

    @Override
    public TextLocation getStartLocation() {
        return this._startLocation;
    }

    public void setStartLocation(TextLocation startLocation) {
        this._startLocation = startLocation;
    }

    @Override
    public TextLocation getEndLocation() {
        return new TextLocation(this._startLocation.line(), this._startLocation.column() + this.getTokenLength());
    }

    @Override
    public String getText(JavaFormattingOptions options) {
        Role<? extends JavaTokenNode> role = this.getRole();
        if (role instanceof TokenRole) {
            return ((TokenRole)role).getToken();
        }
        return null;
    }

    protected int getTokenLength() {
        Role<? extends JavaTokenNode> role = this.getRole();
        if (role instanceof TokenRole) {
            return ((TokenRole)role).getLength();
        }
        return 0;
    }

    public Role<? extends JavaTokenNode> getRole() {
        return super.getRole();
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitJavaTokenNode(this, data);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.TOKEN;
    }

    @Override
    public boolean matches(INode other, Match match) {
        return other instanceof JavaTokenNode && !other.isNull() && !(other instanceof JavaModifierToken);
    }

    @Override
    public String toString() {
        return String.format("[JavaTokenNode: StartLocation=%s, EndLocation=%s, Role=%s]", this.getStartLocation(), this.getEndLocation(), this.getRole());
    }

    private static final class NullJavaTokenNode
    extends JavaTokenNode {
        public NullJavaTokenNode() {
            super(TextLocation.EMPTY);
        }

        @Override
        public final boolean isNull() {
            return true;
        }

        @Override
        public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
            return null;
        }

        @Override
        public boolean matches(INode other, Match match) {
            return other == null || other.isNull();
        }
    }
}

