/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import cuchaz.enigma.EnigmaProfile;
import cuchaz.enigma.analysis.ClassImplementationsTreeNode;
import cuchaz.enigma.analysis.ClassInheritanceTreeNode;
import cuchaz.enigma.analysis.ClassReferenceTreeNode;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.FieldReferenceTreeNode;
import cuchaz.enigma.analysis.MethodImplementationsTreeNode;
import cuchaz.enigma.analysis.MethodInheritanceTreeNode;
import cuchaz.enigma.analysis.MethodReferenceTreeNode;
import cuchaz.enigma.analysis.ReferenceTreeNode;
import cuchaz.enigma.classhandle.ClassHandle;
import cuchaz.enigma.gui.ClassSelector;
import cuchaz.enigma.gui.ConnectionState;
import cuchaz.enigma.gui.ExceptionIgnorer;
import cuchaz.enigma.gui.GuiController;
import cuchaz.enigma.gui.MessageListCellRenderer;
import cuchaz.enigma.gui.MethodTreeCellRenderer;
import cuchaz.enigma.gui.TokenListCellRenderer;
import cuchaz.enigma.gui.config.Config;
import cuchaz.enigma.gui.config.Themes;
import cuchaz.enigma.gui.dialog.CrashDialog;
import cuchaz.enigma.gui.dialog.JavadocDialog;
import cuchaz.enigma.gui.dialog.SearchDialog;
import cuchaz.enigma.gui.elements.CollapsibleTabbedPane;
import cuchaz.enigma.gui.elements.EditorTabPopupMenu;
import cuchaz.enigma.gui.elements.MenuBar;
import cuchaz.enigma.gui.elements.ValidatableUi;
import cuchaz.enigma.gui.events.EditorActionListener;
import cuchaz.enigma.gui.panels.ClosableTabTitlePane;
import cuchaz.enigma.gui.panels.DeobfPanel;
import cuchaz.enigma.gui.panels.EditorPanel;
import cuchaz.enigma.gui.panels.IdentifierPanel;
import cuchaz.enigma.gui.panels.ObfPanel;
import cuchaz.enigma.gui.util.History;
import cuchaz.enigma.gui.util.ScaleUtil;
import cuchaz.enigma.network.Message;
import cuchaz.enigma.network.packet.MarkDeobfuscatedC2SPacket;
import cuchaz.enigma.network.packet.MessageC2SPacket;
import cuchaz.enigma.network.packet.RemoveMappingC2SPacket;
import cuchaz.enigma.network.packet.RenameC2SPacket;
import cuchaz.enigma.source.Token;
import cuchaz.enigma.translation.mapping.EntryRemapper;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import cuchaz.enigma.utils.I18n;
import cuchaz.enigma.utils.validation.ParameterizedMessage;
import cuchaz.enigma.utils.validation.ValidationContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class Gui {
    private final ObfPanel obfPanel;
    private final DeobfPanel deobfPanel;
    private final MenuBar menuBar;
    public History<EntryReference<Entry<?>, Entry<?>>> referenceHistory;
    private ConnectionState connectionState;
    private boolean isJarOpen;
    public FileDialog jarFileChooser;
    public FileDialog tinyMappingsFileChooser;
    public SearchDialog searchDialog;
    public JFileChooser enigmaMappingsFileChooser;
    public JFileChooser exportSourceFileChooser;
    public FileDialog exportJarFileChooser;
    private GuiController controller;
    private JFrame frame;
    private JPanel classesPanel;
    private JSplitPane splitClasses;
    private IdentifierPanel infoPanel;
    private JTree inheritanceTree;
    private JTree implementationsTree;
    private JTree callsTree;
    private JList<Token> tokens;
    private JTabbedPane tabs;
    private JSplitPane splitRight;
    private JSplitPane logSplit;
    private CollapsibleTabbedPane logTabs;
    private JList<String> users;
    private DefaultListModel<String> userModel;
    private JScrollPane messageScrollPane;
    private JList<Message> messages;
    private DefaultListModel<Message> messageModel;
    private JTextField chatBox;
    private JPanel statusBar;
    private JLabel connectionStatusLabel;
    private JLabel statusLabel;
    private final EditorTabPopupMenu editorTabPopupMenu;
    private final JTabbedPane openFiles;
    private final HashBiMap<ClassEntry, EditorPanel> editors = HashBiMap.create();

    public Gui(EnigmaProfile profile) {
        Config.getInstance().lookAndFeel.setGlobalLAF();
        this.frame = new JFrame("Enigma");
        Container pane = this.frame.getContentPane();
        pane.setLayout(new BorderLayout());
        if (Boolean.parseBoolean(System.getProperty("enigma.catchExceptions", "true"))) {
            CrashDialog.init(this.frame);
            Thread.setDefaultUncaughtExceptionHandler((thread, t) -> {
                t.printStackTrace(System.err);
                if (!ExceptionIgnorer.shouldIgnore(t)) {
                    CrashDialog.show(t);
                }
            });
        }
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        this.controller = new GuiController(this, profile);
        Themes.addListener((lookAndFeel, boxHighlightPainters) -> SwingUtilities.updateComponentTreeUI(this.getFrame()));
        Themes.updateTheme();
        this.jarFileChooser = new FileDialog((Frame)this.getFrame(), I18n.translate("menu.file.jar.open"), 0);
        this.tinyMappingsFileChooser = new FileDialog((Frame)this.getFrame(), "Open tiny Mappings", 0);
        this.enigmaMappingsFileChooser = new JFileChooser();
        this.enigmaMappingsFileChooser.setFileSelectionMode(2);
        this.enigmaMappingsFileChooser.setAcceptAllFileFilterUsed(false);
        this.exportSourceFileChooser = new JFileChooser();
        this.exportSourceFileChooser.setFileSelectionMode(1);
        this.exportSourceFileChooser.setAcceptAllFileFilterUsed(false);
        this.exportJarFileChooser = new FileDialog((Frame)this.getFrame(), I18n.translate("menu.file.export.jar"), 1);
        this.obfPanel = new ObfPanel(this);
        this.deobfPanel = new DeobfPanel(this);
        this.splitClasses = new JSplitPane(0, true, this.obfPanel, this.deobfPanel);
        this.splitClasses.setResizeWeight(0.3);
        this.classesPanel = new JPanel();
        this.classesPanel.setLayout(new BorderLayout());
        this.classesPanel.setPreferredSize(ScaleUtil.getDimension(250, 0));
        this.infoPanel = new IdentifierPanel(this);
        this.inheritanceTree = new JTree();
        this.inheritanceTree.setModel(null);
        this.inheritanceTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() >= 2) {
                    MethodInheritanceTreeNode methodNode;
                    TreePath path = Gui.this.inheritanceTree.getSelectionPath();
                    if (path == null) {
                        return;
                    }
                    Object node = path.getLastPathComponent();
                    if (node instanceof ClassInheritanceTreeNode) {
                        ClassInheritanceTreeNode classNode = (ClassInheritanceTreeNode)node;
                        Gui.this.controller.navigateTo(new ClassEntry(classNode.getObfClassName()));
                    } else if (node instanceof MethodInheritanceTreeNode && (methodNode = (MethodInheritanceTreeNode)node).isImplemented()) {
                        Gui.this.controller.navigateTo(methodNode.getMethodEntry());
                    }
                }
            }
        });
        TreeCellRenderer cellRenderer = this.inheritanceTree.getCellRenderer();
        this.inheritanceTree.setCellRenderer(new MethodTreeCellRenderer(cellRenderer));
        JPanel inheritancePanel = new JPanel();
        inheritancePanel.setLayout(new BorderLayout());
        inheritancePanel.add(new JScrollPane(this.inheritanceTree));
        this.implementationsTree = new JTree();
        this.implementationsTree.setModel(null);
        this.implementationsTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() >= 2) {
                    TreePath path = Gui.this.implementationsTree.getSelectionPath();
                    if (path == null) {
                        return;
                    }
                    Object node = path.getLastPathComponent();
                    if (node instanceof ClassImplementationsTreeNode) {
                        ClassImplementationsTreeNode classNode = (ClassImplementationsTreeNode)node;
                        Gui.this.controller.navigateTo(classNode.getClassEntry());
                    } else if (node instanceof MethodImplementationsTreeNode) {
                        MethodImplementationsTreeNode methodNode = (MethodImplementationsTreeNode)node;
                        Gui.this.controller.navigateTo(methodNode.getMethodEntry());
                    }
                }
            }
        });
        JPanel implementationsPanel = new JPanel();
        implementationsPanel.setLayout(new BorderLayout());
        implementationsPanel.add(new JScrollPane(this.implementationsTree));
        this.callsTree = new JTree();
        this.callsTree.setModel(null);
        this.callsTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() >= 2) {
                    TreePath path = Gui.this.callsTree.getSelectionPath();
                    if (path == null) {
                        return;
                    }
                    Object node = path.getLastPathComponent();
                    if (node instanceof ReferenceTreeNode) {
                        ReferenceTreeNode referenceNode = (ReferenceTreeNode)node;
                        if (referenceNode.getReference() != null) {
                            Gui.this.controller.navigateTo(referenceNode.getReference());
                        } else {
                            Gui.this.controller.navigateTo((Entry<?>)referenceNode.getEntry());
                        }
                    }
                }
            }
        });
        this.tokens = new JList();
        this.tokens.setCellRenderer(new TokenListCellRenderer(this.controller));
        this.tokens.setSelectionMode(0);
        this.tokens.setLayoutOrientation(0);
        this.tokens.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                Token selected;
                if (event.getClickCount() == 2 && (selected = (Token)Gui.this.tokens.getSelectedValue()) != null) {
                    Gui.this.openClass(Gui.this.controller.getTokenHandle().getRef()).navigateToToken(selected);
                }
            }
        });
        this.tokens.setPreferredSize(ScaleUtil.getDimension(0, 200));
        this.tokens.setMinimumSize(ScaleUtil.getDimension(0, 200));
        JSplitPane callPanel = new JSplitPane(0, true, new JScrollPane(this.callsTree), new JScrollPane(this.tokens));
        callPanel.setResizeWeight(1.0);
        callPanel.resetToPreferredSizes();
        this.editorTabPopupMenu = new EditorTabPopupMenu(this);
        this.openFiles = new JTabbedPane(1, 1);
        this.openFiles.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int i;
                if (SwingUtilities.isRightMouseButton(e) && (i = Gui.this.openFiles.getUI().tabForCoordinate(Gui.this.openFiles, e.getX(), e.getY())) != -1) {
                    Gui.this.editorTabPopupMenu.show(Gui.this.openFiles, e.getX(), e.getY(), EditorPanel.byUi(Gui.this.openFiles.getComponentAt(i)));
                }
            }
        });
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BorderLayout());
        centerPanel.add((Component)this.infoPanel.getUi(), "North");
        centerPanel.add((Component)this.openFiles, "Center");
        this.tabs = new JTabbedPane();
        this.tabs.setPreferredSize(ScaleUtil.getDimension(250, 0));
        this.tabs.addTab(I18n.translate("info_panel.tree.inheritance"), inheritancePanel);
        this.tabs.addTab(I18n.translate("info_panel.tree.implementations"), implementationsPanel);
        this.tabs.addTab(I18n.translate("info_panel.tree.calls"), callPanel);
        this.logTabs = new CollapsibleTabbedPane(3);
        this.userModel = new DefaultListModel();
        this.users = new JList<String>(this.userModel);
        this.messageModel = new DefaultListModel();
        this.messages = new JList<Message>(this.messageModel);
        this.messages.setCellRenderer(new MessageListCellRenderer());
        JPanel messagePanel = new JPanel(new BorderLayout());
        this.messageScrollPane = new JScrollPane(this.messages);
        messagePanel.add((Component)this.messageScrollPane, "Center");
        JPanel chatPanel = new JPanel(new BorderLayout());
        this.chatBox = new JTextField();
        AbstractAction sendListener = new AbstractAction("Send"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.sendMessage();
            }
        };
        this.chatBox.addActionListener(sendListener);
        JButton chatSendButton = new JButton(sendListener);
        chatPanel.add((Component)this.chatBox, "Center");
        chatPanel.add((Component)chatSendButton, "East");
        messagePanel.add((Component)chatPanel, "South");
        this.logTabs.addTab(I18n.translate("log_panel.users"), new JScrollPane(this.users));
        this.logTabs.addTab(I18n.translate("log_panel.messages"), messagePanel);
        this.logSplit = new JSplitPane(0, true, this.tabs, this.logTabs);
        this.logSplit.setResizeWeight(0.5);
        this.logSplit.resetToPreferredSizes();
        this.splitRight = new JSplitPane(1, true, centerPanel, this.logSplit);
        this.splitRight.setResizeWeight(1.0);
        this.splitRight.resetToPreferredSizes();
        JSplitPane splitCenter = new JSplitPane(1, true, this.classesPanel, this.splitRight);
        splitCenter.setResizeWeight(0.0);
        pane.add((Component)splitCenter, "Center");
        this.menuBar = new MenuBar(this);
        this.frame.setJMenuBar(this.menuBar.getUi());
        this.statusBar = new JPanel(new BorderLayout());
        this.statusBar.setBorder(BorderFactory.createLoweredBevelBorder());
        this.connectionStatusLabel = new JLabel();
        this.statusLabel = new JLabel();
        this.statusBar.add((Component)this.statusLabel, "Center");
        this.statusBar.add((Component)this.connectionStatusLabel, "East");
        pane.add((Component)this.statusBar, "South");
        this.setConnectionState(ConnectionState.NOT_CONNECTED);
        this.onCloseJar();
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                Gui.this.close();
            }
        });
        pane.doLayout();
        this.frame.setSize(ScaleUtil.getDimension(1024, 576));
        this.frame.setMinimumSize(ScaleUtil.getDimension(640, 480));
        this.frame.setVisible(true);
        this.frame.setDefaultCloseOperation(0);
        this.frame.setLocationRelativeTo(null);
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public GuiController getController() {
        return this.controller;
    }

    public void onStartOpenJar() {
        this.classesPanel.removeAll();
        this.redraw();
    }

    public void onFinishOpenJar(String jarName) {
        this.frame.setTitle("Enigma - " + jarName);
        this.classesPanel.removeAll();
        this.classesPanel.add(this.splitClasses);
        this.closeAllEditorTabs();
        this.isJarOpen = true;
        this.updateUiState();
        this.redraw();
    }

    public void onCloseJar() {
        this.frame.setTitle("Enigma");
        this.setObfClasses(null);
        this.setDeobfClasses(null);
        this.closeAllEditorTabs();
        this.classesPanel.removeAll();
        this.isJarOpen = false;
        this.setMappingsFile(null);
        this.updateUiState();
        this.redraw();
    }

    public EditorPanel openClass(ClassEntry entry) {
        EditorPanel editorPanel = this.editors.computeIfAbsent(entry, e -> {
            ClassHandle ch = this.controller.getClassHandleProvider().openClass(entry);
            if (ch == null) {
                return null;
            }
            final EditorPanel ed = new EditorPanel(this);
            ed.setup();
            ed.setClassHandle(ch);
            this.openFiles.addTab(ed.getFileName(), ed.getUi());
            final ClosableTabTitlePane titlePane = new ClosableTabTitlePane(ed.getFileName(), () -> this.closeEditor(ed));
            this.openFiles.setTabComponentAt(this.openFiles.indexOfComponent(ed.getUi()), titlePane.getUi());
            titlePane.setTabbedPane(this.openFiles);
            ed.addListener(new EditorActionListener(){

                @Override
                public void onCursorReferenceChanged(EditorPanel editor, EntryReference<Entry<?>, Entry<?>> ref) {
                    Gui.this.updateSelectedReference(editor, ref);
                }

                @Override
                public void onClassHandleChanged(EditorPanel editor, ClassEntry old, ClassHandle ch) {
                    Gui.this.editors.remove(old);
                    Gui.this.editors.put(ch.getRef(), editor);
                }

                @Override
                public void onTitleChanged(EditorPanel editor, String title) {
                    titlePane.setText(editor.getFileName());
                }
            });
            ed.getEditor().addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 52 && (e.getModifiersEx() & 0x80) != 0) {
                        Gui.this.closeEditor(ed);
                    }
                }
            });
            return ed;
        });
        if (editorPanel != null) {
            this.openFiles.setSelectedComponent(this.editors.get(entry).getUi());
        }
        return editorPanel;
    }

    public void setObfClasses(Collection<ClassEntry> obfClasses) {
        this.obfPanel.obfClasses.setClasses(obfClasses);
    }

    public void setDeobfClasses(Collection<ClassEntry> deobfClasses) {
        this.deobfPanel.deobfClasses.setClasses(deobfClasses);
    }

    public void setMappingsFile(Path path) {
        this.enigmaMappingsFileChooser.setSelectedFile(path != null ? path.toFile() : null);
        this.updateUiState();
    }

    public void closeEditor(EditorPanel ed) {
        this.openFiles.remove(ed.getUi());
        this.editors.inverse().remove(ed);
        ed.destroy();
    }

    public void closeAllEditorTabs() {
        Iterator iter = this.editors.values().iterator();
        while (iter.hasNext()) {
            EditorPanel e = (EditorPanel)iter.next();
            this.openFiles.remove(e.getUi());
            e.destroy();
            iter.remove();
        }
    }

    public void closeTabsLeftOf(EditorPanel ed) {
        int index = this.openFiles.indexOfComponent(ed.getUi());
        for (int i = index - 1; i >= 0; --i) {
            this.closeEditor(EditorPanel.byUi(this.openFiles.getComponentAt(i)));
        }
    }

    public void closeTabsRightOf(EditorPanel ed) {
        int index = this.openFiles.indexOfComponent(ed.getUi());
        for (int i = this.openFiles.getTabCount() - 1; i > index; --i) {
            this.closeEditor(EditorPanel.byUi(this.openFiles.getComponentAt(i)));
        }
    }

    public void closeTabsExcept(EditorPanel ed) {
        int index = this.openFiles.indexOfComponent(ed.getUi());
        for (int i = this.openFiles.getTabCount() - 1; i >= 0; --i) {
            if (i == index) continue;
            this.closeEditor(EditorPanel.byUi(this.openFiles.getComponentAt(i)));
        }
    }

    public void showTokens(EditorPanel editor, Collection<Token> tokens) {
        Vector<Token> sortedTokens = new Vector<Token>(tokens);
        Collections.sort(sortedTokens);
        if (sortedTokens.size() > 1) {
            this.controller.setTokenHandle(editor.getClassHandle().copy());
            this.tokens.setListData(sortedTokens);
            this.tokens.setSelectedIndex(0);
        } else {
            this.tokens.setListData(new Vector());
        }
        editor.navigateToToken(sortedTokens.get(0));
    }

    private void updateSelectedReference(EditorPanel editor, EntryReference<Entry<?>, Entry<?>> ref) {
        if (editor != this.getActiveEditor()) {
            return;
        }
        this.showCursorReference(ref);
    }

    private void showCursorReference(EntryReference<Entry<?>, Entry<?>> reference) {
        this.infoPanel.setReference(reference == null ? null : (Entry<?>)reference.entry);
    }

    @Nullable
    public EditorPanel getActiveEditor() {
        return EditorPanel.byUi(this.openFiles.getSelectedComponent());
    }

    @Nullable
    public EntryReference<Entry<?>, Entry<?>> getCursorReference() {
        EditorPanel activeEditor = this.getActiveEditor();
        return activeEditor == null ? null : activeEditor.getCursorReference();
    }

    public void startDocChange(EditorPanel editor) {
        EntryReference<Entry<?>, Entry<?>> cursorReference = editor.getCursorReference();
        if (cursorReference == null) {
            return;
        }
        JavadocDialog.show(this.frame, this.getController(), cursorReference);
    }

    public void startRename(EditorPanel editor, String text) {
        if (editor != this.getActiveEditor()) {
            return;
        }
        this.infoPanel.startRenaming(text);
    }

    public void startRename(EditorPanel editor) {
        if (editor != this.getActiveEditor()) {
            return;
        }
        this.infoPanel.startRenaming();
    }

    public void showInheritance(EditorPanel editor) {
        EntryReference<Entry<?>, Entry<?>> cursorReference = editor.getCursorReference();
        if (cursorReference == null) {
            return;
        }
        this.inheritanceTree.setModel(null);
        if (cursorReference.entry instanceof ClassEntry) {
            ClassInheritanceTreeNode classNode = this.controller.getClassInheritance((ClassEntry)cursorReference.entry);
            TreePath path = this.getPathToRoot(classNode);
            this.inheritanceTree.setModel(new DefaultTreeModel((TreeNode)path.getPathComponent(0)));
            this.inheritanceTree.expandPath(path);
            this.inheritanceTree.setSelectionRow(this.inheritanceTree.getRowForPath(path));
        } else if (cursorReference.entry instanceof MethodEntry) {
            MethodInheritanceTreeNode classNode = this.controller.getMethodInheritance((MethodEntry)cursorReference.entry);
            TreePath path = this.getPathToRoot(classNode);
            this.inheritanceTree.setModel(new DefaultTreeModel((TreeNode)path.getPathComponent(0)));
            this.inheritanceTree.expandPath(path);
            this.inheritanceTree.setSelectionRow(this.inheritanceTree.getRowForPath(path));
        }
        this.tabs.setSelectedIndex(0);
        this.redraw();
    }

    public void showImplementations(EditorPanel editor) {
        EntryReference<Entry<?>, Entry<?>> cursorReference = editor.getCursorReference();
        if (cursorReference == null) {
            return;
        }
        this.implementationsTree.setModel(null);
        DefaultMutableTreeNode node = null;
        if (cursorReference.entry instanceof ClassEntry) {
            node = this.controller.getClassImplementations((ClassEntry)cursorReference.entry);
        } else if (cursorReference.entry instanceof MethodEntry) {
            node = this.controller.getMethodImplementations((MethodEntry)cursorReference.entry);
        }
        if (node != null) {
            TreePath path = this.getPathToRoot(node);
            this.implementationsTree.setModel(new DefaultTreeModel((TreeNode)path.getPathComponent(0)));
            this.implementationsTree.expandPath(path);
            this.implementationsTree.setSelectionRow(this.implementationsTree.getRowForPath(path));
        }
        this.tabs.setSelectedIndex(1);
        this.redraw();
    }

    public void showCalls(EditorPanel editor, boolean recurse) {
        EntryReference<Entry<?>, Entry<?>> cursorReference = editor.getCursorReference();
        if (cursorReference == null) {
            return;
        }
        if (cursorReference.entry instanceof ClassEntry) {
            ClassReferenceTreeNode node = this.controller.getClassReferences((ClassEntry)cursorReference.entry);
            this.callsTree.setModel(new DefaultTreeModel(node));
        } else if (cursorReference.entry instanceof FieldEntry) {
            FieldReferenceTreeNode node = this.controller.getFieldReferences((FieldEntry)cursorReference.entry);
            this.callsTree.setModel(new DefaultTreeModel(node));
        } else if (cursorReference.entry instanceof MethodEntry) {
            MethodReferenceTreeNode node = this.controller.getMethodReferences((MethodEntry)cursorReference.entry, recurse);
            this.callsTree.setModel(new DefaultTreeModel(node));
        }
        this.tabs.setSelectedIndex(2);
        this.redraw();
    }

    public void toggleMapping(EditorPanel editor) {
        EntryReference<Entry<?>, Entry<?>> cursorReference = editor.getCursorReference();
        if (cursorReference == null) {
            return;
        }
        Object obfEntry = cursorReference.entry;
        Entry deobfEntry = (Entry)this.controller.project.getMapper().deobfuscate(obfEntry);
        if (!Objects.equals(obfEntry, deobfEntry)) {
            if (!this.validateImmediateAction(vc -> this.controller.removeMapping((ValidationContext)vc, cursorReference))) {
                return;
            }
            this.controller.sendPacket(new RemoveMappingC2SPacket(cursorReference.getNameableEntry()));
        } else {
            if (!this.validateImmediateAction(vc -> this.controller.markAsDeobfuscated((ValidationContext)vc, cursorReference))) {
                return;
            }
            this.controller.sendPacket(new MarkDeobfuscatedC2SPacket(cursorReference.getNameableEntry()));
        }
    }

    private TreePath getPathToRoot(TreeNode node) {
        ArrayList<TreeNode> nodes = Lists.newArrayList();
        TreeNode n = node;
        do {
            nodes.add(n);
        } while ((n = n.getParent()) != null);
        Collections.reverse(nodes);
        return new TreePath(nodes.toArray());
    }

    public void showDiscardDiag(Function<Integer, Void> callback, String ... options) {
        int response = JOptionPane.showOptionDialog(this.frame, I18n.translate("prompt.close.summary"), I18n.translate("prompt.close.title"), 1, 3, null, options, options[2]);
        callback.apply(response);
    }

    public void saveMapping() {
        if (this.enigmaMappingsFileChooser.getSelectedFile() != null || this.enigmaMappingsFileChooser.showSaveDialog(this.frame) == 0) {
            this.controller.saveMappings(this.enigmaMappingsFileChooser.getSelectedFile().toPath());
        }
    }

    public void close() {
        if (!this.controller.isDirty()) {
            this.exit();
        } else {
            this.showDiscardDiag(response -> {
                if (response == 0) {
                    this.saveMapping();
                    this.exit();
                } else if (response == 1) {
                    this.exit();
                }
                return null;
            }, I18n.translate("prompt.close.save"), I18n.translate("prompt.close.discard"), I18n.translate("prompt.close.cancel"));
        }
    }

    private void exit() {
        if (this.searchDialog != null) {
            this.searchDialog.dispose();
        }
        this.frame.dispose();
        System.exit(0);
    }

    public void redraw() {
        this.frame.validate();
        this.frame.repaint();
    }

    public void onPanelRename(ValidationContext vc, Object prevData, Object data, DefaultMutableTreeNode node) {
        if (data instanceof String) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
                ClassEntry prevDataChild = (ClassEntry)childNode.getUserObject();
                ClassEntry dataChild = new ClassEntry(data + "/" + prevDataChild.getSimpleName());
                this.controller.rename(vc, new EntryReference(prevDataChild, prevDataChild.getFullName()), dataChild.getFullName(), false);
                if (!vc.canProceed()) {
                    return;
                }
                this.controller.sendPacket(new RenameC2SPacket(prevDataChild, dataChild.getFullName(), false));
                childNode.setUserObject(dataChild);
            }
            node.setUserObject(data);
            this.deobfPanel.deobfClasses.reload();
        } else if (data instanceof ClassEntry) {
            EntryRemapper mapper = this.controller.project.getMapper();
            ClassEntry deobf = (ClassEntry)prevData;
            ClassEntry obf = mapper.getObfToDeobf().getAllEntries().filter(e -> e instanceof ClassEntry).map(e -> (ClassEntry)e).filter(e -> mapper.deobfuscate(e).equals(deobf)).findAny().get();
            this.controller.rename(vc, new EntryReference(obf, obf.getFullName()), ((ClassEntry)data).getFullName(), false);
            if (!vc.canProceed()) {
                return;
            }
            this.controller.sendPacket(new RenameC2SPacket(obf, ((ClassEntry)data).getFullName(), false));
        }
    }

    public void moveClassTree(Entry<?> obfEntry, String newName) {
        String oldEntry = obfEntry.getContainingClass().getPackageName();
        String newEntry = new ClassEntry(newName).getPackageName();
        this.moveClassTree(obfEntry, oldEntry == null, newEntry == null);
    }

    public void moveClassTree(Entry<?> obfEntry, boolean isOldOb, boolean isNewOb) {
        ClassEntry classEntry = obfEntry.getContainingClass();
        List<ClassSelector.StateEntry> stateDeobf = this.deobfPanel.deobfClasses.getExpansionState(this.deobfPanel.deobfClasses);
        List<ClassSelector.StateEntry> stateObf = this.obfPanel.obfClasses.getExpansionState(this.obfPanel.obfClasses);
        if (!isNewOb) {
            this.deobfPanel.deobfClasses.moveClassIn(classEntry);
            this.obfPanel.obfClasses.moveClassOut(classEntry);
            this.deobfPanel.deobfClasses.reload();
            this.obfPanel.obfClasses.reload();
        } else if (!isOldOb) {
            this.obfPanel.obfClasses.moveClassIn(classEntry);
            this.deobfPanel.deobfClasses.moveClassOut(classEntry);
            this.deobfPanel.deobfClasses.reload();
            this.obfPanel.obfClasses.reload();
        } else if (isOldOb) {
            this.obfPanel.obfClasses.moveClassIn(classEntry);
            this.obfPanel.obfClasses.reload();
        } else {
            this.deobfPanel.deobfClasses.moveClassIn(classEntry);
            this.deobfPanel.deobfClasses.reload();
        }
        this.deobfPanel.deobfClasses.restoreExpansionState(this.deobfPanel.deobfClasses, stateDeobf);
        this.obfPanel.obfClasses.restoreExpansionState(this.obfPanel.obfClasses, stateObf);
    }

    public ObfPanel getObfPanel() {
        return this.obfPanel;
    }

    public DeobfPanel getDeobfPanel() {
        return this.deobfPanel;
    }

    public SearchDialog getSearchDialog() {
        if (this.searchDialog == null) {
            this.searchDialog = new SearchDialog(this);
        }
        return this.searchDialog;
    }

    public MenuBar getMenuBar() {
        return this.menuBar;
    }

    public void addMessage(Message message) {
        JScrollBar verticalScrollBar = this.messageScrollPane.getVerticalScrollBar();
        boolean isAtBottom = verticalScrollBar.getValue() >= verticalScrollBar.getMaximum() - verticalScrollBar.getModel().getExtent();
        this.messageModel.addElement(message);
        if (isAtBottom) {
            SwingUtilities.invokeLater(() -> verticalScrollBar.setValue(verticalScrollBar.getMaximum() - verticalScrollBar.getModel().getExtent()));
        }
        this.statusLabel.setText(message.translate());
    }

    public void setUserList(List<String> users) {
        this.userModel.clear();
        users.forEach(this.userModel::addElement);
        this.connectionStatusLabel.setText(String.format(I18n.translate("status.connected_user_count"), users.size()));
    }

    private void sendMessage() {
        String text = this.chatBox.getText().trim();
        if (!text.isEmpty()) {
            this.getController().sendPacket(new MessageC2SPacket(text));
        }
        this.chatBox.setText("");
    }

    public void updateUiState() {
        this.menuBar.updateUiState();
        this.connectionStatusLabel.setText(I18n.translate(this.connectionState == ConnectionState.NOT_CONNECTED ? "status.disconnected" : "status.connected"));
        if (this.connectionState == ConnectionState.NOT_CONNECTED) {
            this.logSplit.setLeftComponent(null);
            this.splitRight.setRightComponent(this.tabs);
        } else {
            this.splitRight.setRightComponent(this.logSplit);
            this.logSplit.setLeftComponent(this.tabs);
        }
    }

    public void setConnectionState(ConnectionState state) {
        this.connectionState = state;
        this.statusLabel.setText(I18n.translate("status.ready"));
        this.updateUiState();
    }

    public boolean isJarOpen() {
        return this.isJarOpen;
    }

    public ConnectionState getConnectionState() {
        return this.connectionState;
    }

    public IdentifierPanel getInfoPanel() {
        return this.infoPanel;
    }

    public boolean validateImmediateAction(Consumer<ValidationContext> op) {
        ValidationContext vc = new ValidationContext();
        op.accept(vc);
        if (!vc.canProceed()) {
            List<ParameterizedMessage> messages = vc.getMessages();
            String text = ValidatableUi.formatMessages(messages);
            JOptionPane.showMessageDialog(this.getFrame(), text, String.format("%d message(s)", messages.size()), 0);
        }
        return vc.canProceed();
    }
}

