/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui;

import com.google.common.collect.Lists;
import cuchaz.enigma.Enigma;
import cuchaz.enigma.EnigmaProfile;
import cuchaz.enigma.EnigmaProject;
import cuchaz.enigma.analysis.ClassImplementationsTreeNode;
import cuchaz.enigma.analysis.ClassInheritanceTreeNode;
import cuchaz.enigma.analysis.ClassReferenceTreeNode;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.FieldReferenceTreeNode;
import cuchaz.enigma.analysis.IndexTreeBuilder;
import cuchaz.enigma.analysis.MethodImplementationsTreeNode;
import cuchaz.enigma.analysis.MethodInheritanceTreeNode;
import cuchaz.enigma.analysis.MethodReferenceTreeNode;
import cuchaz.enigma.api.service.ObfuscationTestService;
import cuchaz.enigma.classhandle.ClassHandle;
import cuchaz.enigma.classhandle.ClassHandleProvider;
import cuchaz.enigma.gui.ConnectionState;
import cuchaz.enigma.gui.Gui;
import cuchaz.enigma.gui.ReadableToken;
import cuchaz.enigma.gui.config.Config;
import cuchaz.enigma.gui.dialog.ProgressDialog;
import cuchaz.enigma.gui.stats.StatsGenerator;
import cuchaz.enigma.gui.stats.StatsMember;
import cuchaz.enigma.gui.util.History;
import cuchaz.enigma.network.ClientPacketHandler;
import cuchaz.enigma.network.EnigmaClient;
import cuchaz.enigma.network.EnigmaServer;
import cuchaz.enigma.network.IntegratedEnigmaServer;
import cuchaz.enigma.network.Message;
import cuchaz.enigma.network.ServerPacketHandler;
import cuchaz.enigma.network.packet.LoginC2SPacket;
import cuchaz.enigma.network.packet.Packet;
import cuchaz.enigma.source.DecompiledClassSource;
import cuchaz.enigma.source.DecompilerService;
import cuchaz.enigma.source.SourceIndex;
import cuchaz.enigma.source.Token;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.AccessModifier;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.EntryRemapper;
import cuchaz.enigma.translation.mapping.MappingDelta;
import cuchaz.enigma.translation.mapping.ResolutionStrategy;
import cuchaz.enigma.translation.mapping.serde.MappingFormat;
import cuchaz.enigma.translation.mapping.serde.MappingParseException;
import cuchaz.enigma.translation.mapping.serde.MappingSaveParameters;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.translation.mapping.tree.HashEntryTree;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import cuchaz.enigma.utils.I18n;
import cuchaz.enigma.utils.Utils;
import cuchaz.enigma.utils.validation.ValidationContext;
import java.awt.Desktop;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class GuiController
implements ClientPacketHandler {
    private final Gui gui;
    public final Enigma enigma;
    public EnigmaProject project;
    private IndexTreeBuilder indexTreeBuilder;
    private Path loadedMappingPath;
    private MappingFormat loadedMappingFormat;
    private ClassHandleProvider chp;
    private ClassHandle tokenHandle;
    private EnigmaClient client;
    private EnigmaServer server;

    public GuiController(Gui gui, EnigmaProfile profile) {
        this.gui = gui;
        this.enigma = Enigma.builder().setProfile(profile).build();
    }

    public boolean isDirty() {
        return this.project != null && this.project.getMapper().isDirty();
    }

    public CompletableFuture<Void> openJar(Path jarPath) {
        this.gui.onStartOpenJar();
        return ProgressDialog.runOffThread(this.gui.getFrame(), progress -> {
            this.project = this.enigma.openJar(jarPath, progress);
            this.indexTreeBuilder = new IndexTreeBuilder(this.project.getJarIndex());
            this.chp = new ClassHandleProvider(this.project, Config.getInstance().decompiler.service);
            this.gui.onFinishOpenJar(jarPath.getFileName().toString());
            this.refreshClasses();
        });
    }

    public void closeJar() {
        this.chp.destroy();
        this.chp = null;
        this.project = null;
        this.gui.onCloseJar();
    }

    public CompletableFuture<Void> openMappings(MappingFormat format, Path path) {
        if (this.project == null) {
            return CompletableFuture.completedFuture(null);
        }
        this.gui.setMappingsFile(path);
        return ProgressDialog.runOffThread(this.gui.getFrame(), progress -> {
            try {
                MappingSaveParameters saveParameters = this.enigma.getProfile().getMappingSaveParameters();
                EntryTree<EntryMapping> mappings = format.read(path, progress, saveParameters);
                this.project.setMappings(mappings);
                this.loadedMappingFormat = format;
                this.loadedMappingPath = path;
                this.refreshClasses();
                this.chp.invalidateMapped();
            }
            catch (MappingParseException e) {
                JOptionPane.showMessageDialog(this.gui.getFrame(), e.getMessage());
            }
        });
    }

    @Override
    public void openMappings(EntryTree<EntryMapping> mappings) {
        if (this.project == null) {
            return;
        }
        this.project.setMappings(mappings);
        this.refreshClasses();
        this.chp.invalidateMapped();
    }

    public CompletableFuture<Void> saveMappings(Path path) {
        return this.saveMappings(path, this.loadedMappingFormat);
    }

    public CompletableFuture<Void> saveMappings(Path path, MappingFormat format) {
        if (this.project == null) {
            return CompletableFuture.completedFuture(null);
        }
        return ProgressDialog.runOffThread(this.gui.getFrame(), progress -> {
            EntryRemapper mapper = this.project.getMapper();
            MappingSaveParameters saveParameters = this.enigma.getProfile().getMappingSaveParameters();
            MappingDelta<EntryMapping> delta = mapper.takeMappingDelta();
            boolean saveAll = !path.equals(this.loadedMappingPath);
            this.loadedMappingFormat = format;
            this.loadedMappingPath = path;
            if (saveAll) {
                format.write(mapper.getObfToDeobf(), path, progress, saveParameters);
            } else {
                format.write(mapper.getObfToDeobf(), delta, path, progress, saveParameters);
            }
        });
    }

    public void closeMappings() {
        if (this.project == null) {
            return;
        }
        this.project.setMappings(null);
        this.gui.setMappingsFile(null);
        this.refreshClasses();
        this.chp.invalidateMapped();
    }

    public CompletableFuture<Void> dropMappings() {
        if (this.project == null) {
            return CompletableFuture.completedFuture(null);
        }
        return ProgressDialog.runOffThread(this.gui.getFrame(), progress -> this.project.dropMappings(progress));
    }

    public CompletableFuture<Void> exportSource(Path path) {
        if (this.project == null) {
            return CompletableFuture.completedFuture(null);
        }
        return ProgressDialog.runOffThread(this.gui.getFrame(), progress -> {
            EnigmaProject.JarExport jar = this.project.exportRemappedJar(progress);
            EnigmaProject.SourceExport source = jar.decompile(progress, this.chp.getDecompilerService());
            source.write(path, progress);
        });
    }

    public CompletableFuture<Void> exportJar(Path path) {
        if (this.project == null) {
            return CompletableFuture.completedFuture(null);
        }
        return ProgressDialog.runOffThread(this.gui.getFrame(), progress -> {
            EnigmaProject.JarExport jar = this.project.exportRemappedJar(progress);
            jar.write(path, progress);
        });
    }

    public void setTokenHandle(ClassHandle handle) {
        if (this.tokenHandle != null) {
            this.tokenHandle.close();
        }
        this.tokenHandle = handle;
    }

    public ClassHandle getTokenHandle() {
        return this.tokenHandle;
    }

    public ReadableToken getReadableToken(Token token) {
        if (this.tokenHandle == null) {
            return null;
        }
        try {
            return this.tokenHandle.getSource().get().map(DecompiledClassSource::getIndex).map(index -> new ReadableToken(index.getLineNumber(token.start), index.getColumnNumber(token.start), index.getColumnNumber(token.end))).unwrapOr(null);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void openDeclaration(Entry<?> entry) {
        if (entry == null) {
            throw new IllegalArgumentException("Entry cannot be null!");
        }
        this.openReference(new EntryReference(entry, entry.getName()));
    }

    public void openReference(EntryReference<Entry<?>, Entry<?>> reference) {
        if (reference == null) {
            throw new IllegalArgumentException("Reference cannot be null!");
        }
        if (this.gui.referenceHistory == null) {
            this.gui.referenceHistory = new History(reference);
        } else if (!reference.equals(this.gui.referenceHistory.getCurrent())) {
            this.gui.referenceHistory.push(reference);
        }
        this.setReference(reference);
    }

    private void setReference(EntryReference<Entry<?>, Entry<?>> reference) {
        this.gui.openClass(reference.getLocationClassEntry()).showReference(reference);
    }

    public Collection<Token> getTokensForReference(DecompiledClassSource source, EntryReference<Entry<?>, Entry<?>> reference) {
        EntryRemapper mapper = this.project.getMapper();
        SourceIndex index = source.getIndex();
        return mapper.getObfResolver().resolveReference(reference, ResolutionStrategy.RESOLVE_CLOSEST).stream().flatMap(r -> index.getReferenceTokens((EntryReference<Entry<?>, Entry<?>>)r).stream()).collect(Collectors.toList());
    }

    public void openPreviousReference() {
        if (this.hasPreviousReference()) {
            this.setReference(this.gui.referenceHistory.goBack());
        }
    }

    public boolean hasPreviousReference() {
        return this.gui.referenceHistory != null && this.gui.referenceHistory.canGoBack();
    }

    public void openNextReference() {
        if (this.hasNextReference()) {
            this.setReference(this.gui.referenceHistory.goForward());
        }
    }

    public boolean hasNextReference() {
        return this.gui.referenceHistory != null && this.gui.referenceHistory.canGoForward();
    }

    public void navigateTo(Entry<?> entry) {
        if (!this.project.isRenamable(entry)) {
            return;
        }
        this.openDeclaration(entry);
    }

    public void navigateTo(EntryReference<Entry<?>, Entry<?>> reference) {
        if (!this.project.isRenamable(reference.getLocationClassEntry())) {
            return;
        }
        this.openReference(reference);
    }

    private void refreshClasses() {
        ArrayList<ClassEntry> obfClasses = Lists.newArrayList();
        ArrayList<ClassEntry> deobfClasses = Lists.newArrayList();
        this.addSeparatedClasses(obfClasses, deobfClasses);
        this.gui.setObfClasses(obfClasses);
        this.gui.setDeobfClasses(deobfClasses);
    }

    public void addSeparatedClasses(List<ClassEntry> obfClasses, List<ClassEntry> deobfClasses) {
        EntryRemapper mapper = this.project.getMapper();
        Collection<ClassEntry> classes = this.project.getJarIndex().getEntryIndex().getClasses();
        Stream<ClassEntry> visibleClasses = classes.stream().filter(entry -> !entry.isInnerClass());
        visibleClasses.forEach(entry -> {
            ClassEntry deobfEntry = mapper.deobfuscate(entry);
            List<ObfuscationTestService> obfService = this.enigma.getServices().get(ObfuscationTestService.TYPE);
            boolean obfuscated = deobfEntry.equals((ClassEntry)entry);
            if (obfuscated && !obfService.isEmpty() && obfService.stream().anyMatch(service -> service.testDeobfuscated((Entry<?>)entry))) {
                obfuscated = false;
            }
            if (obfuscated) {
                obfClasses.add((ClassEntry)entry);
            } else {
                deobfClasses.add((ClassEntry)entry);
            }
        });
    }

    public void onModifierChanged(ValidationContext vc, Entry<?> entry, AccessModifier modifier) {
        EntryRemapper mapper = this.project.getMapper();
        EntryMapping mapping = mapper.getDeobfMapping(entry);
        if (mapping != null) {
            mapper.mapFromObf(vc, entry, new EntryMapping(mapping.getTargetName(), modifier));
        } else {
            mapper.mapFromObf(vc, entry, new EntryMapping(entry.getName(), modifier));
        }
        this.chp.invalidateMapped();
    }

    public ClassInheritanceTreeNode getClassInheritance(ClassEntry entry) {
        Translator translator = this.project.getMapper().getDeobfuscator();
        ClassInheritanceTreeNode rootNode = this.indexTreeBuilder.buildClassInheritance(translator, entry);
        return ClassInheritanceTreeNode.findNode(rootNode, entry);
    }

    public ClassImplementationsTreeNode getClassImplementations(ClassEntry entry) {
        Translator translator = this.project.getMapper().getDeobfuscator();
        return this.indexTreeBuilder.buildClassImplementations(translator, entry);
    }

    public MethodInheritanceTreeNode getMethodInheritance(MethodEntry entry) {
        Translator translator = this.project.getMapper().getDeobfuscator();
        MethodInheritanceTreeNode rootNode = this.indexTreeBuilder.buildMethodInheritance(translator, entry);
        return MethodInheritanceTreeNode.findNode(rootNode, entry);
    }

    public MethodImplementationsTreeNode getMethodImplementations(MethodEntry entry) {
        Translator translator = this.project.getMapper().getDeobfuscator();
        List<MethodImplementationsTreeNode> rootNodes = this.indexTreeBuilder.buildMethodImplementations(translator, entry);
        if (rootNodes.isEmpty()) {
            return null;
        }
        if (rootNodes.size() > 1) {
            System.err.println("WARNING: Method " + entry + " implements multiple interfaces. Only showing first one.");
        }
        return MethodImplementationsTreeNode.findNode(rootNodes.get(0), entry);
    }

    public ClassReferenceTreeNode getClassReferences(ClassEntry entry) {
        Translator deobfuscator = this.project.getMapper().getDeobfuscator();
        ClassReferenceTreeNode rootNode = new ClassReferenceTreeNode(deobfuscator, entry);
        rootNode.load(this.project.getJarIndex(), true);
        return rootNode;
    }

    public FieldReferenceTreeNode getFieldReferences(FieldEntry entry) {
        Translator translator = this.project.getMapper().getDeobfuscator();
        FieldReferenceTreeNode rootNode = new FieldReferenceTreeNode(translator, entry);
        rootNode.load(this.project.getJarIndex(), true);
        return rootNode;
    }

    public MethodReferenceTreeNode getMethodReferences(MethodEntry entry, boolean recursive) {
        Translator translator = this.project.getMapper().getDeobfuscator();
        MethodReferenceTreeNode rootNode = new MethodReferenceTreeNode(translator, entry);
        rootNode.load(this.project.getJarIndex(), true, recursive);
        return rootNode;
    }

    @Override
    public void rename(ValidationContext vc, EntryReference<Entry<?>, Entry<?>> reference, String newName, boolean refreshClassTree) {
        this.rename(vc, reference, newName, refreshClassTree, false);
    }

    public void rename(ValidationContext vc, EntryReference<Entry<?>, Entry<?>> reference, String newName, boolean refreshClassTree, boolean validateOnly) {
        Entry<?> entry = reference.getNameableEntry();
        EntryMapping previous = this.project.getMapper().getDeobfMapping(entry);
        this.project.getMapper().mapFromObf(vc, entry, previous != null ? previous.withName(newName) : new EntryMapping(newName), true, validateOnly);
        if (validateOnly || !vc.canProceed()) {
            return;
        }
        if (refreshClassTree && reference.entry instanceof ClassEntry && !((ClassEntry)reference.entry).isInnerClass()) {
            this.gui.moveClassTree((Entry<?>)reference.entry, newName);
        }
        this.chp.invalidateMapped();
    }

    @Override
    public void removeMapping(ValidationContext vc, EntryReference<Entry<?>, Entry<?>> reference) {
        this.project.getMapper().removeByObf(vc, reference.getNameableEntry());
        if (!vc.canProceed()) {
            return;
        }
        if (reference.entry instanceof ClassEntry) {
            this.gui.moveClassTree((Entry<?>)reference.entry, false, true);
        }
        this.chp.invalidateMapped();
    }

    @Override
    public void changeDocs(ValidationContext vc, EntryReference<Entry<?>, Entry<?>> reference, String updatedDocs) {
        this.changeDocs(vc, reference, updatedDocs, false);
    }

    public void changeDocs(ValidationContext vc, EntryReference<Entry<?>, Entry<?>> reference, String updatedDocs, boolean validateOnly) {
        this.changeDoc(vc, (Entry<?>)reference.entry, updatedDocs, validateOnly);
        if (validateOnly || !vc.canProceed()) {
            return;
        }
        this.chp.invalidateJavadoc(reference.getLocationClassEntry());
    }

    private void changeDoc(ValidationContext vc, Entry<?> obfEntry, String newDoc, boolean validateOnly) {
        EntryRemapper mapper = this.project.getMapper();
        EntryMapping deobfMapping = mapper.getDeobfMapping(obfEntry);
        if (deobfMapping == null) {
            deobfMapping = new EntryMapping(mapper.deobfuscate(obfEntry).getName());
        }
        mapper.mapFromObf(vc, obfEntry, deobfMapping.withDocs(newDoc), false, validateOnly);
    }

    @Override
    public void markAsDeobfuscated(ValidationContext vc, EntryReference<Entry<?>, Entry<?>> reference) {
        EntryRemapper mapper = this.project.getMapper();
        Entry<?> entry = reference.getNameableEntry();
        mapper.mapFromObf(vc, entry, new EntryMapping(mapper.deobfuscate(entry).getName()));
        if (!vc.canProceed()) {
            return;
        }
        if (reference.entry instanceof ClassEntry && !((ClassEntry)reference.entry).isInnerClass()) {
            this.gui.moveClassTree((Entry<?>)reference.entry, true, false);
        }
        this.chp.invalidateMapped();
    }

    public void openStats(Set<StatsMember> includedMembers, String topLevelPackage) {
        ProgressDialog.runOffThread(this.gui.getFrame(), progress -> {
            String data = new StatsGenerator(this.project).generate(progress, includedMembers, topLevelPackage);
            try {
                File statsFile = File.createTempFile("stats", ".html");
                try (FileWriter w = new FileWriter(statsFile);){
                    w.write(Utils.readResourceToString("/stats.html").replace("/*data*/", data));
                }
                Desktop.getDesktop().open(statsFile);
            }
            catch (IOException e) {
                throw new Error(e);
            }
        });
    }

    public void setDecompiler(DecompilerService service) {
        this.chp.setDecompilerService(service);
    }

    public ClassHandleProvider getClassHandleProvider() {
        return this.chp;
    }

    public EnigmaClient getClient() {
        return this.client;
    }

    public EnigmaServer getServer() {
        return this.server;
    }

    public void createClient(String username, String ip, int port, char[] password) throws IOException {
        this.client = new EnigmaClient(this, ip, port);
        this.client.connect();
        this.client.sendPacket(new LoginC2SPacket(this.project.getJarChecksum(), password, username));
        this.gui.setConnectionState(ConnectionState.CONNECTED);
    }

    public void createServer(int port, char[] password) throws IOException {
        this.server = new IntegratedEnigmaServer(this.project.getJarChecksum(), password, EntryRemapper.mapped(this.project.getJarIndex(), new HashEntryTree<EntryMapping>(this.project.getMapper().getObfToDeobf())), port);
        this.server.start();
        this.client = new EnigmaClient(this, "127.0.0.1", port);
        this.client.connect();
        this.client.sendPacket(new LoginC2SPacket(this.project.getJarChecksum(), password, "Owner"));
        this.gui.setConnectionState(ConnectionState.HOSTING);
    }

    @Override
    public synchronized void disconnectIfConnected(String reason) {
        if (this.client == null && this.server == null) {
            return;
        }
        if (this.client != null) {
            this.client.disconnect();
        }
        if (this.server != null) {
            this.server.stop();
        }
        this.client = null;
        this.server = null;
        SwingUtilities.invokeLater(() -> {
            if (reason != null) {
                JOptionPane.showMessageDialog(this.gui.getFrame(), I18n.translate(reason), I18n.translate("disconnect.disconnected"), 1);
            }
            this.gui.setConnectionState(ConnectionState.NOT_CONNECTED);
        });
    }

    @Override
    public void sendPacket(Packet<ServerPacketHandler> packet) {
        if (this.client != null) {
            this.client.sendPacket(packet);
        }
    }

    @Override
    public void addMessage(Message message) {
        this.gui.addMessage(message);
    }

    @Override
    public void updateUserList(List<String> users) {
        this.gui.setUserList(users);
    }
}

