/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui;

import com.google.common.io.MoreFiles;
import cuchaz.enigma.EnigmaProfile;
import cuchaz.enigma.gui.Gui;
import cuchaz.enigma.gui.GuiController;
import cuchaz.enigma.gui.config.Config;
import cuchaz.enigma.translation.mapping.serde.MappingFormat;
import cuchaz.enigma.utils.I18n;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.ValueConverter;

public class Main {
    public static void main(String[] args) throws IOException {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<Path> jar = parser.accepts("jar", "Jar file to open at startup").withRequiredArg().withValuesConvertedBy(PathConverter.INSTANCE);
        ArgumentAcceptingOptionSpec<Path> mappings = parser.accepts("mappings", "Mappings file to open at startup").withRequiredArg().withValuesConvertedBy(PathConverter.INSTANCE);
        ArgumentAcceptingOptionSpec<Path> profile = parser.accepts("profile", "Profile json to apply at startup").withRequiredArg().withValuesConvertedBy(PathConverter.INSTANCE);
        parser.accepts("help", "Displays help information");
        try {
            OptionSet options = parser.parse(args);
            if (options.has("help")) {
                parser.printHelpOn(System.out);
                return;
            }
            EnigmaProfile parsedProfile = EnigmaProfile.read(options.valueOf(profile));
            I18n.setLanguage(Config.getInstance().language);
            Gui gui = new Gui(parsedProfile);
            GuiController controller = gui.getController();
            if (options.has(jar)) {
                Path jarPath = options.valueOf(jar);
                controller.openJar(jarPath).whenComplete((v, t) -> {
                    if (options.has(mappings)) {
                        Path mappingsPath = (Path)options.valueOf(mappings);
                        if (Files.isDirectory(mappingsPath, new LinkOption[0])) {
                            controller.openMappings(MappingFormat.ENIGMA_DIRECTORY, mappingsPath);
                        } else if ("zip".equalsIgnoreCase(MoreFiles.getFileExtension(mappingsPath))) {
                            controller.openMappings(MappingFormat.ENIGMA_ZIP, mappingsPath);
                        } else {
                            controller.openMappings(MappingFormat.ENIGMA_FILE, mappingsPath);
                        }
                    }
                });
            }
        }
        catch (OptionException e) {
            System.out.println("Invalid arguments: " + e.getMessage());
            System.out.println();
            parser.printHelpOn(System.out);
        }
    }

    public static class PathConverter
    implements ValueConverter<Path> {
        public static final ValueConverter<Path> INSTANCE = new PathConverter();

        PathConverter() {
        }

        @Override
        public Path convert(String path) {
            if (path.startsWith("~")) {
                Path dirHome = Paths.get(System.getProperty("user.home"), new String[0]);
                if (path.startsWith("~/")) {
                    return dirHome.resolve(path.substring(2));
                }
                return dirHome.getParent().resolve(path.substring(1));
            }
            return Paths.get(path, new String[0]);
        }

        @Override
        public Class<? extends Path> valueType() {
            return Path.class;
        }

        @Override
        public String valuePattern() {
            return "path";
        }
    }
}

