/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.dialog;

import cuchaz.enigma.gui.util.ScaleUtil;
import cuchaz.enigma.utils.I18n;
import cuchaz.enigma.utils.Pair;
import cuchaz.enigma.utils.validation.ValidationContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class AbstractDialog
extends JDialog {
    protected final ValidationContext vc = new ValidationContext();
    private boolean actionConfirm = false;

    public AbstractDialog(Frame owner, String title, String confirmAction, String cancelAction) {
        super(owner, I18n.translate(title), true);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel inputContainer = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        List<Pair<String, Component>> components = this.createComponents();
        int i = 0;
        while (i < components.size()) {
            Pair<String, Component> entry = components.get(i);
            JLabel label = new JLabel(I18n.translate((String)entry.a));
            Component component = (Component)entry.b;
            c.gridy = i++;
            c.insets = ScaleUtil.getInsets(4, 4, 4, 4);
            c.gridx = 0;
            c.weightx = 0.0;
            c.anchor = 22;
            c.fill = 0;
            inputContainer.add((Component)label, c);
            c.gridx = 1;
            c.weightx = 1.0;
            c.anchor = 21;
            c.fill = 2;
            inputContainer.add(component, c);
        }
        contentPane.add((Component)inputContainer, "Center");
        JPanel buttonContainer = new JPanel(new FlowLayout(2, ScaleUtil.scale(4), ScaleUtil.scale(4)));
        JButton connectButton = new JButton(I18n.translate(confirmAction));
        connectButton.addActionListener(event -> this.confirm());
        buttonContainer.add(connectButton);
        JButton abortButton = new JButton(I18n.translate(cancelAction));
        abortButton.addActionListener(event -> this.cancel());
        buttonContainer.add(abortButton);
        contentPane.add((Component)buttonContainer, "South");
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    protected abstract List<Pair<String, Component>> createComponents();

    protected void confirm() {
        this.vc.reset();
        this.validateInputs();
        if (this.vc.canProceed()) {
            this.actionConfirm = true;
            this.setVisible(false);
        }
    }

    protected void cancel() {
        this.actionConfirm = false;
        this.setVisible(false);
    }

    public boolean isActionConfirm() {
        return this.actionConfirm;
    }

    public void validateInputs() {
    }
}

