/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.dialog;

import cuchaz.enigma.gui.dialog.AbstractDialog;
import cuchaz.enigma.gui.elements.ValidatableTextField;
import cuchaz.enigma.gui.util.ScaleUtil;
import cuchaz.enigma.network.ServerAddress;
import cuchaz.enigma.utils.Pair;
import cuchaz.enigma.utils.validation.Message;
import cuchaz.enigma.utils.validation.StandardValidation;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class ConnectToServerDialog
extends AbstractDialog {
    private JTextField usernameField;
    private ValidatableTextField ipField;
    private JPasswordField passwordField;

    public ConnectToServerDialog(Frame owner) {
        super(owner, "prompt.connect.title", "prompt.connect.confirm", "prompt.cancel");
        Dimension preferredSize = this.getPreferredSize();
        preferredSize.width = ScaleUtil.scale(400);
        this.setPreferredSize(preferredSize);
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    @Override
    protected List<Pair<String, Component>> createComponents() {
        this.usernameField = new JTextField(System.getProperty("user.name"));
        this.ipField = new ValidatableTextField();
        this.passwordField = new JPasswordField();
        this.usernameField.addActionListener(event -> this.confirm());
        this.ipField.addActionListener(event -> this.confirm());
        this.passwordField.addActionListener(event -> this.confirm());
        return Arrays.asList(new Pair<String, JTextField>("prompt.connect.username", this.usernameField), new Pair<String, ValidatableTextField>("prompt.connect.address", this.ipField), new Pair<String, JPasswordField>("prompt.password", this.passwordField));
    }

    @Override
    public void validateInputs() {
        this.vc.setActiveElement(this.ipField);
        if (StandardValidation.notBlank(this.vc, this.ipField.getText())) {
            this.vc.raise(Message.INVALID_IP, new Object[0]);
        }
    }

    public Result getResult() {
        if (!this.isActionConfirm()) {
            return null;
        }
        this.vc.reset();
        this.validateInputs();
        if (!this.vc.canProceed()) {
            return null;
        }
        return new Result(this.usernameField.getText(), Objects.requireNonNull(ServerAddress.from(this.ipField.getText(), 34712)), this.passwordField.getPassword());
    }

    public static Result show(Frame parent) {
        ConnectToServerDialog d = new ConnectToServerDialog(parent);
        d.setVisible(true);
        Result r = d.getResult();
        d.dispose();
        return r;
    }

    public static class Result {
        private final String username;
        private final ServerAddress address;
        private final char[] password;

        public Result(String username, ServerAddress address, char[] password) {
            this.username = username;
            this.address = address;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public ServerAddress getAddress() {
            return this.address;
        }

        public char[] getPassword() {
            return this.password;
        }
    }
}

