/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.dialog;

import cuchaz.enigma.gui.Gui;
import cuchaz.enigma.gui.stats.StatsMember;
import cuchaz.enigma.gui.util.ScaleUtil;
import cuchaz.enigma.utils.I18n;
import java.awt.GridLayout;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class StatsDialog {
    public static void show(Gui gui) {
        JFrame frame = new JFrame(I18n.translate("menu.file.stats.title"));
        JPanel checkboxesPanel = new JPanel();
        JPanel topLevelPackagePanel = new JPanel();
        JPanel buttonPanel = new JPanel();
        frame.setLayout(new GridLayout(3, 0));
        frame.add(checkboxesPanel);
        frame.add(topLevelPackagePanel);
        frame.add(buttonPanel);
        Map<StatsMember, JCheckBox> checkboxes = Arrays.stream(StatsMember.values()).collect(Collectors.toMap(m3 -> m3, m3 -> {
            JCheckBox checkbox = new JCheckBox(I18n.translate("type." + m3.name().toLowerCase(Locale.ROOT)));
            checkboxesPanel.add(checkbox);
            return checkbox;
        }));
        JLabel topLevelPackageOption = new JLabel(I18n.translate("menu.file.stats.top_level_package"));
        JTextField topLevelPackage = new JTextField();
        topLevelPackage.setPreferredSize(ScaleUtil.getDimension(200, 25));
        topLevelPackagePanel.add(topLevelPackageOption);
        topLevelPackagePanel.add(topLevelPackage);
        JButton button = new JButton(I18n.translate("menu.file.stats.generate"));
        buttonPanel.add(button);
        button.setEnabled(false);
        button.addActionListener(action -> {
            frame.dispose();
            StatsDialog.generateStats(gui, checkboxes, topLevelPackage.getText());
        });
        checkboxes.entrySet().forEach(checkbox -> ((JCheckBox)checkbox.getValue()).addActionListener(action -> {
            if (!button.isEnabled()) {
                button.setEnabled(true);
            } else if (checkboxes.entrySet().stream().allMatch(entry -> !((JCheckBox)entry.getValue()).isSelected())) {
                button.setEnabled(false);
            }
        }));
        frame.pack();
        frame.setVisible(true);
        frame.setSize(ScaleUtil.getDimension(500, 150));
        frame.setResizable(false);
        frame.setLocationRelativeTo(gui.getFrame());
    }

    private static void generateStats(Gui gui, Map<StatsMember, JCheckBox> checkboxes, String topLevelPackage) {
        Set<StatsMember> includedMembers = checkboxes.entrySet().stream().filter(entry -> ((JCheckBox)entry.getValue()).isSelected()).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (gui.getController().project != null) {
            gui.getController().openStats(includedMembers, topLevelPackage);
        }
    }
}

