/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.panels;

import cuchaz.enigma.EnigmaProject;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.classhandle.ClassHandle;
import cuchaz.enigma.classhandle.ClassHandleError;
import cuchaz.enigma.events.ClassHandleListener;
import cuchaz.enigma.gui.BrowserCaret;
import cuchaz.enigma.gui.Gui;
import cuchaz.enigma.gui.GuiController;
import cuchaz.enigma.gui.config.Config;
import cuchaz.enigma.gui.config.Themes;
import cuchaz.enigma.gui.elements.PopupMenuBar;
import cuchaz.enigma.gui.events.EditorActionListener;
import cuchaz.enigma.gui.events.ThemeChangeListener;
import cuchaz.enigma.gui.highlight.BoxHighlightPainter;
import cuchaz.enigma.gui.highlight.SelectionHighlightPainter;
import cuchaz.enigma.gui.util.ScaleUtil;
import cuchaz.enigma.source.DecompiledClassSource;
import cuchaz.enigma.source.RenamableTokenType;
import cuchaz.enigma.source.Token;
import cuchaz.enigma.translation.mapping.EntryRemapper;
import cuchaz.enigma.translation.mapping.EntryResolver;
import cuchaz.enigma.translation.mapping.ResolutionStrategy;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import cuchaz.enigma.utils.I18n;
import cuchaz.enigma.utils.Result;
import de.sciss.syntaxpane.DefaultSyntaxKit;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;

public class EditorPanel {
    private final JPanel ui = new JPanel();
    private final JEditorPane editor = new JEditorPane();
    private final JScrollPane editorScrollPane = new JScrollPane(this.editor);
    private final PopupMenuBar popupMenu;
    private final JLabel decompilingLabel = new JLabel(I18n.translate("editor.decompiling"), 0);
    private final JProgressBar decompilingProgressBar = new JProgressBar(0, 100);
    private final JLabel errorLabel = new JLabel();
    private final JTextArea errorTextArea = new JTextArea();
    private final JScrollPane errorScrollPane = new JScrollPane(this.errorTextArea);
    private final JButton retryButton = new JButton(I18n.translate("general.retry"));
    private DisplayMode mode = DisplayMode.INACTIVE;
    private final GuiController controller;
    private final Gui gui;
    private EntryReference<Entry<?>, Entry<?>> cursorReference;
    private boolean mouseIsPressed = false;
    private boolean shouldNavigateOnClick;
    public Config.LookAndFeel editorLaf;
    private int fontSize = 12;
    private Map<RenamableTokenType, BoxHighlightPainter> boxHighlightPainters;
    private final List<EditorActionListener> listeners = new ArrayList<EditorActionListener>();
    private final ThemeChangeListener themeChangeListener;
    private ClassHandle classHandle;
    private DecompiledClassSource source;
    private boolean settingSource;

    public EditorPanel(final Gui gui) {
        this.gui = gui;
        this.controller = gui.getController();
        this.editor.setEditable(false);
        this.editor.setSelectionColor(new Color(31, 46, 90));
        this.editor.setCaret(new BrowserCaret());
        this.editor.setFont(ScaleUtil.getFont(this.editor.getFont().getFontName(), 0, this.fontSize));
        this.editor.addCaretListener(event -> this.onCaretMove(event.getDot(), this.mouseIsPressed));
        this.editor.setCaretColor(new Color(Config.getInstance().caretColor));
        this.editor.setContentType("text/enigma-sources");
        this.editor.setBackground(new Color(Config.getInstance().editorBackground));
        DefaultSyntaxKit kit = (DefaultSyntaxKit)this.editor.getEditorKit();
        kit.toggleComponent(this.editor, "de.sciss.syntaxpane.components.TokenMarker");
        this.popupMenu = new PopupMenuBar(this, gui);
        this.editor.setComponentPopupMenu(this.popupMenu);
        this.decompilingLabel.setFont(ScaleUtil.getFont(this.decompilingLabel.getFont().getFontName(), 1, 26));
        this.decompilingProgressBar.setIndeterminate(true);
        this.errorTextArea.setEditable(false);
        this.errorTextArea.setFont(ScaleUtil.getFont("Monospaced", 0, 10));
        this.boxHighlightPainters = Themes.getBoxHighlightPainters();
        this.editor.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                EditorPanel.this.mouseIsPressed = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                switch (e.getButton()) {
                    case 3: {
                        EditorPanel.this.editor.setCaretPosition(EditorPanel.this.editor.viewToModel(e.getPoint()));
                        break;
                    }
                    case 4: {
                        gui.getController().openPreviousReference();
                        break;
                    }
                    case 5: {
                        gui.getController().openNextReference();
                    }
                }
                EditorPanel.this.mouseIsPressed = false;
            }
        });
        this.editor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.isControlDown()) {
                    EditorPanel.this.shouldNavigateOnClick = false;
                    switch (event.getKeyCode()) {
                        case 73: {
                            ((EditorPanel)EditorPanel.this).popupMenu.showInheritanceMenu.doClick();
                            break;
                        }
                        case 77: {
                            ((EditorPanel)EditorPanel.this).popupMenu.showImplementationsMenu.doClick();
                            break;
                        }
                        case 78: {
                            ((EditorPanel)EditorPanel.this).popupMenu.openEntryMenu.doClick();
                            break;
                        }
                        case 80: {
                            ((EditorPanel)EditorPanel.this).popupMenu.openPreviousMenu.doClick();
                            break;
                        }
                        case 69: {
                            ((EditorPanel)EditorPanel.this).popupMenu.openNextMenu.doClick();
                            break;
                        }
                        case 67: {
                            if (event.isShiftDown()) {
                                ((EditorPanel)EditorPanel.this).popupMenu.showCallsSpecificMenu.doClick();
                                break;
                            }
                            ((EditorPanel)EditorPanel.this).popupMenu.showCallsMenu.doClick();
                            break;
                        }
                        case 79: {
                            ((EditorPanel)EditorPanel.this).popupMenu.toggleMappingMenu.doClick();
                            break;
                        }
                        case 82: {
                            ((EditorPanel)EditorPanel.this).popupMenu.renameMenu.doClick();
                            break;
                        }
                        case 68: {
                            ((EditorPanel)EditorPanel.this).popupMenu.editJavadocMenu.doClick();
                            break;
                        }
                        case 116: {
                            if (EditorPanel.this.classHandle == null) break;
                            EditorPanel.this.classHandle.invalidateMapped();
                            break;
                        }
                        case 70: {
                            break;
                        }
                        case 61: 
                        case 107: 
                        case 521: {
                            EditorPanel.this.offsetEditorZoom(2);
                            break;
                        }
                        case 45: 
                        case 109: {
                            EditorPanel.this.offsetEditorZoom(-2);
                            break;
                        }
                        default: {
                            EditorPanel.this.shouldNavigateOnClick = true;
                        }
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent event) {
                if (!((EditorPanel)EditorPanel.this).popupMenu.renameMenu.isEnabled()) {
                    return;
                }
                if (!event.isControlDown() && !event.isAltDown() && Character.isJavaIdentifierPart(event.getKeyChar())) {
                    String packageName;
                    EnigmaProject project = gui.getController().project;
                    EntryReference reference = project.getMapper().deobfuscate(EditorPanel.this.cursorReference);
                    Entry<?> entry = reference.getNameableEntry();
                    String name = String.valueOf(event.getKeyChar());
                    if (entry instanceof ClassEntry && ((ClassEntry)entry).getParent() == null && (packageName = ((ClassEntry)entry).getPackageName()) != null) {
                        name = packageName + "/" + name;
                    }
                    gui.startRename(EditorPanel.this, name);
                }
            }

            @Override
            public void keyReleased(KeyEvent event) {
                EditorPanel.this.shouldNavigateOnClick = event.isControlDown();
            }
        });
        this.retryButton.addActionListener(_e -> this.redecompileClass());
        this.themeChangeListener = (laf, boxHighlightPainters) -> {
            if (this.editorLaf == null || this.editorLaf != laf) {
                this.editor.updateUI();
                this.editor.setBackground(new Color(Config.getInstance().editorBackground));
                if (this.editorLaf != null) {
                    this.classHandle.invalidateMapped();
                }
                this.editorLaf = laf;
            }
            this.boxHighlightPainters = boxHighlightPainters;
        };
        this.ui.putClientProperty(EditorPanel.class, this);
    }

    @Nullable
    public static EditorPanel byUi(Component ui) {
        Object prop;
        if (ui instanceof JComponent && (prop = ((JComponent)ui).getClientProperty(EditorPanel.class)) instanceof EditorPanel) {
            return (EditorPanel)prop;
        }
        return null;
    }

    public void setClassHandle(ClassHandle handle) {
        ClassEntry old = null;
        if (this.classHandle != null) {
            old = this.classHandle.getRef();
            this.classHandle.close();
        }
        this.setClassHandle0(old, handle);
    }

    private void setClassHandle0(ClassEntry old, ClassHandle handle) {
        this.setDisplayMode(DisplayMode.IN_PROGRESS);
        this.setCursorReference(null);
        handle.addListener(new ClassHandleListener(){

            @Override
            public void onDeobfRefChanged(ClassHandle h2, ClassEntry deobfRef) {
                SwingUtilities.invokeLater(() -> EditorPanel.this.listeners.forEach(l -> l.onTitleChanged(EditorPanel.this, EditorPanel.this.getFileName())));
            }

            @Override
            public void onMappedSourceChanged(ClassHandle h2, Result<DecompiledClassSource, ClassHandleError> res) {
                EditorPanel.this.handleDecompilerResult(res);
            }

            @Override
            public void onInvalidate(ClassHandle h2, ClassHandleListener.InvalidationType t) {
                SwingUtilities.invokeLater(() -> {
                    if (t == ClassHandleListener.InvalidationType.FULL) {
                        EditorPanel.this.setDisplayMode(DisplayMode.IN_PROGRESS);
                    }
                });
            }

            @Override
            public void onDeleted(ClassHandle h2) {
                SwingUtilities.invokeLater(() -> EditorPanel.this.gui.closeEditor(EditorPanel.this));
            }
        });
        handle.getSource().thenAcceptAsync(this::handleDecompilerResult, SwingUtilities::invokeLater);
        this.classHandle = handle;
        this.listeners.forEach(l -> l.onClassHandleChanged(this, old, handle));
    }

    public void setup() {
        Themes.addListener(this.themeChangeListener);
    }

    public void destroy() {
        Themes.removeListener(this.themeChangeListener);
        this.classHandle.close();
    }

    private void redecompileClass() {
        if (this.classHandle != null) {
            this.classHandle.invalidate();
        }
    }

    private void handleDecompilerResult(Result<DecompiledClassSource, ClassHandleError> res) {
        SwingUtilities.invokeLater(() -> {
            if (res.isOk()) {
                this.setSource((DecompiledClassSource)res.unwrap());
            } else {
                this.displayError((ClassHandleError)res.unwrapErr());
            }
        });
    }

    public void displayError(ClassHandleError t) {
        String str;
        this.setDisplayMode(DisplayMode.ERRORED);
        switch (t.type) {
            case DECOMPILE: {
                str = "editor.decompile_error";
                break;
            }
            case REMAP: {
                str = "editor.remap_error";
                break;
            }
            default: {
                throw new IllegalStateException("unreachable");
            }
        }
        this.errorLabel.setText(I18n.translate(str));
        this.errorTextArea.setText(t.getStackTrace());
        this.errorTextArea.setCaretPosition(0);
    }

    public void setDisplayMode(DisplayMode mode) {
        if (this.mode == mode) {
            return;
        }
        this.ui.removeAll();
        switch (mode) {
            case INACTIVE: {
                break;
            }
            case IN_PROGRESS: {
                this.decompilingProgressBar.setIndeterminate(false);
                this.decompilingProgressBar.setIndeterminate(true);
                this.ui.setLayout(new GridBagLayout());
                GridBagConstraints c = new GridBagConstraints();
                c.gridx = 0;
                c.gridy = 0;
                c.insets = ScaleUtil.getInsets(2, 2, 2, 2);
                c.anchor = 15;
                this.ui.add((Component)this.decompilingLabel, c);
                c.gridy = 1;
                c.anchor = 11;
                this.ui.add((Component)this.decompilingProgressBar, c);
                break;
            }
            case SUCCESS: {
                this.ui.setLayout(new GridLayout(1, 1, 0, 0));
                this.ui.add(this.editorScrollPane);
                break;
            }
            case ERRORED: {
                this.ui.setLayout(new GridBagLayout());
                GridBagConstraints c = new GridBagConstraints();
                c.insets = ScaleUtil.getInsets(2, 2, 2, 2);
                c.gridx = 0;
                c.gridy = 0;
                c.weightx = 1.0;
                c.anchor = 17;
                this.ui.add((Component)this.errorLabel, c);
                c.gridy = 1;
                c.fill = 2;
                this.ui.add((Component)new JSeparator(0), c);
                c.gridy = 2;
                c.fill = 1;
                c.weighty = 1.0;
                this.ui.add((Component)this.errorScrollPane, c);
                c.gridy = 3;
                c.fill = 0;
                c.anchor = 13;
                c.weightx = 0.0;
                c.weighty = 0.0;
                this.ui.add((Component)this.retryButton, c);
                break;
            }
        }
        this.ui.validate();
        this.ui.repaint();
        this.mode = mode;
    }

    public void offsetEditorZoom(int zoomAmount) {
        int newResult = this.fontSize + zoomAmount;
        if (newResult > 8 && newResult < 72) {
            this.fontSize = newResult;
            this.editor.setFont(ScaleUtil.getFont(this.editor.getFont().getFontName(), 0, this.fontSize));
        }
    }

    public void resetEditorZoom() {
        this.fontSize = 12;
        this.editor.setFont(ScaleUtil.getFont(this.editor.getFont().getFontName(), 0, this.fontSize));
    }

    public void onCaretMove(int pos, boolean fromClick) {
        Object referenceEntry;
        if (this.controller.project == null) {
            return;
        }
        EntryRemapper mapper = this.controller.project.getMapper();
        Token token = this.getToken(pos);
        if (this.settingSource) {
            EntryReference<Entry<Entry<?>>, Entry<Entry<?>>> ref = this.getCursorReference();
            EntryReference<Entry<?>, Entry<?>> refAtCursor = this.getReference(token);
            if (this.editor.getDocument().getLength() != 0 && ref != null && !ref.equals(refAtCursor)) {
                this.showReference0(ref);
            }
            return;
        }
        this.setCursorReference(this.getReference(token));
        Object v0 = referenceEntry = this.cursorReference != null ? this.cursorReference.entry : null;
        if (referenceEntry != null && this.shouldNavigateOnClick && fromClick) {
            this.shouldNavigateOnClick = false;
            Object navigationEntry = referenceEntry;
            if (this.cursorReference.context == null) {
                EntryResolver resolver = mapper.getObfResolver();
                navigationEntry = resolver.resolveFirstEntry(referenceEntry, ResolutionStrategy.RESOLVE_ROOT);
            }
            this.controller.navigateTo((Entry<?>)navigationEntry);
        }
    }

    private void setCursorReference(EntryReference<Entry<?>, Entry<?>> ref) {
        this.cursorReference = ref;
        Object referenceEntry = ref == null ? null : (Object)ref.entry;
        boolean isClassEntry = referenceEntry instanceof ClassEntry;
        boolean isFieldEntry = referenceEntry instanceof FieldEntry;
        boolean isMethodEntry = referenceEntry instanceof MethodEntry && !((MethodEntry)referenceEntry).isConstructor();
        boolean isConstructorEntry = referenceEntry instanceof MethodEntry && ((MethodEntry)referenceEntry).isConstructor();
        boolean isRenamable = ref != null && this.controller.project.isRenamable(ref);
        this.popupMenu.renameMenu.setEnabled(isRenamable);
        this.popupMenu.editJavadocMenu.setEnabled(isRenamable);
        this.popupMenu.showInheritanceMenu.setEnabled(isClassEntry || isMethodEntry || isConstructorEntry);
        this.popupMenu.showImplementationsMenu.setEnabled(isClassEntry || isMethodEntry);
        this.popupMenu.showCallsMenu.setEnabled(isClassEntry || isFieldEntry || isMethodEntry || isConstructorEntry);
        this.popupMenu.showCallsSpecificMenu.setEnabled(isMethodEntry);
        this.popupMenu.openEntryMenu.setEnabled(isRenamable && (isClassEntry || isFieldEntry || isMethodEntry || isConstructorEntry));
        this.popupMenu.openPreviousMenu.setEnabled(this.controller.hasPreviousReference());
        this.popupMenu.openNextMenu.setEnabled(this.controller.hasNextReference());
        this.popupMenu.toggleMappingMenu.setEnabled(isRenamable);
        if (referenceEntry != null && referenceEntry.equals(this.controller.project.getMapper().deobfuscate(referenceEntry))) {
            this.popupMenu.toggleMappingMenu.setText(I18n.translate("popup_menu.reset_obfuscated"));
        } else {
            this.popupMenu.toggleMappingMenu.setText(I18n.translate("popup_menu.mark_deobfuscated"));
        }
        this.listeners.forEach(l -> l.onCursorReferenceChanged(this, ref));
    }

    public Token getToken(int pos) {
        if (this.source == null) {
            return null;
        }
        return this.source.getIndex().getReferenceToken(pos);
    }

    @Nullable
    public EntryReference<Entry<?>, Entry<?>> getReference(Token token) {
        if (this.source == null) {
            return null;
        }
        return this.source.getIndex().getReference(token);
    }

    public void setSource(DecompiledClassSource source) {
        this.setDisplayMode(DisplayMode.SUCCESS);
        if (source == null) {
            return;
        }
        try {
            this.settingSource = true;
            this.source = source;
            this.editor.getHighlighter().removeAllHighlights();
            this.editor.setText(source.toString());
            this.setHighlightedTokens(source.getHighlightedTokens());
        }
        finally {
            this.settingSource = false;
        }
        this.showReference0(this.getCursorReference());
    }

    public void setHighlightedTokens(Map<RenamableTokenType, Collection<Token>> tokens) {
        this.editor.getHighlighter().removeAllHighlights();
        if (this.boxHighlightPainters != null) {
            for (RenamableTokenType type : tokens.keySet()) {
                BoxHighlightPainter painter = this.boxHighlightPainters.get((Object)type);
                if (painter == null) continue;
                this.setHighlightedTokens((Iterable<Token>)tokens.get((Object)type), painter);
            }
        }
        this.editor.validate();
        this.editor.repaint();
    }

    private void setHighlightedTokens(Iterable<Token> tokens, Highlighter.HighlightPainter painter) {
        for (Token token : tokens) {
            try {
                this.editor.getHighlighter().addHighlight(token.start, token.end, painter);
            }
            catch (BadLocationException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }

    public EntryReference<Entry<?>, Entry<?>> getCursorReference() {
        return this.cursorReference;
    }

    public void showReference(EntryReference<Entry<?>, Entry<?>> reference) {
        this.setCursorReference(reference);
        this.showReference0(reference);
    }

    private void showReference0(EntryReference<Entry<?>, Entry<?>> reference) {
        if (this.source == null) {
            return;
        }
        if (reference == null) {
            return;
        }
        Collection<Token> tokens = this.controller.getTokensForReference(this.source, reference);
        if (tokens.isEmpty()) {
            System.err.println(String.format("WARNING: no tokens found for %s in %s", reference, this.classHandle.getRef()));
        } else {
            this.gui.showTokens(this, tokens);
        }
    }

    public void navigateToToken(Token token) {
        if (token == null) {
            throw new IllegalArgumentException("Token cannot be null!");
        }
        this.navigateToToken(token, SelectionHighlightPainter.INSTANCE);
    }

    private void navigateToToken(final Token token, final Highlighter.HighlightPainter highlightPainter) {
        Document document = this.editor.getDocument();
        int clampedPosition = Math.min(Math.max(token.start, 0), document.getLength());
        this.editor.setCaretPosition(clampedPosition);
        this.editor.grabFocus();
        try {
            Rectangle start = this.editor.modelToView(token.start);
            Rectangle end = this.editor.modelToView(token.end);
            if (start == null || end == null) {
                return;
            }
            Rectangle show = start.union(end);
            show.grow(start.width * 10, start.height * 6);
            SwingUtilities.invokeLater(() -> this.editor.scrollRectToVisible(show));
        }
        catch (BadLocationException ex) {
            if (!this.settingSource) {
                throw new RuntimeException(ex);
            }
            return;
        }
        Timer timer = new Timer(200, new ActionListener(){
            private int counter = 0;
            private Object highlight = null;

            @Override
            public void actionPerformed(ActionEvent event) {
                if (this.counter % 2 == 0) {
                    try {
                        this.highlight = EditorPanel.this.editor.getHighlighter().addHighlight(token.start, token.end, highlightPainter);
                    }
                    catch (BadLocationException badLocationException) {}
                } else if (this.highlight != null) {
                    EditorPanel.this.editor.getHighlighter().removeHighlight(this.highlight);
                }
                if (this.counter++ > 6) {
                    Timer timer = (Timer)event.getSource();
                    timer.stop();
                }
            }
        });
        timer.start();
    }

    public void addListener(EditorActionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(EditorActionListener listener) {
        this.listeners.remove(listener);
    }

    public JPanel getUi() {
        return this.ui;
    }

    public JEditorPane getEditor() {
        return this.editor;
    }

    public DecompiledClassSource getSource() {
        return this.source;
    }

    public ClassHandle getClassHandle() {
        return this.classHandle;
    }

    public String getFileName() {
        ClassEntry classEntry = this.classHandle.getDeobfRef() != null ? this.classHandle.getDeobfRef() : this.classHandle.getRef();
        return classEntry.getSimpleName();
    }

    private static enum DisplayMode {
        INACTIVE,
        IN_PROGRESS,
        SUCCESS,
        ERRORED;

    }
}

