/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.network;

import java.util.Objects;
import javax.annotation.Nullable;

public class ServerAddress {
    public final String address;
    public final int port;

    private ServerAddress(String address, int port) {
        this.address = address;
        this.port = port;
    }

    @Nullable
    public static ServerAddress of(String address, int port) {
        if (port < 0 || port > 65535) {
            return null;
        }
        if (address == null) {
            return null;
        }
        if (address.equals("")) {
            return null;
        }
        if (!address.matches("[a-zA-Z0-9.:-]+")) {
            return null;
        }
        if (address.startsWith("-") || address.endsWith("-")) {
            return null;
        }
        return new ServerAddress(address, port);
    }

    @Nullable
    public static ServerAddress from(String s2, int defaultPort) {
        int port;
        String address;
        int idx = s2.indexOf(93);
        if (s2.startsWith("[") && idx != -1) {
            address = s2.substring(1, idx);
            s2 = s2.substring(idx + 1);
        } else if (s2.chars().filter(c -> c == 58).count() == 1L) {
            idx = s2.indexOf(58);
            address = s2.substring(0, idx);
            s2 = s2.substring(idx);
        } else {
            address = s2;
            s2 = "";
        }
        if (s2.isEmpty()) {
            port = defaultPort;
        } else if (s2.startsWith(":")) {
            s2 = s2.substring(1);
            try {
                port = Integer.parseInt(s2);
            }
            catch (NumberFormatException e) {
                return null;
            }
        } else {
            return null;
        }
        return ServerAddress.of(address, port);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerAddress that = (ServerAddress)o;
        return this.port == that.port && Objects.equals(this.address, that.address);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.port);
    }

    public String toString() {
        return String.format("ServerAddress { address: '%s', port: %d }", this.address, this.port);
    }
}

