/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.network.packet;

import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.network.ClientPacketHandler;
import cuchaz.enigma.network.packet.ConfirmChangeC2SPacket;
import cuchaz.enigma.network.packet.Packet;
import cuchaz.enigma.network.packet.PacketHelper;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.utils.validation.PrintValidatable;
import cuchaz.enigma.utils.validation.ValidationContext;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class RenameS2CPacket
implements Packet<ClientPacketHandler> {
    private int syncId;
    private Entry<?> entry;
    private String newName;
    private boolean refreshClassTree;

    RenameS2CPacket() {
    }

    public RenameS2CPacket(int syncId, Entry<?> entry, String newName, boolean refreshClassTree) {
        this.syncId = syncId;
        this.entry = entry;
        this.newName = newName;
        this.refreshClassTree = refreshClassTree;
    }

    @Override
    public void read(DataInput input) throws IOException {
        this.syncId = input.readUnsignedShort();
        this.entry = PacketHelper.readEntry(input);
        this.newName = PacketHelper.readString(input);
        this.refreshClassTree = input.readBoolean();
    }

    @Override
    public void write(DataOutput output) throws IOException {
        output.writeShort(this.syncId);
        PacketHelper.writeEntry(output, this.entry);
        PacketHelper.writeString(output, this.newName);
        output.writeBoolean(this.refreshClassTree);
    }

    @Override
    public void handle(ClientPacketHandler controller) {
        ValidationContext vc = new ValidationContext();
        vc.setActiveElement(PrintValidatable.INSTANCE);
        controller.rename(vc, new EntryReference(this.entry, this.entry.getName()), this.newName, this.refreshClassTree);
        if (!vc.canProceed()) {
            return;
        }
        controller.sendPacket(new ConfirmChangeC2SPacket(this.syncId));
    }
}

