/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.source.procyon;

import com.strobel.assembler.metadata.MetadataSystem;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.DecompilerSettings;
import com.strobel.decompiler.languages.java.BraceStyle;
import com.strobel.decompiler.languages.java.JavaFormattingOptions;
import com.strobel.decompiler.languages.java.ast.AstBuilder;
import com.strobel.decompiler.languages.java.ast.CompilationUnit;
import com.strobel.decompiler.languages.java.ast.InsertParenthesesVisitor;
import cuchaz.enigma.ClassProvider;
import cuchaz.enigma.source.Decompiler;
import cuchaz.enigma.source.Source;
import cuchaz.enigma.source.SourceSettings;
import cuchaz.enigma.source.procyon.ProcyonSource;
import cuchaz.enigma.source.procyon.transformers.DropImportAstTransform;
import cuchaz.enigma.source.procyon.transformers.DropVarModifiersAstTransform;
import cuchaz.enigma.source.procyon.transformers.InvalidIdentifierFix;
import cuchaz.enigma.source.procyon.transformers.Java8Generics;
import cuchaz.enigma.source.procyon.transformers.ObfuscatedEnumSwitchRewriterTransform;
import cuchaz.enigma.source.procyon.transformers.RemoveObjectCasts;
import cuchaz.enigma.source.procyon.transformers.VarargsFixer;
import cuchaz.enigma.source.procyon.typeloader.CompiledSourceTypeLoader;
import cuchaz.enigma.source.procyon.typeloader.NoRetryMetadataSystem;
import cuchaz.enigma.source.procyon.typeloader.SynchronizedTypeLoader;

public class ProcyonDecompiler
implements Decompiler {
    private final SourceSettings settings;
    private final DecompilerSettings decompilerSettings;
    private final MetadataSystem metadataSystem;

    public ProcyonDecompiler(ClassProvider classProvider, SourceSettings settings) {
        SynchronizedTypeLoader typeLoader = new SynchronizedTypeLoader(new CompiledSourceTypeLoader(classProvider));
        this.metadataSystem = new NoRetryMetadataSystem(typeLoader);
        this.metadataSystem.setEagerMethodLoadingEnabled(true);
        this.decompilerSettings = DecompilerSettings.javaDefaults();
        this.decompilerSettings.setMergeVariables(ProcyonDecompiler.getSystemPropertyAsBoolean("enigma.mergeVariables", true));
        this.decompilerSettings.setForceExplicitImports(ProcyonDecompiler.getSystemPropertyAsBoolean("enigma.forceExplicitImports", true));
        this.decompilerSettings.setForceExplicitTypeArguments(ProcyonDecompiler.getSystemPropertyAsBoolean("enigma.forceExplicitTypeArguments", true));
        this.decompilerSettings.setShowDebugLineNumbers(ProcyonDecompiler.getSystemPropertyAsBoolean("enigma.showDebugLineNumbers", false));
        this.decompilerSettings.setShowSyntheticMembers(ProcyonDecompiler.getSystemPropertyAsBoolean("enigma.showSyntheticMembers", false));
        this.decompilerSettings.setTypeLoader(typeLoader);
        JavaFormattingOptions formattingOptions = this.decompilerSettings.getJavaFormattingOptions();
        formattingOptions.ClassBraceStyle = BraceStyle.EndOfLine;
        formattingOptions.InterfaceBraceStyle = BraceStyle.EndOfLine;
        formattingOptions.EnumBraceStyle = BraceStyle.EndOfLine;
        this.settings = settings;
    }

    @Override
    public Source getSource(String className) {
        TypeReference type = this.metadataSystem.lookupType(className);
        if (type == null) {
            throw new Error(String.format("Unable to find desc: %s", className));
        }
        TypeDefinition resolvedType = type.resolve();
        DecompilerContext context = new DecompilerContext();
        context.setCurrentType(resolvedType);
        context.setSettings(this.decompilerSettings);
        AstBuilder builder = new AstBuilder(context);
        builder.addType(resolvedType);
        builder.runTransformations(null);
        CompilationUnit source = builder.getCompilationUnit();
        new ObfuscatedEnumSwitchRewriterTransform(context).run(source);
        new VarargsFixer(context).run(source);
        new RemoveObjectCasts(context).run(source);
        new Java8Generics().run(source);
        new InvalidIdentifierFix().run(source);
        if (this.settings.removeImports) {
            DropImportAstTransform.INSTANCE.run(source);
        }
        if (this.settings.removeVariableFinal) {
            DropVarModifiersAstTransform.INSTANCE.run(source);
        }
        source.acceptVisitor(new InsertParenthesesVisitor(), null);
        return new ProcyonSource(source, this.decompilerSettings);
    }

    private static boolean getSystemPropertyAsBoolean(String property, boolean defValue) {
        String value = System.getProperty(property);
        return value == null ? defValue : Boolean.parseBoolean(value);
    }
}

