/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.utils.validation;

import cuchaz.enigma.utils.validation.Message;
import java.util.Arrays;
import java.util.Objects;

public class ParameterizedMessage {
    public final Message message;
    private final Object[] params;

    public ParameterizedMessage(Message message, Object[] params) {
        this.message = message;
        this.params = params;
    }

    public String getText() {
        return this.message.format(this.params);
    }

    public String getLongText() {
        return this.message.formatDetails(this.params);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterizedMessage that = (ParameterizedMessage)o;
        return Objects.equals(this.message, that.message) && Arrays.equals(this.params, that.params);
    }

    public int hashCode() {
        int result = Objects.hash(this.message);
        result = 31 * result + Arrays.hashCode(this.params);
        return result;
    }

    public String toString() {
        return String.format("ParameterizedMessage { message: %s, params: %s }", this.message, Arrays.toString(this.params));
    }
}

