/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters;

import java.util.Collections;
import java.util.List;
import org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.StructuredStatementTransformer;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.util.MiscStatementTools;
import org.benf.cfr.reader.bytecode.analysis.parse.Expression;
import org.benf.cfr.reader.bytecode.analysis.parse.LValue;
import org.benf.cfr.reader.bytecode.analysis.parse.StatementContainer;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.SwitchExpression;
import org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter;
import org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterFlags;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.CommentStatement;
import org.benf.cfr.reader.bytecode.analysis.parse.statement.Nop;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.Pair;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.SSAIdentifiers;
import org.benf.cfr.reader.bytecode.analysis.structured.StructuredScope;
import org.benf.cfr.reader.bytecode.analysis.structured.StructuredStatement;
import org.benf.cfr.reader.bytecode.analysis.structured.expression.StructuredStatementExpression;
import org.benf.cfr.reader.bytecode.analysis.structured.statement.Block;
import org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment;
import org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredBreak;
import org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredCase;
import org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredComment;
import org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredDefinition;
import org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionYield;
import org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn;
import org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredSwitch;
import org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredThrow;
import org.benf.cfr.reader.bytecode.analysis.types.TypeConstants;
import org.benf.cfr.reader.bytecode.analysis.types.discovery.InferredJavaType;
import org.benf.cfr.reader.util.ClassFileVersion;
import org.benf.cfr.reader.util.DecompilerComment;
import org.benf.cfr.reader.util.DecompilerComments;
import org.benf.cfr.reader.util.collections.Functional;
import org.benf.cfr.reader.util.collections.ListFactory;
import org.benf.cfr.reader.util.functors.Predicate;
import org.benf.cfr.reader.util.getopt.OptionsImpl;

public class SwitchExpressionRewriter
extends AbstractExpressionRewriter
implements StructuredStatementTransformer {
    private final boolean experimental;
    private DecompilerComments comments;
    private static final Predicate<Op04StructuredStatement> notEmpty = new Predicate<Op04StructuredStatement>(){

        @Override
        public boolean test(Op04StructuredStatement in) {
            return !(in.getStatement() instanceof Nop) && !(in.getStatement() instanceof CommentStatement);
        }
    };

    @Override
    public StructuredStatement transform(StructuredStatement in, StructuredScope scope) {
        in.transformStructuredChildren(this, scope);
        if (in instanceof StructuredSwitch) {
            Op04StructuredStatement container = in.getContainer();
            this.rewrite(container, scope);
            return container.getStatement();
        }
        return in;
    }

    public SwitchExpressionRewriter(DecompilerComments comments, ClassFileVersion classFileVersion) {
        this.comments = comments;
        this.experimental = OptionsImpl.switchExpressionVersion.isExperimentalIn(classFileVersion);
    }

    public void rewrite(Op04StructuredStatement root, StructuredScope scope) {
        List<StructuredStatement> structuredStatements = MiscStatementTools.linearise(root);
        if (structuredStatements == null) {
            return;
        }
        if (this.replaceSwitch(root, structuredStatements, scope) && this.experimental) {
            this.comments.addComment(DecompilerComment.EXPERIMENTAL_FEATURE);
        }
    }

    private boolean replaceSwitch(Op04StructuredStatement container, List<StructuredStatement> structuredStatements, StructuredScope scope) {
        int itm;
        StructuredStatement swat = structuredStatements.get(0);
        if (!(swat instanceof StructuredSwitch)) {
            return false;
        }
        StructuredSwitch swatch = (StructuredSwitch)swat;
        Op04StructuredStatement swBody = swatch.getBody();
        if (!(swBody.getStatement() instanceof Block)) {
            return false;
        }
        Block b = (Block)swBody.getStatement();
        List<Op04StructuredStatement> content = b.getBlockStatements();
        int size = content.size();
        List<Pair> extracted = ListFactory.newList();
        List<Pair<Op04StructuredStatement, StructuredStatement>> replacements = ListFactory.newList();
        LValue target = null;
        for (itm = 0; itm < size && target == null; ++itm) {
            target = this.extractSwitchLValue(content.get(itm), itm == size - 1);
        }
        if (target == null) {
            return false;
        }
        for (itm = 0; itm < size; ++itm) {
            Pair<StructuredCase, Expression> e = this.extractSwitchEntryPair(target, content.get(itm), replacements, itm == size - 1);
            if (e == null) {
                return false;
            }
            extracted.add(e);
        }
        StructuredStatement declarationContainer = scope.get(1);
        if (!(declarationContainer instanceof Block)) {
            return false;
        }
        List<Op04StructuredStatement> blockContent = ((Block)declarationContainer).getBlockStatements();
        Op04StructuredStatement definition = null;
        UsageCheck usageCheck = new UsageCheck(target);
        for (Op04StructuredStatement op04StructuredStatement : blockContent) {
            if (definition == null) {
                StructuredStatement stm = op04StructuredStatement.getStatement();
                if (!(stm instanceof StructuredDefinition) || !target.equals(((StructuredDefinition)stm).getLvalue())) continue;
                definition = op04StructuredStatement;
                continue;
            }
            if (op04StructuredStatement == container) break;
            op04StructuredStatement.getStatement().rewriteExpressions(usageCheck);
            if (!usageCheck.failed) continue;
            return false;
        }
        if (definition == null) {
            return false;
        }
        for (Pair pair : replacements) {
            ((Op04StructuredStatement)pair.getFirst()).replaceStatement((StructuredStatement)pair.getSecond());
        }
        List<SwitchExpression.Branch> items = ListFactory.newList();
        for (Pair e : extracted) {
            items.add(new SwitchExpression.Branch(((StructuredCase)e.getFirst()).getValues(), (Expression)e.getSecond()));
        }
        definition.nopOut();
        StructuredAssignment structuredAssignment = new StructuredAssignment(target, new SwitchExpression(target.getInferredJavaType(), swatch.getSwitchOn(), items));
        swat.getContainer().replaceStatement(structuredAssignment);
        structuredAssignment.markCreator(target, structuredAssignment.getContainer());
        return true;
    }

    private LValue extractSwitchLValue(Op04StructuredStatement item, boolean last) {
        StructuredStatement stm = item.getStatement();
        if (!(stm instanceof StructuredCase)) {
            return null;
        }
        StructuredCase sc = (StructuredCase)stm;
        Op04StructuredStatement body = sc.getBody();
        StructuredStatement bodyStm = body.getStatement();
        List<Op04StructuredStatement> content = bodyStm instanceof Block ? Functional.filterOptimistic(((Block)bodyStm).getBlockStatements(), notEmpty) : Collections.singletonList(body);
        if (content.size() > 2) {
            content = content.subList(content.size() - 2, content.size());
        }
        if (content.isEmpty()) {
            return null;
        }
        if (content.size() == 2 && content.get(1).getStatement() instanceof StructuredBreak) {
            StructuredStatement isAssign = content.get(0).getStatement();
            if (!(isAssign instanceof StructuredAssignment)) {
                return null;
            }
            return ((StructuredAssignment)isAssign).getLvalue();
        }
        if (!last) {
            return null;
        }
        StructuredStatement isAssign = content.get(content.size() - 1).getStatement();
        if (!(isAssign instanceof StructuredAssignment)) {
            return null;
        }
        return ((StructuredAssignment)isAssign).getLvalue();
    }

    private Pair<StructuredCase, Expression> extractSwitchEntryPair(LValue target, Op04StructuredStatement item, List<Pair<Op04StructuredStatement, StructuredStatement>> replacements, boolean last) {
        StructuredStatement stm = item.getStatement();
        if (!(stm instanceof StructuredCase)) {
            return null;
        }
        StructuredCase sc = (StructuredCase)stm;
        Expression res = this.extractSwitchEntry(target, sc.getBody(), replacements, last);
        if (res == null) {
            return null;
        }
        return Pair.make(sc, res);
    }

    private Expression extractSwitchEntry(LValue target, Op04StructuredStatement body, List<Pair<Op04StructuredStatement, StructuredStatement>> replacements, boolean last) {
        if (body.getStatement() instanceof Block) {
            Block block = (Block)body.getStatement();
            List<Op04StructuredStatement> blockStm = block.getBlockStatements();
            if ((blockStm = Functional.filterOptimistic(blockStm, notEmpty)).size() == 2) {
                return this.extractOneSwitchAssignment(target, blockStm);
            }
            if (blockStm.size() == 1) {
                return this.extractOneSwitchEntry(target, blockStm.get(0), last);
            }
            return this.extractSwitchStructure(target, body, replacements, last);
        }
        return this.extractOneSwitchEntry(target, body, last);
    }

    private Expression extractSwitchStructure(LValue target, Op04StructuredStatement body, List<Pair<Op04StructuredStatement, StructuredStatement>> replacements, boolean last) {
        SwitchExpressionTransformer transformer = new SwitchExpressionTransformer(target, replacements);
        body.transform(transformer, new StructuredScope());
        if (transformer.failed) {
            return null;
        }
        if (transformer.lastOk == LastOk.NotOk) {
            return null;
        }
        if (transformer.lastOk == LastOk.OkIfLast) {
            if (!last) {
                return null;
            }
            int lastReplacement = replacements.size() - 1;
            Op04StructuredStatement stm = replacements.get(lastReplacement).getFirst();
            replacements.set(lastReplacement, Pair.make(stm, new StructuredExpressionYield(transformer.pendingAssignment)));
        }
        return new StructuredStatementExpression(target.getInferredJavaType(), body.getStatement());
    }

    private Expression extractOneSwitchAssignment(LValue target, List<Op04StructuredStatement> blockStm) {
        if (blockStm.size() != 2) {
            return null;
        }
        if (!(blockStm.get(1).getStatement() instanceof StructuredBreak)) {
            return null;
        }
        return this.extractJustSwitchAssignment(target, blockStm.get(0));
    }

    private Expression extractOneSwitchEntry(LValue target, Op04StructuredStatement body, boolean last) {
        StructuredStatement content = body.getStatement();
        if (content instanceof StructuredThrow) {
            return new StructuredStatementExpression(new InferredJavaType(TypeConstants.THROWABLE, InferredJavaType.Source.TEST), content);
        }
        if (!last) {
            return null;
        }
        return this.extractJustSwitchAssignment(target, body);
    }

    private Expression extractJustSwitchAssignment(LValue target, Op04StructuredStatement body) {
        StructuredStatement assign = body.getStatement();
        if (!(assign instanceof StructuredAssignment)) {
            return null;
        }
        StructuredAssignment assignStm = (StructuredAssignment)assign;
        if (!assignStm.getLvalue().equals(target)) {
            return null;
        }
        return assignStm.getRvalue();
    }

    static class SwitchExpressionTransformer
    implements StructuredStatementTransformer {
        private BadSwitchExpressionTransformer badTransfomer = new BadSwitchExpressionTransformer();
        private UsageCheck rewriter;
        private List<Pair<Op04StructuredStatement, StructuredStatement>> replacements;
        private final LValue target;
        private LastOk lastOk = LastOk.NotOk;
        private boolean failed;
        private Expression pendingAssignment;

        private SwitchExpressionTransformer(LValue target, List<Pair<Op04StructuredStatement, StructuredStatement>> replacements) {
            this.target = target;
            this.rewriter = new UsageCheck(target);
            this.replacements = replacements;
        }

        @Override
        public StructuredStatement transform(StructuredStatement in, StructuredScope scope) {
            if (this.failed) {
                return in;
            }
            this.lastOk = LastOk.NotOk;
            if (this.pendingAssignment != null) {
                if (in instanceof StructuredBreak && ((StructuredBreak)in).isLocalBreak()) {
                    this.replacements.add(Pair.make(in.getContainer(), new StructuredExpressionYield(this.pendingAssignment)));
                    this.pendingAssignment = null;
                    this.lastOk = LastOk.Ok;
                    return in;
                }
                this.failed = true;
                return in;
            }
            if (in.supportsBreak()) {
                return this.badTransfomer.transform(in, scope);
            }
            if (in instanceof StructuredBreak) {
                this.failed = true;
                return in;
            }
            if (in instanceof StructuredReturn) {
                this.failed = true;
                return in;
            }
            if (in instanceof StructuredAssignment && ((StructuredAssignment)in).getLvalue().equals(this.target)) {
                if (this.pendingAssignment != null) {
                    this.failed = true;
                    return in;
                }
                this.pendingAssignment = ((StructuredAssignment)in).getRvalue();
                this.replacements.add(Pair.make(in.getContainer(), StructuredComment.EMPTY_COMMENT));
                this.lastOk = LastOk.OkIfLast;
                return in;
            }
            in.rewriteExpressions(this.rewriter);
            if (this.rewriter.failed) {
                this.failed = true;
                return in;
            }
            in.transformStructuredChildren(this, scope);
            return in;
        }

        class BadSwitchExpressionTransformer
        implements StructuredStatementTransformer {
            BadSwitchExpressionTransformer() {
            }

            @Override
            public StructuredStatement transform(StructuredStatement in, StructuredScope scope) {
                if (SwitchExpressionTransformer.this.failed) {
                    return in;
                }
                SwitchExpressionTransformer.this.lastOk = LastOk.NotOk;
                in.rewriteExpressions(SwitchExpressionTransformer.this.rewriter);
                if (SwitchExpressionTransformer.this.rewriter.failed) {
                    SwitchExpressionTransformer.this.failed = true;
                    return in;
                }
                if (in instanceof StructuredBreak) {
                    if (!((StructuredBreak)in).isLocalBreak()) {
                        SwitchExpressionTransformer.this.failed = true;
                    }
                    return in;
                }
                if (in instanceof StructuredReturn) {
                    SwitchExpressionTransformer.this.failed = true;
                    return in;
                }
                in.transformStructuredChildren(this, scope);
                return in;
            }
        }
    }

    static enum LastOk {
        Ok,
        OkIfLast,
        NotOk;

    }

    static class UsageCheck
    extends AbstractExpressionRewriter {
        private final LValue target;
        private boolean failed;

        UsageCheck(LValue target) {
            this.target = target;
        }

        @Override
        public LValue rewriteExpression(LValue lValue, SSAIdentifiers ssaIdentifiers, StatementContainer statementContainer, ExpressionRewriterFlags flags) {
            if (this.target.equals(lValue)) {
                this.failed = true;
            }
            return super.rewriteExpression(lValue, ssaIdentifiers, statementContainer, flags);
        }
    }
}

