/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.dialog;

import cuchaz.enigma.gui.dialog.AbstractDialog;
import cuchaz.enigma.gui.elements.ValidatablePasswordField;
import cuchaz.enigma.gui.elements.ValidatableTextField;
import cuchaz.enigma.gui.util.ScaleUtil;
import cuchaz.enigma.utils.Pair;
import cuchaz.enigma.utils.validation.Message;
import cuchaz.enigma.utils.validation.StandardValidation;
import cuchaz.enigma.utils.validation.Validatable;
import cuchaz.enigma.utils.validation.ValidationContext;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.Arrays;
import java.util.List;

public class CreateServerDialog
extends AbstractDialog {
    private ValidatableTextField portField;
    private ValidatablePasswordField passwordField;

    public CreateServerDialog(Frame owner) {
        super(owner, "prompt.create_server.title", "prompt.create_server.confirm", "prompt.cancel");
        Dimension preferredSize = this.getPreferredSize();
        preferredSize.width = ScaleUtil.scale(400);
        this.setPreferredSize(preferredSize);
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    @Override
    protected List<Pair<String, Component>> createComponents() {
        this.portField = new ValidatableTextField(Integer.toString(34712));
        this.passwordField = new ValidatablePasswordField();
        this.portField.addActionListener(event -> this.confirm());
        this.passwordField.addActionListener(event -> this.confirm());
        return Arrays.asList(new Pair((Object)"prompt.create_server.port", (Object)this.portField), new Pair((Object)"prompt.password", (Object)this.passwordField));
    }

    @Override
    public void validateInputs() {
        this.vc.setActiveElement((Validatable)this.portField);
        StandardValidation.isIntInRange((ValidationContext)this.vc, (String)this.portField.getText(), (int)0, (int)65535);
        this.vc.setActiveElement((Validatable)this.passwordField);
        if (this.passwordField.getPassword().length > 255) {
            this.vc.raise(Message.FIELD_LENGTH_OUT_OF_RANGE, new Object[]{255});
        }
    }

    public Result getResult() {
        if (!this.isActionConfirm()) {
            return null;
        }
        this.vc.reset();
        this.validateInputs();
        if (!this.vc.canProceed()) {
            return null;
        }
        return new Result(Integer.parseInt(this.portField.getText()), this.passwordField.getPassword());
    }

    public static Result show(Frame parent) {
        CreateServerDialog d = new CreateServerDialog(parent);
        d.setVisible(true);
        Result r = d.getResult();
        d.dispose();
        return r;
    }

    public static class Result {
        private final int port;
        private final char[] password;

        public Result(int port, char[] password) {
            this.port = port;
            this.password = password;
        }

        public int getPort() {
            return this.port;
        }

        public char[] getPassword() {
            return this.password;
        }
    }
}

