/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.dialog;

import com.google.common.base.Strings;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.gui.GuiController;
import cuchaz.enigma.gui.elements.ValidatableTextArea;
import cuchaz.enigma.gui.util.GuiUtil;
import cuchaz.enigma.gui.util.ScaleUtil;
import cuchaz.enigma.network.ServerPacketHandler;
import cuchaz.enigma.network.packet.ChangeDocsC2SPacket;
import cuchaz.enigma.network.packet.Packet;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.utils.I18n;
import cuchaz.enigma.utils.validation.Message;
import cuchaz.enigma.utils.validation.Validatable;
import cuchaz.enigma.utils.validation.ValidationContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.html.HTML;

public class JavadocDialog {
    private final JDialog ui;
    private final GuiController controller;
    private final EntryReference<Entry<?>, Entry<?>> entry;
    private final ValidatableTextArea text;
    private final ValidationContext vc = new ValidationContext();

    private JavadocDialog(JFrame parent, GuiController controller, EntryReference<Entry<?>, Entry<?>> entry, String preset) {
        this.ui = new JDialog((Frame)parent, I18n.translate((String)"javadocs.edit"));
        this.controller = controller;
        this.entry = entry;
        this.text = new ValidatableTextArea(10, 40);
        Container contentPane = this.ui.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.text.setText(preset);
        this.text.setTabSize(2);
        contentPane.add((Component)new JScrollPane(this.text), "Center");
        this.text.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                switch (event.getKeyCode()) {
                    case 10: {
                        if (!event.isControlDown()) break;
                        JavadocDialog.this.doSave();
                        if (!JavadocDialog.this.vc.canProceed()) break;
                        JavadocDialog.this.close();
                        break;
                    }
                    case 27: {
                        JavadocDialog.this.close();
                        break;
                    }
                }
            }
        });
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout(2));
        buttonsPanel.add(GuiUtil.unboldLabel(new JLabel(I18n.translate((String)"javadocs.instruction"))));
        JButton cancelButton = new JButton(I18n.translate((String)"javadocs.cancel"));
        cancelButton.addActionListener(event -> this.close());
        buttonsPanel.add(cancelButton);
        JButton saveButton = new JButton(I18n.translate((String)"javadocs.save"));
        saveButton.addActionListener(event -> this.doSave());
        buttonsPanel.add(saveButton);
        contentPane.add((Component)buttonsPanel, "South");
        JMenuBar tagsMenu = new JMenuBar();
        for (JavadocTag tag : JavadocTag.values()) {
            JButton tagButton = new JButton(tag.getText());
            tagButton.addActionListener(action -> {
                String tagText;
                boolean textSelected = this.text.getSelectedText() != null;
                String string = tagText = tag.isInline() ? "{" + tag.getText() + " }" : tag.getText() + " ";
                if (textSelected) {
                    tagText = tag.isInline() ? "{" + tag.getText() + " " + this.text.getSelectedText() + "}" : tag.getText() + " " + this.text.getSelectedText();
                    this.text.replaceSelection(tagText);
                } else {
                    this.text.insert(tagText, this.text.getCaretPosition());
                }
                if (tag.isInline()) {
                    this.text.setCaretPosition(this.text.getCaretPosition() - 1);
                }
                this.text.grabFocus();
            });
            tagsMenu.add(tagButton);
        }
        JComboBox<String> htmlList = new JComboBox<String>();
        htmlList.setPreferredSize(new Dimension());
        for (HTML.Tag htmlTag : HTML.getAllTags()) {
            htmlList.addItem(htmlTag.toString());
        }
        htmlList.addActionListener(action -> {
            String tagText = "<" + htmlList.getSelectedItem().toString() + ">";
            this.text.insert(tagText, this.text.getCaretPosition());
            this.text.grabFocus();
        });
        tagsMenu.add(htmlList);
        contentPane.add((Component)tagsMenu, "North");
        this.ui.setSize(ScaleUtil.getDimension(600, 400));
        this.ui.setLocationRelativeTo(parent);
        this.ui.setDefaultCloseOperation(2);
    }

    public void doSave() {
        this.vc.reset();
        this.validate();
        if (!this.vc.canProceed()) {
            return;
        }
        this.save();
        if (!this.vc.canProceed()) {
            return;
        }
        this.close();
    }

    public void close() {
        this.ui.setVisible(false);
        this.ui.dispose();
    }

    public void validate() {
        this.vc.setActiveElement((Validatable)this.text);
        if (this.text.getText().contains("*/")) {
            this.vc.raise(Message.ILLEGAL_DOC_COMMENT_END, new Object[0]);
        }
        this.controller.changeDocs(this.vc, this.entry, this.text.getText(), true);
    }

    public void save() {
        this.vc.setActiveElement((Validatable)this.text);
        this.controller.changeDocs(this.vc, this.entry, this.text.getText());
        if (!this.vc.canProceed()) {
            return;
        }
        this.controller.sendPacket((Packet<ServerPacketHandler>)new ChangeDocsC2SPacket(this.entry.getNameableEntry(), this.text.getText()));
    }

    public static void show(JFrame parent, GuiController controller, EntryReference<Entry<?>, Entry<?>> entry) {
        EntryReference translatedReference = (EntryReference)controller.project.getMapper().deobfuscate(entry);
        String text = Strings.nullToEmpty((String)translatedReference.entry.getJavadocs());
        JavadocDialog dialog = new JavadocDialog(parent, controller, entry, text);
        dialog.ui.doLayout();
        dialog.ui.setVisible(true);
        dialog.text.grabFocus();
    }

    private static enum JavadocTag {
        CODE(true),
        LINK(true),
        LINKPLAIN(true),
        RETURN(false),
        SEE(false),
        THROWS(false);

        private boolean inline;

        private JavadocTag(boolean inline) {
            this.inline = inline;
        }

        public String getText() {
            return "@" + this.name().toLowerCase();
        }

        public boolean isInline() {
            return this.inline;
        }
    }
}

