/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.elements;

import cuchaz.enigma.gui.Gui;
import cuchaz.enigma.gui.panels.EditorPanel;
import cuchaz.enigma.utils.I18n;
import java.awt.Component;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public class EditorTabPopupMenu {
    private final JPopupMenu ui;
    private final JMenuItem close;
    private final JMenuItem closeAll;
    private final JMenuItem closeOthers;
    private final JMenuItem closeLeft;
    private final JMenuItem closeRight;
    private final Gui gui;
    private EditorPanel editor;

    public EditorTabPopupMenu(Gui gui) {
        this.gui = gui;
        this.ui = new JPopupMenu();
        this.close = new JMenuItem(I18n.translate((String)"popup_menu.editor_tab.close"));
        this.close.setAccelerator(KeyStroke.getKeyStroke(52, 128));
        this.close.addActionListener(a -> gui.closeEditor(this.editor));
        this.ui.add(this.close);
        this.closeAll = new JMenuItem(I18n.translate((String)"popup_menu.editor_tab.close_all"));
        this.closeAll.addActionListener(a -> gui.closeAllEditorTabs());
        this.ui.add(this.closeAll);
        this.closeOthers = new JMenuItem(I18n.translate((String)"popup_menu.editor_tab.close_others"));
        this.closeOthers.addActionListener(a -> gui.closeTabsExcept(this.editor));
        this.ui.add(this.closeOthers);
        this.closeLeft = new JMenuItem(I18n.translate((String)"popup_menu.editor_tab.close_left"));
        this.closeLeft.addActionListener(a -> gui.closeTabsLeftOf(this.editor));
        this.ui.add(this.closeLeft);
        this.closeRight = new JMenuItem(I18n.translate((String)"popup_menu.editor_tab.close_right"));
        this.closeRight.addActionListener(a -> gui.closeTabsRightOf(this.editor));
        this.ui.add(this.closeRight);
    }

    public void show(Component invoker, int x, int y, EditorPanel editorPanel) {
        this.editor = editorPanel;
        this.ui.show(invoker, x, y);
    }
}

