/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.elements;

import cuchaz.enigma.gui.Gui;
import cuchaz.enigma.gui.panels.EditorPanel;
import cuchaz.enigma.utils.I18n;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

public class PopupMenuBar
extends JPopupMenu {
    public final JMenuItem renameMenu;
    public final JMenuItem editJavadocMenu;
    public final JMenuItem showInheritanceMenu;
    public final JMenuItem showImplementationsMenu;
    public final JMenuItem showCallsMenu;
    public final JMenuItem showCallsSpecificMenu;
    public final JMenuItem openEntryMenu;
    public final JMenuItem openPreviousMenu;
    public final JMenuItem openNextMenu;
    public final JMenuItem toggleMappingMenu;

    public PopupMenuBar(EditorPanel editor, Gui gui) {
        JMenuItem menu = new JMenuItem(I18n.translate((String)"popup_menu.rename"));
        menu.addActionListener(event -> gui.startRename(editor));
        menu.setAccelerator(KeyStroke.getKeyStroke(82, 128));
        menu.setEnabled(false);
        this.add(menu);
        this.renameMenu = menu;
        menu = new JMenuItem(I18n.translate((String)"popup_menu.javadoc"));
        menu.addActionListener(event -> gui.startDocChange(editor));
        menu.setAccelerator(KeyStroke.getKeyStroke(68, 128));
        menu.setEnabled(false);
        this.add(menu);
        this.editJavadocMenu = menu;
        menu = new JMenuItem(I18n.translate((String)"popup_menu.inheritance"));
        menu.addActionListener(event -> gui.showInheritance(editor));
        menu.setAccelerator(KeyStroke.getKeyStroke(73, 128));
        menu.setEnabled(false);
        this.add(menu);
        this.showInheritanceMenu = menu;
        menu = new JMenuItem(I18n.translate((String)"popup_menu.implementations"));
        menu.addActionListener(event -> gui.showImplementations(editor));
        menu.setAccelerator(KeyStroke.getKeyStroke(77, 128));
        menu.setEnabled(false);
        this.add(menu);
        this.showImplementationsMenu = menu;
        menu = new JMenuItem(I18n.translate((String)"popup_menu.calls"));
        menu.addActionListener(event -> gui.showCalls(editor, true));
        menu.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        menu.setEnabled(false);
        this.add(menu);
        this.showCallsMenu = menu;
        menu = new JMenuItem(I18n.translate((String)"popup_menu.calls.specific"));
        menu.addActionListener(event -> gui.showCalls(editor, false));
        menu.setAccelerator(KeyStroke.getKeyStroke(67, 192));
        menu.setEnabled(false);
        this.add(menu);
        this.showCallsSpecificMenu = menu;
        menu = new JMenuItem(I18n.translate((String)"popup_menu.declaration"));
        menu.addActionListener(event -> gui.getController().navigateTo(editor.getCursorReference().entry));
        menu.setAccelerator(KeyStroke.getKeyStroke(78, 128));
        menu.setEnabled(false);
        this.add(menu);
        this.openEntryMenu = menu;
        menu = new JMenuItem(I18n.translate((String)"popup_menu.back"));
        menu.addActionListener(event -> gui.getController().openPreviousReference());
        menu.setAccelerator(KeyStroke.getKeyStroke(80, 128));
        menu.setEnabled(false);
        this.add(menu);
        this.openPreviousMenu = menu;
        menu = new JMenuItem(I18n.translate((String)"popup_menu.forward"));
        menu.addActionListener(event -> gui.getController().openNextReference());
        menu.setAccelerator(KeyStroke.getKeyStroke(69, 128));
        menu.setEnabled(false);
        this.add(menu);
        this.openNextMenu = menu;
        menu = new JMenuItem(I18n.translate((String)"popup_menu.mark_deobfuscated"));
        menu.addActionListener(event -> gui.toggleMapping(editor));
        menu.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        menu.setEnabled(false);
        this.add(menu);
        this.toggleMappingMenu = menu;
        this.add(new JSeparator());
        menu = new JMenuItem(I18n.translate((String)"popup_menu.zoom.in"));
        menu.addActionListener(event -> editor.offsetEditorZoom(2));
        menu.setAccelerator(KeyStroke.getKeyStroke(521, 128));
        this.add(menu);
        menu = new JMenuItem(I18n.translate((String)"popup_menu.zoom.out"));
        menu.addActionListener(event -> editor.offsetEditorZoom(-2));
        menu.setAccelerator(KeyStroke.getKeyStroke(45, 128));
        this.add(menu);
        menu = new JMenuItem(I18n.translate((String)"popup_menu.zoom.reset"));
        menu.addActionListener(event -> editor.resetEditorZoom());
        this.add(menu);
    }
}

