/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui;

import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.LocalVariableEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import javax.annotation.Nullable;

public enum EditableType {
    CLASS,
    METHOD,
    FIELD,
    PARAMETER,
    LOCAL_VARIABLE,
    JAVADOC;


    @Nullable
    public static EditableType fromEntry(Entry<?> entry) {
        EditableType type = null;
        if (entry instanceof ClassEntry) {
            type = CLASS;
        } else if (entry instanceof MethodEntry) {
            MethodEntry me = (MethodEntry)entry;
            type = me.isConstructor() ? CLASS : METHOD;
        } else if (entry instanceof FieldEntry) {
            type = FIELD;
        } else if (entry instanceof LocalVariableEntry) {
            LocalVariableEntry lve = (LocalVariableEntry)entry;
            type = lve.isArgument() ? PARAMETER : LOCAL_VARIABLE;
        }
        return type;
    }
}

