/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui;

import cuchaz.enigma.EnigmaProfile;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.gui.ClassSelector;
import cuchaz.enigma.gui.ConnectionState;
import cuchaz.enigma.gui.EditableType;
import cuchaz.enigma.gui.GuiController;
import cuchaz.enigma.gui.config.Themes;
import cuchaz.enigma.gui.config.UiConfig;
import cuchaz.enigma.gui.dialog.JavadocDialog;
import cuchaz.enigma.gui.dialog.SearchDialog;
import cuchaz.enigma.gui.elements.CallsTree;
import cuchaz.enigma.gui.elements.CollapsibleTabbedPane;
import cuchaz.enigma.gui.elements.EditorTabbedPane;
import cuchaz.enigma.gui.elements.ImplementationsTree;
import cuchaz.enigma.gui.elements.InheritanceTree;
import cuchaz.enigma.gui.elements.MainWindow;
import cuchaz.enigma.gui.elements.MenuBar;
import cuchaz.enigma.gui.elements.ValidatableUi;
import cuchaz.enigma.gui.panels.DeobfPanel;
import cuchaz.enigma.gui.panels.EditorPanel;
import cuchaz.enigma.gui.panels.IdentifierPanel;
import cuchaz.enigma.gui.panels.ObfPanel;
import cuchaz.enigma.gui.panels.StructurePanel;
import cuchaz.enigma.gui.renderer.MessageListCellRenderer;
import cuchaz.enigma.gui.util.GuiUtil;
import cuchaz.enigma.gui.util.LanguageUtil;
import cuchaz.enigma.gui.util.ScaleUtil;
import cuchaz.enigma.network.Message;
import cuchaz.enigma.network.ServerPacketHandler;
import cuchaz.enigma.network.packet.MessageC2SPacket;
import cuchaz.enigma.network.packet.Packet;
import cuchaz.enigma.source.Token;
import cuchaz.enigma.translation.Translatable;
import cuchaz.enigma.translation.mapping.EntryChange;
import cuchaz.enigma.translation.mapping.EntryRemapper;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.utils.I18n;
import cuchaz.enigma.utils.validation.ValidationContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;

public class Gui {
    private final MainWindow mainWindow = new MainWindow("Enigma");
    private final GuiController controller;
    private ConnectionState connectionState;
    private boolean isJarOpen;
    private final Set<EditableType> editableTypes;
    private boolean singleClassTree;
    private final MenuBar menuBar;
    private final ObfPanel obfPanel;
    private final DeobfPanel deobfPanel;
    private final IdentifierPanel infoPanel;
    private final StructurePanel structurePanel;
    private final InheritanceTree inheritanceTree;
    private final ImplementationsTree implementationsTree;
    private final CallsTree callsTree;
    private final EditorTabbedPane editorTabbedPane;
    private final JPanel classesPanel = new JPanel(new BorderLayout());
    private final JSplitPane splitClasses;
    private final JTabbedPane tabs = new JTabbedPane();
    private final CollapsibleTabbedPane logTabs = new CollapsibleTabbedPane(3);
    private final JSplitPane logSplit = new JSplitPane(0, true, this.tabs, this.logTabs);
    private final JPanel centerPanel = new JPanel(new BorderLayout());
    private final JSplitPane splitRight = new JSplitPane(1, true, this.centerPanel, this.logSplit);
    private final JSplitPane splitCenter = new JSplitPane(1, true, this.classesPanel, this.splitRight);
    private final DefaultListModel<String> userModel = new DefaultListModel();
    private final DefaultListModel<Message> messageModel = new DefaultListModel();
    private final JList<String> users = new JList<String>(this.userModel);
    private final JList<Message> messages = new JList<Message>(this.messageModel);
    private final JPanel messagePanel = new JPanel(new BorderLayout());
    private final JScrollPane messageScrollPane = new JScrollPane(this.messages);
    private final JTextField chatBox = new JTextField();
    private final JLabel connectionStatusLabel = new JLabel();
    public final JFileChooser jarFileChooser = new JFileChooser();
    public final JFileChooser tinyMappingsFileChooser = new JFileChooser();
    public final JFileChooser enigmaMappingsFileChooser = new JFileChooser();
    public final JFileChooser exportSourceFileChooser = new JFileChooser();
    public final JFileChooser exportJarFileChooser = new JFileChooser();
    public SearchDialog searchDialog;

    public Gui(EnigmaProfile profile, Set<EditableType> editableTypes) {
        this.editableTypes = editableTypes;
        this.controller = new GuiController(this, profile);
        this.structurePanel = new StructurePanel(this);
        this.deobfPanel = new DeobfPanel(this);
        this.infoPanel = new IdentifierPanel(this);
        this.obfPanel = new ObfPanel(this);
        this.menuBar = new MenuBar(this);
        this.inheritanceTree = new InheritanceTree(this);
        this.implementationsTree = new ImplementationsTree(this);
        this.callsTree = new CallsTree(this);
        this.editorTabbedPane = new EditorTabbedPane(this);
        this.splitClasses = new JSplitPane(0, true, this.obfPanel, this.deobfPanel);
        this.setupUi();
        LanguageUtil.addListener(this::retranslateUi);
        Themes.addListener((lookAndFeel, boxHighlightPainters) -> SwingUtilities.updateComponentTreeUI(this.getFrame()));
        this.mainWindow.setVisible(true);
    }

    private void setupUi() {
        this.jarFileChooser.setFileSelectionMode(0);
        this.tinyMappingsFileChooser.setFileSelectionMode(0);
        this.enigmaMappingsFileChooser.setFileSelectionMode(2);
        this.enigmaMappingsFileChooser.setAcceptAllFileFilterUsed(false);
        this.exportSourceFileChooser.setFileSelectionMode(1);
        this.exportSourceFileChooser.setAcceptAllFileFilterUsed(false);
        this.exportJarFileChooser.setFileSelectionMode(0);
        this.splitClasses.setResizeWeight(0.3);
        this.classesPanel.setPreferredSize(ScaleUtil.getDimension(250, 0));
        Container workArea = this.mainWindow.workArea();
        workArea.setLayout(new BorderLayout());
        this.centerPanel.add((Component)this.infoPanel.getUi(), "North");
        this.centerPanel.add(this.editorTabbedPane.getUi(), "Center");
        this.tabs.setPreferredSize(ScaleUtil.getDimension(250, 0));
        this.tabs.addTab(I18n.translate((String)"info_panel.tree.structure"), this.structurePanel.getPanel());
        this.tabs.addTab(I18n.translate((String)"info_panel.tree.inheritance"), this.inheritanceTree.getPanel());
        this.tabs.addTab(I18n.translate((String)"info_panel.tree.implementations"), this.implementationsTree.getPanel());
        this.tabs.addTab(I18n.translate((String)"info_panel.tree.calls"), this.callsTree.getPanel());
        this.messages.setCellRenderer(new MessageListCellRenderer());
        JPanel chatPanel = new JPanel(new BorderLayout());
        AbstractAction sendListener = new AbstractAction("Send"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.sendMessage();
            }
        };
        this.chatBox.addActionListener(sendListener);
        JButton chatSendButton = new JButton(sendListener);
        chatPanel.add((Component)this.chatBox, "Center");
        chatPanel.add((Component)chatSendButton, "East");
        this.messagePanel.add((Component)this.messageScrollPane, "Center");
        this.messagePanel.add((Component)chatPanel, "South");
        this.logTabs.addTab(I18n.translate((String)"log_panel.users"), new JScrollPane(this.users));
        this.logTabs.addTab(I18n.translate((String)"log_panel.messages"), this.messagePanel);
        this.logSplit.setResizeWeight(0.5);
        this.logSplit.resetToPreferredSizes();
        this.splitRight.setResizeWeight(1.0);
        this.splitRight.resetToPreferredSizes();
        this.splitCenter.setResizeWeight(0.0);
        workArea.add((Component)this.splitCenter, "Center");
        int[] layout = UiConfig.getLayout();
        if (layout.length >= 4) {
            this.splitClasses.setDividerLocation(layout[0]);
            this.splitCenter.setDividerLocation(layout[1]);
            this.splitRight.setDividerLocation(layout[2]);
            this.logSplit.setDividerLocation(layout[3]);
        }
        this.mainWindow.statusBar().addPermanentComponent(this.connectionStatusLabel);
        this.setConnectionState(ConnectionState.NOT_CONNECTED);
        this.onCloseJar();
        JFrame frame = this.mainWindow.frame();
        frame.addWindowListener(GuiUtil.onWindowClose(e -> this.close()));
        frame.setSize(UiConfig.getWindowSize("Main Window", ScaleUtil.getDimension(1024, 576)));
        frame.setMinimumSize(ScaleUtil.getDimension(640, 480));
        frame.setDefaultCloseOperation(0);
        Point windowPos = UiConfig.getWindowPos("Main Window", null);
        if (windowPos != null) {
            frame.setLocation(windowPos);
        } else {
            frame.setLocationRelativeTo(null);
        }
        this.retranslateUi();
    }

    public MainWindow getMainWindow() {
        return this.mainWindow;
    }

    public JFrame getFrame() {
        return this.mainWindow.frame();
    }

    public GuiController getController() {
        return this.controller;
    }

    public void setSingleClassTree(boolean singleClassTree) {
        this.singleClassTree = singleClassTree;
        this.classesPanel.removeAll();
        this.classesPanel.add(this.isSingleClassTree() ? this.deobfPanel : this.splitClasses);
        this.getController().refreshClasses();
        this.retranslateUi();
    }

    public boolean isSingleClassTree() {
        return this.singleClassTree;
    }

    public void onStartOpenJar() {
        this.classesPanel.removeAll();
        this.redraw();
    }

    public void onFinishOpenJar(String jarName) {
        this.mainWindow.setTitle("Enigma - " + jarName);
        this.classesPanel.removeAll();
        this.classesPanel.add(this.isSingleClassTree() ? this.deobfPanel : this.splitClasses);
        this.editorTabbedPane.closeAllEditorTabs();
        this.isJarOpen = true;
        this.updateUiState();
        this.redraw();
    }

    public void onCloseJar() {
        this.mainWindow.setTitle("Enigma");
        this.setObfClasses(null);
        this.setDeobfClasses(null);
        this.editorTabbedPane.closeAllEditorTabs();
        this.classesPanel.removeAll();
        this.isJarOpen = false;
        this.setMappingsFile(null);
        this.updateUiState();
        this.redraw();
    }

    public EditorPanel openClass(ClassEntry entry) {
        return this.editorTabbedPane.openClass(entry);
    }

    @Nullable
    public EditorPanel getActiveEditor() {
        return this.editorTabbedPane.getActiveEditor();
    }

    public void closeEditor(EditorPanel editor) {
        this.editorTabbedPane.closeEditor(editor);
    }

    public void showReference(EntryReference<Entry<?>, Entry<?>> reference) {
        this.editorTabbedPane.openClass(reference.getLocationClassEntry().getOutermostClass()).showReference(reference);
    }

    public void setObfClasses(Collection<ClassEntry> obfClasses) {
        this.obfPanel.obfClasses.setClasses(obfClasses);
    }

    public void setDeobfClasses(Collection<ClassEntry> deobfClasses) {
        this.deobfPanel.deobfClasses.setClasses(deobfClasses);
    }

    public void setMappingsFile(Path path) {
        this.enigmaMappingsFileChooser.setSelectedFile(path != null ? path.toFile() : null);
        this.updateUiState();
    }

    public void showTokens(EditorPanel editor, List<Token> tokens) {
        if (tokens.size() > 1) {
            this.controller.setTokenHandle(editor.getClassHandle().copy());
            this.callsTree.showTokens(tokens);
        } else {
            this.callsTree.clearTokens();
        }
        editor.navigateToToken(tokens.get(0));
    }

    public void showCursorReference(EntryReference<Entry<?>, Entry<?>> reference) {
        this.infoPanel.setReference(reference == null ? null : reference.entry);
    }

    @Nullable
    public EntryReference<Entry<?>, Entry<?>> getCursorReference() {
        EditorPanel activeEditor = this.editorTabbedPane.getActiveEditor();
        return activeEditor == null ? null : activeEditor.getCursorReference();
    }

    public void startDocChange(EditorPanel editor) {
        EntryReference<Entry<?>, Entry<?>> cursorReference = editor.getCursorReference();
        if (cursorReference == null || !this.isEditable(EditableType.JAVADOC)) {
            return;
        }
        JavadocDialog.show(this.mainWindow.frame(), this.getController(), cursorReference);
    }

    public void startRename(EditorPanel editor, String text) {
        if (editor != this.editorTabbedPane.getActiveEditor()) {
            return;
        }
        this.infoPanel.startRenaming(text);
    }

    public void startRename(EditorPanel editor) {
        if (editor != this.editorTabbedPane.getActiveEditor()) {
            return;
        }
        this.infoPanel.startRenaming();
    }

    public void showStructure(EditorPanel editor) {
        this.structurePanel.showStructure(editor);
    }

    public void showInheritance(EditorPanel editor) {
        EntryReference<Entry<?>, Entry<?>> cursorReference = editor.getCursorReference();
        if (cursorReference == null) {
            return;
        }
        this.inheritanceTree.display(cursorReference.entry);
        this.tabs.setSelectedIndex(1);
    }

    public void showImplementations(EditorPanel editor) {
        EntryReference<Entry<?>, Entry<?>> cursorReference = editor.getCursorReference();
        if (cursorReference == null) {
            return;
        }
        this.implementationsTree.display(cursorReference.entry);
        this.tabs.setSelectedIndex(2);
    }

    public void showCalls(EditorPanel editor, boolean recurse) {
        EntryReference<Entry<?>, Entry<?>> cursorReference = editor.getCursorReference();
        if (cursorReference == null) {
            return;
        }
        this.callsTree.showCalls(cursorReference.entry, recurse);
        this.tabs.setSelectedIndex(3);
    }

    public void toggleMapping(EditorPanel editor) {
        EntryReference<Entry<?>, Entry<?>> cursorReference = editor.getCursorReference();
        if (cursorReference == null) {
            return;
        }
        Entry obfEntry = cursorReference.entry;
        this.toggleMappingFromEntry(obfEntry);
    }

    public void toggleMappingFromEntry(Entry<?> obfEntry) {
        if (this.controller.project.getMapper().getDeobfMapping(obfEntry).targetName() != null) {
            this.validateImmediateAction(vc -> this.controller.applyChange((ValidationContext)vc, (EntryChange<?>)EntryChange.modify((Entry)obfEntry).clearDeobfName()));
        } else {
            this.validateImmediateAction(vc -> this.controller.applyChange((ValidationContext)vc, (EntryChange<?>)EntryChange.modify((Entry)obfEntry).withDefaultDeobfName(this.getController().project)));
        }
    }

    public void showDiscardDiag(Function<Integer, Void> callback, String ... options) {
        int response = JOptionPane.showOptionDialog(this.mainWindow.frame(), I18n.translate((String)"prompt.close.summary"), I18n.translate((String)"prompt.close.title"), 1, 3, null, options, options[2]);
        callback.apply(response);
    }

    public CompletableFuture<Void> saveMapping() {
        if (this.enigmaMappingsFileChooser.getSelectedFile() != null || this.enigmaMappingsFileChooser.showSaveDialog(this.mainWindow.frame()) == 0) {
            return this.controller.saveMappings(this.enigmaMappingsFileChooser.getSelectedFile().toPath());
        }
        return CompletableFuture.completedFuture(null);
    }

    public void close() {
        if (!this.controller.isDirty()) {
            this.exit();
        } else {
            this.showDiscardDiag(response -> {
                if (response == 0) {
                    this.saveMapping().thenRun(this::exit);
                } else if (response == 1) {
                    this.exit();
                }
                return null;
            }, I18n.translate((String)"prompt.save"), I18n.translate((String)"prompt.close.discard"), I18n.translate((String)"prompt.cancel"));
        }
    }

    private void exit() {
        UiConfig.setWindowPos("Main Window", this.mainWindow.frame().getLocationOnScreen());
        UiConfig.setWindowSize("Main Window", this.mainWindow.frame().getSize());
        UiConfig.setLayout(this.splitClasses.getDividerLocation(), this.splitCenter.getDividerLocation(), this.splitRight.getDividerLocation(), this.logSplit.getDividerLocation());
        UiConfig.save();
        if (this.searchDialog != null) {
            this.searchDialog.dispose();
        }
        this.mainWindow.frame().dispose();
        System.exit(0);
    }

    public void redraw() {
        JFrame frame = this.mainWindow.frame();
        frame.validate();
        frame.repaint();
    }

    public void onRenameFromClassTree(ValidationContext vc, Object prevData, Object data, DefaultMutableTreeNode node) {
        if (data instanceof String) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
                ClassEntry prevDataChild = (ClassEntry)childNode.getUserObject();
                ClassEntry dataChild = new ClassEntry(String.valueOf(data) + "/" + prevDataChild.getSimpleName());
                this.onRenameFromClassTree(vc, prevDataChild, dataChild, node);
            }
            node.setUserObject(data);
            this.deobfPanel.deobfClasses.reload();
        } else if (data instanceof ClassEntry) {
            EntryRemapper mapper = this.controller.project.getMapper();
            ClassEntry deobf = (ClassEntry)prevData;
            ClassEntry obf = mapper.getObfToDeobf().getAllEntries().filter(e -> e instanceof ClassEntry).map(e -> (ClassEntry)e).filter(e -> ((ClassEntry)mapper.deobfuscate((Translatable)e)).equals(deobf)).findAny().orElse(deobf);
            this.controller.applyChange(vc, EntryChange.modify((Entry)obf).withDeobfName(((ClassEntry)data).getFullName()));
        } else {
            throw new IllegalStateException(String.format("unhandled rename object data: '%s'", data));
        }
    }

    public void moveClassTree(Entry<?> obfEntry, String newName) {
        String oldEntry = obfEntry.getContainingClass().getPackageName();
        String newEntry = new ClassEntry(newName).getPackageName();
        this.moveClassTree(obfEntry, oldEntry == null, newEntry == null);
    }

    public void moveClassTree(Entry<?> obfEntry, boolean isOldOb, boolean isNewOb) {
        ClassEntry classEntry = obfEntry.getContainingClass();
        List<ClassSelector.StateEntry> stateDeobf = this.deobfPanel.deobfClasses.getExpansionState();
        List<ClassSelector.StateEntry> stateObf = this.obfPanel.obfClasses.getExpansionState();
        if (!isNewOb) {
            this.deobfPanel.deobfClasses.moveClassIn(classEntry);
            this.obfPanel.obfClasses.removeEntry(classEntry);
            this.deobfPanel.deobfClasses.reload();
            this.obfPanel.obfClasses.reload();
        } else if (!isOldOb) {
            this.obfPanel.obfClasses.moveClassIn(classEntry);
            this.deobfPanel.deobfClasses.removeEntry(classEntry);
            this.deobfPanel.deobfClasses.reload();
            this.obfPanel.obfClasses.reload();
        } else if (isOldOb) {
            this.obfPanel.obfClasses.moveClassIn(classEntry);
            this.obfPanel.obfClasses.reload();
        } else {
            this.deobfPanel.deobfClasses.moveClassIn(classEntry);
            this.deobfPanel.deobfClasses.reload();
        }
        this.deobfPanel.deobfClasses.restoreExpansionState(stateDeobf);
        this.obfPanel.obfClasses.restoreExpansionState(stateObf);
    }

    public ObfPanel getObfPanel() {
        return this.obfPanel;
    }

    public DeobfPanel getDeobfPanel() {
        return this.deobfPanel;
    }

    public SearchDialog getSearchDialog() {
        if (this.searchDialog == null) {
            this.searchDialog = new SearchDialog(this);
        }
        return this.searchDialog;
    }

    public void addMessage(Message message) {
        JScrollBar verticalScrollBar = this.messageScrollPane.getVerticalScrollBar();
        boolean isAtBottom = verticalScrollBar.getValue() >= verticalScrollBar.getMaximum() - verticalScrollBar.getModel().getExtent();
        this.messageModel.addElement(message);
        if (isAtBottom) {
            SwingUtilities.invokeLater(() -> verticalScrollBar.setValue(verticalScrollBar.getMaximum() - verticalScrollBar.getModel().getExtent()));
        }
        this.mainWindow.statusBar().showMessage(message.translate(), 5000);
    }

    public void setUserList(List<String> users) {
        this.userModel.clear();
        users.forEach(this.userModel::addElement);
        this.connectionStatusLabel.setText(String.format(I18n.translate((String)"status.connected_user_count"), users.size()));
    }

    private void sendMessage() {
        String text = this.chatBox.getText().trim();
        if (!text.isEmpty()) {
            this.getController().sendPacket((Packet<ServerPacketHandler>)new MessageC2SPacket(text));
        }
        this.chatBox.setText("");
    }

    public void updateUiState() {
        this.menuBar.updateUiState();
        this.connectionStatusLabel.setText(I18n.translate((String)(this.connectionState == ConnectionState.NOT_CONNECTED ? "status.disconnected" : "status.connected")));
        if (this.connectionState == ConnectionState.NOT_CONNECTED) {
            this.logSplit.setLeftComponent(null);
            this.splitRight.setRightComponent(this.tabs);
        } else {
            this.splitRight.setRightComponent(this.logSplit);
            this.logSplit.setLeftComponent(this.tabs);
        }
        this.splitRight.setDividerLocation(this.splitRight.getDividerLocation());
    }

    public void retranslateUi() {
        this.jarFileChooser.setDialogTitle(I18n.translate((String)"menu.file.jar.open"));
        this.exportJarFileChooser.setDialogTitle(I18n.translate((String)"menu.file.export.jar"));
        this.tabs.setTitleAt(0, I18n.translate((String)"info_panel.tree.structure"));
        this.tabs.setTitleAt(1, I18n.translate((String)"info_panel.tree.inheritance"));
        this.tabs.setTitleAt(2, I18n.translate((String)"info_panel.tree.implementations"));
        this.tabs.setTitleAt(3, I18n.translate((String)"info_panel.tree.calls"));
        this.logTabs.setTitleAt(0, I18n.translate((String)"log_panel.users"));
        this.logTabs.setTitleAt(1, I18n.translate((String)"log_panel.messages"));
        this.connectionStatusLabel.setText(I18n.translate((String)(this.connectionState == ConnectionState.NOT_CONNECTED ? "status.disconnected" : "status.connected")));
        this.updateUiState();
        this.menuBar.retranslateUi();
        this.obfPanel.retranslateUi();
        this.deobfPanel.retranslateUi();
        this.infoPanel.retranslateUi();
        this.structurePanel.retranslateUi();
        this.editorTabbedPane.retranslateUi();
        this.inheritanceTree.retranslateUi();
        this.implementationsTree.retranslateUi();
        this.structurePanel.retranslateUi();
        this.callsTree.retranslateUi();
    }

    public void setConnectionState(ConnectionState state) {
        this.connectionState = state;
        this.updateUiState();
    }

    public boolean isJarOpen() {
        return this.isJarOpen;
    }

    public ConnectionState getConnectionState() {
        return this.connectionState;
    }

    public boolean validateImmediateAction(Consumer<ValidationContext> op) {
        ValidationContext vc = new ValidationContext();
        op.accept(vc);
        if (!vc.canProceed()) {
            List messages = vc.getMessages();
            String text = ValidatableUi.formatMessages(messages);
            JOptionPane.showMessageDialog(this.getFrame(), text, String.format("%d message(s)", messages.size()), 0);
        }
        return vc.canProceed();
    }

    public boolean isEditable(EditableType t) {
        return this.editableTypes.contains((Object)t);
    }
}

