/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui;

import com.google.common.collect.Lists;
import cuchaz.enigma.Enigma;
import cuchaz.enigma.EnigmaProfile;
import cuchaz.enigma.EnigmaProject;
import cuchaz.enigma.analysis.ClassImplementationsTreeNode;
import cuchaz.enigma.analysis.ClassInheritanceTreeNode;
import cuchaz.enigma.analysis.ClassReferenceTreeNode;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.FieldReferenceTreeNode;
import cuchaz.enigma.analysis.IndexTreeBuilder;
import cuchaz.enigma.analysis.MethodImplementationsTreeNode;
import cuchaz.enigma.analysis.MethodInheritanceTreeNode;
import cuchaz.enigma.analysis.MethodReferenceTreeNode;
import cuchaz.enigma.analysis.StructureTreeNode;
import cuchaz.enigma.analysis.StructureTreeOptions;
import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.api.service.ObfuscationTestService;
import cuchaz.enigma.classhandle.ClassHandle;
import cuchaz.enigma.classhandle.ClassHandleProvider;
import cuchaz.enigma.classprovider.ClassProvider;
import cuchaz.enigma.classprovider.ClasspathClassProvider;
import cuchaz.enigma.gui.ConnectionState;
import cuchaz.enigma.gui.Gui;
import cuchaz.enigma.gui.ReadableToken;
import cuchaz.enigma.gui.config.NetConfig;
import cuchaz.enigma.gui.config.UiConfig;
import cuchaz.enigma.gui.dialog.ProgressDialog;
import cuchaz.enigma.gui.newabstraction.EntryValidation;
import cuchaz.enigma.gui.stats.StatsGenerator;
import cuchaz.enigma.gui.stats.StatsMember;
import cuchaz.enigma.gui.util.History;
import cuchaz.enigma.network.ClientPacketHandler;
import cuchaz.enigma.network.EnigmaClient;
import cuchaz.enigma.network.EnigmaServer;
import cuchaz.enigma.network.IntegratedEnigmaServer;
import cuchaz.enigma.network.Message;
import cuchaz.enigma.network.ServerPacketHandler;
import cuchaz.enigma.network.packet.EntryChangeC2SPacket;
import cuchaz.enigma.network.packet.LoginC2SPacket;
import cuchaz.enigma.network.packet.Packet;
import cuchaz.enigma.source.DecompiledClassSource;
import cuchaz.enigma.source.DecompilerService;
import cuchaz.enigma.source.SourceIndex;
import cuchaz.enigma.source.Token;
import cuchaz.enigma.translation.Translatable;
import cuchaz.enigma.translation.TranslateResult;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryChange;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.EntryRemapper;
import cuchaz.enigma.translation.mapping.EntryUtil;
import cuchaz.enigma.translation.mapping.MappingDelta;
import cuchaz.enigma.translation.mapping.ResolutionStrategy;
import cuchaz.enigma.translation.mapping.serde.MappingFormat;
import cuchaz.enigma.translation.mapping.serde.MappingParseException;
import cuchaz.enigma.translation.mapping.serde.MappingSaveParameters;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.translation.mapping.tree.HashEntryTree;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import cuchaz.enigma.translation.representation.entry.ParentedEntry;
import cuchaz.enigma.utils.I18n;
import cuchaz.enigma.utils.Result;
import cuchaz.enigma.utils.Utils;
import cuchaz.enigma.utils.validation.PrintValidatable;
import cuchaz.enigma.utils.validation.Validatable;
import cuchaz.enigma.utils.validation.ValidationContext;
import java.awt.Desktop;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class GuiController
implements ClientPacketHandler {
    private final Gui gui;
    public final Enigma enigma;
    public EnigmaProject project;
    private IndexTreeBuilder indexTreeBuilder;
    private Path loadedMappingPath;
    private MappingFormat loadedMappingFormat;
    private ClassHandleProvider chp;
    private ClassHandle tokenHandle;
    private EnigmaClient client;
    private EnigmaServer server;
    private History<EntryReference<Entry<?>, Entry<?>>> referenceHistory;

    public GuiController(Gui gui, EnigmaProfile profile) {
        this.gui = gui;
        this.enigma = Enigma.builder().setProfile(profile).build();
    }

    public boolean isDirty() {
        return this.project != null && this.project.getMapper().isDirty();
    }

    public CompletableFuture<Void> openJar(Path jarPath) {
        this.gui.onStartOpenJar();
        return ProgressDialog.runOffThread(this.gui.getFrame(), progress -> {
            this.project = this.enigma.openJar(jarPath, (ClassProvider)new ClasspathClassProvider(), progress);
            this.indexTreeBuilder = new IndexTreeBuilder(this.project.getJarIndex());
            this.chp = new ClassHandleProvider(this.project, UiConfig.getDecompiler().service);
            SwingUtilities.invokeLater(() -> {
                this.gui.onFinishOpenJar(jarPath.getFileName().toString());
                this.refreshClasses();
            });
        });
    }

    public void closeJar() {
        this.chp.destroy();
        this.chp = null;
        this.project = null;
        this.gui.onCloseJar();
    }

    public CompletableFuture<Void> openMappings(MappingFormat format, Path path) {
        if (this.project == null) {
            return CompletableFuture.completedFuture(null);
        }
        this.gui.setMappingsFile(path);
        return ProgressDialog.runOffThread(this.gui.getFrame(), progress -> {
            try {
                MappingSaveParameters saveParameters = this.enigma.getProfile().getMappingSaveParameters();
                EntryTree mappings = format.read(path, progress, saveParameters);
                this.project.setMappings(mappings);
                this.loadedMappingFormat = format;
                this.loadedMappingPath = path;
                this.refreshClasses();
                this.chp.invalidateJavadoc();
            }
            catch (MappingParseException e) {
                JOptionPane.showMessageDialog(this.gui.getFrame(), e.getMessage());
            }
        });
    }

    public void openMappings(EntryTree<EntryMapping> mappings) {
        if (this.project == null) {
            return;
        }
        this.project.setMappings(mappings);
        this.refreshClasses();
        this.chp.invalidateJavadoc();
    }

    public CompletableFuture<Void> saveMappings(Path path) {
        return this.saveMappings(path, this.loadedMappingFormat);
    }

    public CompletableFuture<Void> saveMappings(Path path, MappingFormat format) {
        if (this.project == null) {
            return CompletableFuture.completedFuture(null);
        }
        return ProgressDialog.runOffThread(this.gui.getFrame(), progress -> {
            EntryRemapper mapper = this.project.getMapper();
            MappingSaveParameters saveParameters = this.enigma.getProfile().getMappingSaveParameters();
            MappingDelta delta = mapper.takeMappingDelta();
            boolean saveAll = !path.equals(this.loadedMappingPath);
            this.loadedMappingFormat = format;
            this.loadedMappingPath = path;
            if (saveAll) {
                format.write((EntryTree)mapper.getObfToDeobf(), path, progress, saveParameters);
            } else {
                format.write((EntryTree)mapper.getObfToDeobf(), delta, path, progress, saveParameters);
            }
        });
    }

    public void closeMappings() {
        if (this.project == null) {
            return;
        }
        this.project.setMappings(null);
        this.gui.setMappingsFile(null);
        this.refreshClasses();
        this.chp.invalidateJavadoc();
    }

    public void reloadAll() {
        Path jarPath = this.project.getJarPath();
        MappingFormat loadedMappingFormat = this.loadedMappingFormat;
        Path loadedMappingPath = this.loadedMappingPath;
        if (jarPath != null) {
            this.closeJar();
            CompletableFuture<Void> f = this.openJar(jarPath);
            if (loadedMappingFormat != null && loadedMappingPath != null) {
                f.whenComplete((v, t) -> this.openMappings(loadedMappingFormat, loadedMappingPath));
            }
        }
    }

    public void reloadMappings() {
        MappingFormat loadedMappingFormat = this.loadedMappingFormat;
        Path loadedMappingPath = this.loadedMappingPath;
        if (loadedMappingFormat != null && loadedMappingPath != null) {
            this.closeMappings();
            this.openMappings(loadedMappingFormat, loadedMappingPath);
        }
    }

    public CompletableFuture<Void> dropMappings() {
        if (this.project == null) {
            return CompletableFuture.completedFuture(null);
        }
        return ProgressDialog.runOffThread(this.gui.getFrame(), progress -> this.project.dropMappings(progress));
    }

    public CompletableFuture<Void> exportSource(Path path) {
        if (this.project == null) {
            return CompletableFuture.completedFuture(null);
        }
        return ProgressDialog.runOffThread(this.gui.getFrame(), progress -> {
            EnigmaProject.JarExport jar = this.project.exportRemappedJar(progress);
            jar.decompileStream(progress, this.chp.getDecompilerService(), EnigmaProject.DecompileErrorStrategy.TRACE_AS_SOURCE).forEach(source -> {
                try {
                    source.writeTo(source.resolvePath(path));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        });
    }

    public CompletableFuture<Void> exportJar(Path path) {
        if (this.project == null) {
            return CompletableFuture.completedFuture(null);
        }
        return ProgressDialog.runOffThread(this.gui.getFrame(), progress -> {
            EnigmaProject.JarExport jar = this.project.exportRemappedJar(progress);
            jar.write(path, progress);
        });
    }

    public void setTokenHandle(ClassHandle handle) {
        if (this.tokenHandle != null) {
            this.tokenHandle.close();
        }
        this.tokenHandle = handle;
    }

    public ClassHandle getTokenHandle() {
        return this.tokenHandle;
    }

    public ReadableToken getReadableToken(Token token) {
        if (this.tokenHandle == null) {
            return null;
        }
        try {
            return (ReadableToken)((Result)this.tokenHandle.getSource().get()).map(DecompiledClassSource::getIndex).map(index -> new ReadableToken(index.getLineNumber(token.start), index.getColumnNumber(token.start), index.getColumnNumber(token.end))).unwrapOr(null);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void openDeclaration(Entry<?> entry) {
        if (entry == null) {
            throw new IllegalArgumentException("Entry cannot be null!");
        }
        this.openReference(EntryReference.declaration(entry, (String)entry.getName()));
    }

    public void openReference(EntryReference<Entry<?>, Entry<?>> reference) {
        if (reference == null) {
            throw new IllegalArgumentException("Reference cannot be null!");
        }
        if (this.referenceHistory == null) {
            this.referenceHistory = new History(reference);
        } else if (!reference.equals(this.referenceHistory.getCurrent())) {
            this.referenceHistory.push(reference);
        }
        this.gui.showReference(reference);
    }

    public List<Token> getTokensForReference(DecompiledClassSource source, EntryReference<Entry<?>, Entry<?>> reference) {
        EntryRemapper mapper = this.project.getMapper();
        SourceIndex index = source.getIndex();
        return mapper.getObfResolver().resolveReference(reference, ResolutionStrategy.RESOLVE_CLOSEST).stream().flatMap(r -> index.getReferenceTokens(r).stream()).sorted().toList();
    }

    public void openPreviousReference() {
        if (this.hasPreviousReference()) {
            this.gui.showReference(this.referenceHistory.goBack());
        }
    }

    public boolean hasPreviousReference() {
        return this.referenceHistory != null && this.referenceHistory.canGoBack();
    }

    public void openNextReference() {
        if (this.hasNextReference()) {
            this.gui.showReference(this.referenceHistory.goForward());
        }
    }

    public boolean hasNextReference() {
        return this.referenceHistory != null && this.referenceHistory.canGoForward();
    }

    public void navigateTo(Entry<?> entry) {
        if (!this.project.isRenamable(entry)) {
            return;
        }
        this.openDeclaration(entry);
    }

    public void navigateTo(EntryReference<Entry<?>, Entry<?>> reference) {
        if (!this.project.isRenamable((Entry)reference.getLocationClassEntry())) {
            return;
        }
        this.openReference(reference);
    }

    public void refreshClasses() {
        if (this.project == null) {
            return;
        }
        ArrayList obfClasses = Lists.newArrayList();
        ArrayList deobfClasses = Lists.newArrayList();
        this.addSeparatedClasses(obfClasses, deobfClasses);
        this.gui.setObfClasses(obfClasses);
        this.gui.setDeobfClasses(deobfClasses);
    }

    public void addSeparatedClasses(List<ClassEntry> obfClasses, List<ClassEntry> deobfClasses) {
        EntryRemapper mapper = this.project.getMapper();
        Collection classes = this.project.getJarIndex().getEntryIndex().getClasses();
        Stream<ClassEntry> visibleClasses = classes.stream().filter(entry -> !entry.isInnerClass());
        visibleClasses.forEach(entry -> {
            boolean obfuscated;
            if (this.gui.isSingleClassTree()) {
                deobfClasses.add((ClassEntry)entry);
                return;
            }
            TranslateResult result = mapper.extendedDeobfuscate((Translatable)entry);
            ClassEntry deobfEntry = (ClassEntry)result.getValue();
            List obfService = this.enigma.getServices().get(ObfuscationTestService.TYPE);
            boolean bl = obfuscated = result.isObfuscated() && deobfEntry.equals(entry);
            if (obfuscated && !obfService.isEmpty() && obfService.stream().anyMatch(service -> service.testDeobfuscated((Entry)entry))) {
                obfuscated = false;
            }
            if (obfuscated) {
                obfClasses.add((ClassEntry)entry);
            } else {
                deobfClasses.add((ClassEntry)entry);
            }
        });
    }

    public StructureTreeNode getClassStructure(ClassEntry entry, StructureTreeOptions options) {
        StructureTreeNode rootNode = new StructureTreeNode(this.project, entry, (ParentedEntry)entry);
        rootNode.load(this.project, options);
        return rootNode;
    }

    public ClassInheritanceTreeNode getClassInheritance(ClassEntry entry) {
        Translator translator = this.project.getMapper().getDeobfuscator();
        ClassInheritanceTreeNode rootNode = this.indexTreeBuilder.buildClassInheritance(translator, entry);
        return ClassInheritanceTreeNode.findNode((ClassInheritanceTreeNode)rootNode, (ClassEntry)entry);
    }

    public ClassImplementationsTreeNode getClassImplementations(ClassEntry entry) {
        Translator translator = this.project.getMapper().getDeobfuscator();
        return this.indexTreeBuilder.buildClassImplementations(translator, entry);
    }

    public MethodInheritanceTreeNode getMethodInheritance(MethodEntry entry) {
        Translator translator = this.project.getMapper().getDeobfuscator();
        MethodInheritanceTreeNode rootNode = this.indexTreeBuilder.buildMethodInheritance(translator, entry);
        return MethodInheritanceTreeNode.findNode((MethodInheritanceTreeNode)rootNode, (MethodEntry)entry);
    }

    public MethodImplementationsTreeNode getMethodImplementations(MethodEntry entry) {
        Translator translator = this.project.getMapper().getDeobfuscator();
        List rootNodes = this.indexTreeBuilder.buildMethodImplementations(translator, entry);
        if (rootNodes.isEmpty()) {
            return null;
        }
        if (rootNodes.size() > 1) {
            System.err.println("WARNING: Method " + String.valueOf(entry) + " implements multiple interfaces. Only showing first one.");
        }
        return MethodImplementationsTreeNode.findNode((MethodImplementationsTreeNode)((MethodImplementationsTreeNode)rootNodes.get(0)), (MethodEntry)entry);
    }

    public ClassReferenceTreeNode getClassReferences(ClassEntry entry) {
        Translator deobfuscator = this.project.getMapper().getDeobfuscator();
        ClassReferenceTreeNode rootNode = new ClassReferenceTreeNode(deobfuscator, entry);
        rootNode.load(this.project.getJarIndex(), true);
        return rootNode;
    }

    public FieldReferenceTreeNode getFieldReferences(FieldEntry entry) {
        Translator translator = this.project.getMapper().getDeobfuscator();
        FieldReferenceTreeNode rootNode = new FieldReferenceTreeNode(translator, entry);
        rootNode.load(this.project.getJarIndex(), true);
        return rootNode;
    }

    public MethodReferenceTreeNode getMethodReferences(MethodEntry entry, boolean recursive) {
        Translator translator = this.project.getMapper().getDeobfuscator();
        MethodReferenceTreeNode rootNode = new MethodReferenceTreeNode(translator, entry);
        rootNode.load(this.project.getJarIndex(), true, recursive);
        return rootNode;
    }

    public boolean applyChangeFromServer(EntryChange<?> change) {
        ValidationContext vc = new ValidationContext();
        vc.setActiveElement((Validatable)PrintValidatable.INSTANCE);
        this.applyChange0(vc, change);
        this.gui.showStructure(this.gui.getActiveEditor());
        return vc.canProceed();
    }

    public void validateChange(ValidationContext vc, EntryChange<?> change) {
        if (change.getDeobfName().isSet()) {
            EntryValidation.validateRename(vc, this.project, change.getTarget(), (String)change.getDeobfName().getNewValue());
        }
        if (change.getJavadoc().isSet()) {
            EntryValidation.validateJavadoc(vc, (String)change.getJavadoc().getNewValue());
        }
    }

    public void applyChange(ValidationContext vc, EntryChange<?> change) {
        this.applyChange0(vc, change);
        this.gui.showStructure(this.gui.getActiveEditor());
        if (!vc.canProceed()) {
            return;
        }
        this.sendPacket((Packet<ServerPacketHandler>)new EntryChangeC2SPacket(change));
    }

    private void applyChange0(ValidationContext vc, EntryChange<?> change) {
        boolean renamed;
        this.validateChange(vc, change);
        if (!vc.canProceed()) {
            return;
        }
        Entry target = change.getTarget();
        EntryMapping prev = this.project.getMapper().getDeobfMapping(target);
        EntryMapping mapping = EntryUtil.applyChange((ValidationContext)vc, (EntryRemapper)this.project.getMapper(), change);
        boolean bl = renamed = !change.getDeobfName().isUnchanged();
        if (renamed && target instanceof ClassEntry && !((ClassEntry)target).isInnerClass()) {
            this.gui.moveClassTree(target, prev.targetName() == null, mapping.targetName() == null);
        }
        if (!Objects.equals(prev.targetName(), mapping.targetName())) {
            this.chp.invalidateMapped();
        }
        if (!Objects.equals(prev.javadoc(), mapping.javadoc())) {
            this.chp.invalidateJavadoc(target.getTopLevelClass());
        }
        this.gui.showStructure(this.gui.getActiveEditor());
    }

    public void openStats(Set<StatsMember> includedMembers, String topLevelPackage, boolean includeSynthetic) {
        ProgressDialog.runOffThread(this.gui.getFrame(), progress -> {
            String data = new StatsGenerator(this.project).generate(progress, includedMembers, topLevelPackage, includeSynthetic).getTreeJson();
            try {
                File statsFile = File.createTempFile("stats", ".html");
                try (FileWriter w = new FileWriter(statsFile);){
                    w.write(Utils.readResourceToString((String)"/stats.html").replace("/*data*/", data));
                }
                Desktop.getDesktop().open(statsFile);
            }
            catch (IOException e) {
                throw new Error(e);
            }
        });
    }

    public void setDecompiler(DecompilerService service) {
        if (this.chp != null) {
            this.chp.setDecompilerService(service);
        }
    }

    public ClassHandleProvider getClassHandleProvider() {
        return this.chp;
    }

    public EnigmaClient getClient() {
        return this.client;
    }

    public EnigmaServer getServer() {
        return this.server;
    }

    public void createClient(String username, String ip, int port, char[] password) throws IOException {
        this.client = new EnigmaClient((ClientPacketHandler)this, ip, port);
        this.client.connect();
        this.client.sendPacket((Packet)new LoginC2SPacket(this.project.getJarChecksum(), password, username));
        this.gui.setConnectionState(ConnectionState.CONNECTED);
    }

    public void createServer(int port, char[] password) throws IOException {
        this.server = new IntegratedEnigmaServer(this.project.getJarChecksum(), password, EntryRemapper.mapped((JarIndex)this.project.getJarIndex(), (EntryTree)new HashEntryTree((EntryTree)this.project.getMapper().getObfToDeobf())), port);
        this.server.start();
        this.client = new EnigmaClient((ClientPacketHandler)this, "127.0.0.1", port);
        this.client.connect();
        this.client.sendPacket((Packet)new LoginC2SPacket(this.project.getJarChecksum(), password, NetConfig.getUsername()));
        this.gui.setConnectionState(ConnectionState.HOSTING);
    }

    public synchronized void disconnectIfConnected(String reason) {
        if (this.client == null && this.server == null) {
            return;
        }
        if (this.client != null) {
            this.client.disconnect();
        }
        if (this.server != null) {
            this.server.stop();
        }
        this.client = null;
        this.server = null;
        SwingUtilities.invokeLater(() -> {
            if (reason != null) {
                JOptionPane.showMessageDialog(this.gui.getFrame(), I18n.translate((String)reason), I18n.translate((String)"disconnect.disconnected"), 1);
            }
            this.gui.setConnectionState(ConnectionState.NOT_CONNECTED);
        });
    }

    public void sendPacket(Packet<ServerPacketHandler> packet) {
        if (this.client != null) {
            this.client.sendPacket(packet);
        }
    }

    public void addMessage(Message message) {
        this.gui.addMessage(message);
    }

    public void updateUserList(List<String> users) {
        this.gui.setUserList(users);
    }
}

