/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.dialog;

import cuchaz.enigma.gui.config.NetConfig;
import cuchaz.enigma.gui.dialog.AbstractDialog;
import cuchaz.enigma.gui.elements.ValidatableTextField;
import cuchaz.enigma.gui.util.ScaleUtil;
import cuchaz.enigma.network.ServerAddress;
import cuchaz.enigma.utils.Pair;
import cuchaz.enigma.utils.validation.Message;
import cuchaz.enigma.utils.validation.StandardValidation;
import cuchaz.enigma.utils.validation.Validatable;
import cuchaz.enigma.utils.validation.ValidationContext;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class ConnectToServerDialog
extends AbstractDialog {
    private JTextField usernameField;
    private ValidatableTextField ipField;
    private JPasswordField passwordField;

    public ConnectToServerDialog(Frame owner) {
        super(owner, "prompt.connect.title", "prompt.connect.confirm", "prompt.cancel");
        Dimension preferredSize = this.getPreferredSize();
        preferredSize.width = ScaleUtil.scale(400);
        this.setPreferredSize(preferredSize);
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    @Override
    protected List<Pair<String, Component>> createComponents() {
        this.usernameField = new JTextField(NetConfig.getUsername());
        this.ipField = new ValidatableTextField(NetConfig.getRemoteAddress());
        this.passwordField = new JPasswordField(NetConfig.getPassword());
        this.usernameField.addActionListener(event -> this.confirm());
        this.ipField.addActionListener(event -> this.confirm());
        this.passwordField.addActionListener(event -> this.confirm());
        return Arrays.asList(new Pair((Object)"prompt.connect.username", (Object)this.usernameField), new Pair((Object)"prompt.connect.address", (Object)this.ipField), new Pair((Object)"prompt.password", (Object)this.passwordField));
    }

    @Override
    public void validateInputs() {
        this.vc.setActiveElement((Validatable)this.ipField);
        if (StandardValidation.notBlank((ValidationContext)this.vc, (String)this.ipField.getText()) && ServerAddress.from((String)this.ipField.getText(), (int)34712) == null) {
            this.vc.raise(Message.INVALID_IP, new Object[0]);
        }
    }

    public Result getResult() {
        if (!this.isActionConfirm()) {
            return null;
        }
        this.vc.reset();
        this.validateInputs();
        if (!this.vc.canProceed()) {
            return null;
        }
        return new Result(this.usernameField.getText(), this.ipField.getText(), Objects.requireNonNull(ServerAddress.from((String)this.ipField.getText(), (int)34712)), this.passwordField.getPassword());
    }

    public static Result show(Frame parent) {
        ConnectToServerDialog d = new ConnectToServerDialog(parent);
        d.setVisible(true);
        Result r = d.getResult();
        d.dispose();
        return r;
    }

    public static class Result {
        private final String username;
        private final String addressStr;
        private final ServerAddress address;
        private final char[] password;

        public Result(String username, String addressStr, ServerAddress address, char[] password) {
            this.username = username;
            this.addressStr = addressStr;
            this.address = address;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public String getAddressStr() {
            return this.addressStr;
        }

        public ServerAddress getAddress() {
            return this.address;
        }

        public char[] getPassword() {
            return this.password;
        }
    }
}

