/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.elements;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.GridLayout;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

public class StatusBar {
    private final JPanel ui = new JPanel(new BorderLayout());
    private final JPanel leftPanel = new JPanel(new GridLayout(1, 1, 0, 0));
    private final JPanel components = new JPanel();
    private final JPanel permanentComponents = new JPanel();
    private final JLabel temporaryMessage = new JLabel();
    private final Timer timer = new Timer(0, e -> this.clearMessage());

    public StatusBar() {
        this.timer.setRepeats(false);
        this.components.setLayout(new BoxLayout(this.components, 2));
        this.permanentComponents.setLayout(new BoxLayout(this.permanentComponents, 2));
        this.permanentComponents.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.leftPanel.add(this.components);
        this.temporaryMessage.setHorizontalTextPosition(2);
        this.ui.add((Component)this.leftPanel, "Center");
        this.ui.add((Component)this.permanentComponents, "East");
    }

    public void showMessage(String message) {
        this.showMessage(message, 0);
    }

    public void showMessage(String message, int timeout) {
        this.timer.stop();
        this.temporaryMessage.setText(message);
        this.leftPanel.removeAll();
        this.leftPanel.add(this.temporaryMessage);
        this.leftPanel.revalidate();
        if (timeout > 0) {
            this.timer.setInitialDelay(timeout);
            this.timer.start();
        }
    }

    public void clearMessage() {
        this.timer.stop();
        this.leftPanel.removeAll();
        this.leftPanel.add(this.components);
        this.leftPanel.revalidate();
        this.temporaryMessage.setText("");
    }

    public String currentMessage() {
        return this.temporaryMessage.getText();
    }

    public void addComponent(Component comp) {
        this.components.add(comp);
    }

    public void removeComponent(Component comp) {
        this.components.remove(comp);
    }

    public void addPermanentComponent(Component comp) {
        this.permanentComponents.add(comp);
    }

    public void removePermanentComponent(Component comp) {
        this.permanentComponents.remove(comp);
    }

    public JPanel getUi() {
        return this.ui;
    }
}

