/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.renderer;

import cuchaz.enigma.analysis.ClassInheritanceTreeNode;
import cuchaz.enigma.analysis.MethodInheritanceTreeNode;
import cuchaz.enigma.gui.Gui;
import cuchaz.enigma.gui.config.UiConfig;
import cuchaz.enigma.gui.util.GuiUtil;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class InheritanceTreeCellRenderer
extends DefaultTreeCellRenderer {
    private final Gui gui;

    public InheritanceTreeCellRenderer(Gui gui) {
        this.gui = gui;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        MethodInheritanceTreeNode node;
        Component ret = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        if (!(value instanceof MethodInheritanceTreeNode) || (node = (MethodInheritanceTreeNode)value).isImplemented()) {
            ret.setForeground(UiConfig.getTextColor());
            ret.setFont(ret.getFont().deriveFont(0));
            if (value instanceof ClassInheritanceTreeNode) {
                this.setIcon(GuiUtil.getClassIcon(this.gui, ((ClassInheritanceTreeNode)value).getClassEntry()));
            } else if (value instanceof MethodInheritanceTreeNode) {
                this.setIcon(GuiUtil.getMethodIcon(((MethodInheritanceTreeNode)value).getMethodEntry()));
            }
        } else {
            ret.setForeground(UiConfig.getNumberColor());
            ret.setFont(ret.getFont().deriveFont(2));
            this.setIcon(GuiUtil.CLASS_ICON);
        }
        return ret;
    }
}

