/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.stats;

import cuchaz.enigma.EnigmaProject;
import cuchaz.enigma.ProgressListener;
import cuchaz.enigma.analysis.index.EntryIndex;
import cuchaz.enigma.gui.stats.StatsMember;
import cuchaz.enigma.gui.stats.StatsResult;
import cuchaz.enigma.translation.Translatable;
import cuchaz.enigma.translation.mapping.EntryRemapper;
import cuchaz.enigma.translation.mapping.EntryResolver;
import cuchaz.enigma.translation.mapping.ResolutionStrategy;
import cuchaz.enigma.translation.representation.TypeDescriptor;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.FieldDefEntry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.LocalVariableEntry;
import cuchaz.enigma.translation.representation.entry.MethodDefEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import cuchaz.enigma.utils.I18n;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class StatsGenerator {
    private final EnigmaProject project;
    private final EntryIndex entryIndex;
    private final EntryRemapper mapper;
    private final EntryResolver entryResolver;

    public StatsGenerator(EnigmaProject project) {
        this.project = project;
        this.entryIndex = project.getJarIndex().getEntryIndex();
        this.mapper = project.getMapper();
        this.entryResolver = project.getJarIndex().getEntryResolver();
    }

    public StatsResult generate(ProgressListener progress, Set<StatsMember> includedMembers, String topLevelPackage, boolean includeSynthetic) {
        includedMembers = EnumSet.copyOf(includedMembers);
        int totalWork = 0;
        int totalMappable = 0;
        if (includedMembers.contains((Object)StatsMember.METHODS) || includedMembers.contains((Object)StatsMember.PARAMETERS)) {
            totalWork += this.entryIndex.getMethods().size();
        }
        if (includedMembers.contains((Object)StatsMember.FIELDS)) {
            totalWork += this.entryIndex.getFields().size();
        }
        if (includedMembers.contains((Object)StatsMember.CLASSES)) {
            totalWork += this.entryIndex.getClasses().size();
        }
        progress.init(totalWork, I18n.translate((String)"progress.stats"));
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        String topLevelPackageSlash = topLevelPackage.replace(".", "/");
        int numDone = 0;
        if (includedMembers.contains((Object)StatsMember.METHODS) || includedMembers.contains((Object)StatsMember.PARAMETERS)) {
            for (MethodEntry method : this.entryIndex.getMethods()) {
                progress.step(numDone++, I18n.translate((String)"type.methods"));
                MethodEntry root = (MethodEntry)this.entryResolver.resolveEntry((Entry)method, ResolutionStrategy.RESOLVE_ROOT).stream().findFirst().orElseThrow(AssertionError::new);
                ClassEntry clazz = (ClassEntry)root.getParent();
                if (root != method || !((ClassEntry)this.mapper.deobfuscate((Translatable)clazz)).getPackageName().startsWith(topLevelPackageSlash)) continue;
                if (includedMembers.contains((Object)StatsMember.METHODS) && !((MethodDefEntry)method).getAccess().isSynthetic()) {
                    this.update((Map<String, Integer>)counts, (Entry<?>)method);
                    ++totalMappable;
                }
                if (!includedMembers.contains((Object)StatsMember.PARAMETERS) || ((MethodDefEntry)method).getAccess().isSynthetic() && !includeSynthetic) continue;
                int index = ((MethodDefEntry)method).getAccess().isStatic() ? 0 : 1;
                for (TypeDescriptor argument : method.getDesc().getArgumentDescs()) {
                    this.update((Map<String, Integer>)counts, (Entry<?>)new LocalVariableEntry(method, index, "", true, null));
                    index += argument.getSize();
                    ++totalMappable;
                }
            }
        }
        if (includedMembers.contains((Object)StatsMember.FIELDS)) {
            for (FieldEntry field : this.entryIndex.getFields()) {
                progress.step(numDone++, I18n.translate((String)"type.fields"));
                ClassEntry clazz = (ClassEntry)field.getParent();
                if (((FieldDefEntry)field).getAccess().isSynthetic() || !((ClassEntry)this.mapper.deobfuscate((Translatable)clazz)).getPackageName().startsWith(topLevelPackageSlash)) continue;
                this.update((Map<String, Integer>)counts, (Entry<?>)field);
                ++totalMappable;
            }
        }
        if (includedMembers.contains((Object)StatsMember.CLASSES)) {
            for (ClassEntry clazz : this.entryIndex.getClasses()) {
                progress.step(numDone++, I18n.translate((String)"type.classes"));
                if (!((ClassEntry)this.mapper.deobfuscate((Translatable)clazz)).getPackageName().startsWith(topLevelPackageSlash)) continue;
                this.update((Map<String, Integer>)counts, (Entry<?>)clazz);
                ++totalMappable;
            }
        }
        if (includedMembers.contains((Object)StatsMember.FIELDS)) {
            for (FieldEntry field : this.entryIndex.getFields()) {
                progress.step(numDone++, I18n.translate((String)"type.fields"));
                if (((FieldDefEntry)field).getAccess().isSynthetic()) continue;
                this.update((Map<String, Integer>)counts, (Entry<?>)field);
                ++totalMappable;
            }
        }
        if (includedMembers.contains((Object)StatsMember.CLASSES)) {
            for (ClassEntry clazz : this.entryIndex.getClasses()) {
                progress.step(numDone++, I18n.translate((String)"type.classes"));
                this.update((Map<String, Integer>)counts, (Entry<?>)clazz);
                ++totalMappable;
            }
        }
        progress.step(-1, I18n.translate((String)"progress.stats.data"));
        StatsResult.Tree<Integer> tree = new StatsResult.Tree<Integer>();
        for (Map.Entry entry : counts.entrySet()) {
            if (!((String)entry.getKey()).startsWith(topLevelPackage)) continue;
            tree.getNode((String)((String)entry.getKey())).value = entry.getValue();
        }
        tree.collapse(tree.root);
        return new StatsResult(totalMappable, counts.values().stream().mapToInt(i -> i).sum(), tree);
    }

    private void update(Map<String, Integer> counts, Entry<?> entry) {
        if (this.project.isObfuscated(entry)) {
            String parent = ((Entry)this.mapper.deobfuscate((Translatable)((Entry)entry.getAncestry().get(0)))).getName().replace('/', '.');
            counts.put(parent, counts.getOrDefault(parent, 0) + 1);
        }
    }
}

