/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.util;

import com.formdev.flatlaf.extras.FlatSVGIcon;
import com.google.common.collect.Lists;
import cuchaz.enigma.analysis.index.EntryIndex;
import cuchaz.enigma.gui.Gui;
import cuchaz.enigma.translation.representation.AccessFlags;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import cuchaz.enigma.utils.Os;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class GuiUtil {
    public static final Icon CLASS_ICON = GuiUtil.loadIcon("class");
    public static final Icon INTERFACE_ICON = GuiUtil.loadIcon("interface");
    public static final Icon ENUM_ICON = GuiUtil.loadIcon("enum");
    public static final Icon ANNOTATION_ICON = GuiUtil.loadIcon("annotation");
    public static final Icon RECORD_ICON = GuiUtil.loadIcon("record");
    public static final Icon METHOD_ICON = GuiUtil.loadIcon("method");
    public static final Icon FIELD_ICON = GuiUtil.loadIcon("field");
    public static final Icon CONSTRUCTOR_ICON = GuiUtil.loadIcon("constructor");

    public static void openUrl(String url) {
        try {
            switch (Os.getOs()) {
                case LINUX: {
                    new ProcessBuilder("/usr/bin/env", "xdg-open", url).start();
                    break;
                }
                default: {
                    if (Desktop.isDesktopSupported()) {
                        Desktop desktop = Desktop.getDesktop();
                        desktop.browse(new URI(url));
                    }
                    break;
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static JLabel unboldLabel(JLabel label) {
        Font font = label.getFont();
        label.setFont(font.deriveFont(font.getStyle() & 0xFFFFFFFE));
        return label;
    }

    public static void copyToClipboard(String text) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(text), null);
    }

    public static String getClipboard() {
        try {
            return (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException | IOException e) {
            return "";
        }
    }

    public static void showPopup(JComponent component, String text, int x, int y) {
        JToolTip tooltip = new JToolTip();
        tooltip.setTipText(text);
        Popup p = PopupFactory.getSharedInstance().getPopup(component, tooltip, x + 10, y);
        p.show();
        Timer t = new Timer(1000, e -> p.hide());
        t.setRepeats(false);
        t.start();
    }

    public static void showToolTipNow(JComponent component) {
        ToolTipManager manager = ToolTipManager.sharedInstance();
        int oldDelay = manager.getInitialDelay();
        manager.setInitialDelay(0);
        manager.mouseMoved(new MouseEvent(component, 503, System.currentTimeMillis(), 0, 0, 0, 0, false));
        manager.setInitialDelay(oldDelay);
    }

    public static JLabel createLink(String text, final Runnable action) {
        JLabel link = new JLabel(text);
        link.setForeground(Color.BLUE.darker());
        link.setCursor(Cursor.getPredefinedCursor(12));
        Map<TextAttribute, ?> attributes = link.getFont().getAttributes();
        attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        link.setFont(link.getFont().deriveFont(attributes));
        link.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                action.run();
            }
        });
        return link;
    }

    public static Icon loadIcon(String name) {
        String path = "icons/" + name + ".svg";
        if (GuiUtil.class.getResource("/" + path) == null) {
            throw new NoSuchElementException("Missing icon: '" + name + "' at " + path);
        }
        return new FlatSVGIcon(path, 16, 16, GuiUtil.class.getClassLoader());
    }

    public static Icon getClassIcon(Gui gui, ClassEntry entry) {
        EntryIndex entryIndex = gui.getController().project.getJarIndex().getEntryIndex();
        AccessFlags access = entryIndex.getClassAccess(entry);
        if (access != null) {
            if (access.isAnnotation()) {
                return ANNOTATION_ICON;
            }
            if (access.isInterface()) {
                return INTERFACE_ICON;
            }
            if (access.isEnum()) {
                return ENUM_ICON;
            }
            if (entryIndex.getDefinition(entry).isRecord()) {
                return RECORD_ICON;
            }
        }
        return CLASS_ICON;
    }

    public static Icon getMethodIcon(MethodEntry entry) {
        if (entry.isConstructor()) {
            return CONSTRUCTOR_ICON;
        }
        return METHOD_ICON;
    }

    public static TreePath getPathToRoot(TreeNode node) {
        ArrayList nodes = Lists.newArrayList();
        TreeNode n = node;
        do {
            nodes.add(n);
        } while ((n = n.getParent()) != null);
        Collections.reverse(nodes);
        return new TreePath(nodes.toArray());
    }

    public static MouseListener onMouseClick(final Consumer<MouseEvent> op) {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                op.accept(e);
            }
        };
    }

    public static MouseListener onMousePress(final Consumer<MouseEvent> op) {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                op.accept(e);
            }
        };
    }

    public static WindowListener onWindowClose(final Consumer<WindowEvent> op) {
        return new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                op.accept(e);
            }
        };
    }
}

