/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.util;

import cuchaz.enigma.translation.mapping.serde.MappingFormat;
import cuchaz.enigma.utils.I18n;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.StringJoiner;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public final class ExtensionFileFilter
extends FileFilter {
    private final String formatName;
    private final List<String> extensions;

    public ExtensionFileFilter(String formatName, List<String> extensions) {
        this.formatName = formatName;
        this.extensions = extensions;
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        for (String extension : this.extensions) {
            if (!f.getName().endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        StringJoiner joiner = new StringJoiner(", ");
        for (String extension : this.extensions) {
            joiner.add("*" + extension);
        }
        return I18n.translateFormatted("menu.file.mappings.file_filter", this.formatName, joiner.toString());
    }

    public static void setupFileChooser(JFileChooser fileChooser, MappingFormat format) {
        fileChooser.resetChoosableFileFilters();
        if (format.getFileType().isDirectory()) {
            fileChooser.setFileSelectionMode(1);
        } else {
            fileChooser.setFileSelectionMode(0);
            String formatName = I18n.translate("mapping_format." + format.name().toLowerCase(Locale.ROOT));
            ExtensionFileFilter filter = new ExtensionFileFilter(formatName, format.getFileType().extensions());
            fileChooser.addChoosableFileFilter(filter);
            fileChooser.setFileFilter(filter);
        }
    }

    public static Path getSavePath(JFileChooser fileChooser) {
        Path savePath = fileChooser.getSelectedFile().toPath();
        FileFilter fileFilter = fileChooser.getFileFilter();
        if (fileFilter instanceof ExtensionFileFilter) {
            ExtensionFileFilter extensionFilter = (ExtensionFileFilter)fileFilter;
            String fileName = savePath.getFileName().toString();
            boolean hasExtension = false;
            for (String extension : extensionFilter.getExtensions()) {
                if (!fileName.endsWith(extension)) continue;
                hasExtension = true;
                break;
            }
            if (!hasExtension) {
                String defaultExtension = extensionFilter.getExtensions().get(0);
                savePath = savePath.resolveSibling(fileName + defaultExtension);
                fileChooser.setSelectedFile(savePath.toFile());
            }
        }
        return savePath;
    }
}

