/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.source;

import cuchaz.enigma.EnigmaProject;
import cuchaz.enigma.EnigmaServices;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.api.service.NameProposalService;
import cuchaz.enigma.source.RenamableTokenType;
import cuchaz.enigma.source.SourceIndex;
import cuchaz.enigma.source.SourceRemapper;
import cuchaz.enigma.source.Token;
import cuchaz.enigma.source.TokenStore;
import cuchaz.enigma.translation.LocalNameGenerator;
import cuchaz.enigma.translation.TranslateResult;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryRemapper;
import cuchaz.enigma.translation.mapping.ResolutionStrategy;
import cuchaz.enigma.translation.representation.TypeDescriptor;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.LocalVariableDefEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public class DecompiledClassSource {
    private final ClassEntry classEntry;
    private final SourceIndex obfuscatedIndex;
    private final SourceIndex remappedIndex;
    private final TokenStore highlightedTokens;

    private DecompiledClassSource(ClassEntry classEntry, SourceIndex obfuscatedIndex, SourceIndex remappedIndex, TokenStore highlightedTokens) {
        this.classEntry = classEntry;
        this.obfuscatedIndex = obfuscatedIndex;
        this.remappedIndex = remappedIndex;
        this.highlightedTokens = highlightedTokens;
    }

    public DecompiledClassSource(ClassEntry classEntry, SourceIndex index) {
        this(classEntry, index, index, TokenStore.empty());
    }

    public static DecompiledClassSource text(ClassEntry classEntry, String text) {
        return new DecompiledClassSource(classEntry, new SourceIndex(text));
    }

    public DecompiledClassSource remapSource(EnigmaProject project, Translator translator) {
        SourceRemapper remapper = new SourceRemapper(this.obfuscatedIndex.getSource(), this.obfuscatedIndex.referenceTokens());
        TokenStore tokenStore = TokenStore.create(this.obfuscatedIndex);
        SourceRemapper.Result remapResult = remapper.remap((token, movedToken) -> this.remapToken(tokenStore, project, token, movedToken, translator));
        SourceIndex remappedIndex = this.obfuscatedIndex.remapTo(remapResult);
        return new DecompiledClassSource(this.classEntry, this.obfuscatedIndex, remappedIndex, tokenStore);
    }

    private String remapToken(TokenStore target, EnigmaProject project, Token token, Token movedToken, Translator translator) {
        String defaultName;
        EntryReference<Entry<?>, Entry<?>> reference = this.obfuscatedIndex.getReference(token);
        Entry<?> entry = reference.getNameableEntry();
        TranslateResult<Entry<?>> translatedEntry = translator.extendedTranslate(entry);
        if (project.isRenamable(reference)) {
            if (!translatedEntry.isObfuscated()) {
                target.add(translatedEntry.getType(), movedToken);
                return translatedEntry.getValue().getSourceRemapName();
            }
            Optional<String> proposedName = DecompiledClassSource.proposeName(project, entry);
            if (proposedName.isPresent()) {
                target.add(RenamableTokenType.PROPOSED, movedToken);
                return proposedName.get();
            }
            target.add(RenamableTokenType.OBFUSCATED, movedToken);
        }
        if ((defaultName = this.generateDefaultName(translatedEntry.getValue())) != null) {
            return defaultName;
        }
        return null;
    }

    public static Optional<String> proposeName(EnigmaProject project, Entry<?> entry) {
        EnigmaServices services = project.getEnigma().getServices();
        return services.get(NameProposalService.TYPE).stream().flatMap(nameProposalService -> {
            EntryRemapper mapper = project.getMapper();
            Collection<Entry> resolved = mapper.getObfResolver().resolveEntry(entry, ResolutionStrategy.RESOLVE_ROOT);
            return resolved.stream().map(e -> nameProposalService.proposeName((Entry<?>)e, mapper)).filter(Optional::isPresent).map(Optional::get);
        }).findFirst();
    }

    @Nullable
    private String generateDefaultName(Entry<?> entry) {
        if (entry instanceof LocalVariableDefEntry) {
            LocalVariableDefEntry localVariable = (LocalVariableDefEntry)entry;
            int index = localVariable.getIndex();
            if (localVariable.isArgument()) {
                List<TypeDescriptor> arguments = ((MethodEntry)localVariable.getParent()).getDesc().getArgumentDescs();
                return LocalNameGenerator.generateArgumentName(index, localVariable.getDesc(), arguments);
            }
            return LocalNameGenerator.generateLocalVariableName(index, localVariable.getDesc());
        }
        return null;
    }

    public ClassEntry getEntry() {
        return this.classEntry;
    }

    public SourceIndex getIndex() {
        return this.remappedIndex;
    }

    public TokenStore getTokenStore() {
        return this.highlightedTokens;
    }

    public Map<RenamableTokenType, ? extends Collection<Token>> getHighlightedTokens() {
        return this.highlightedTokens.getByType();
    }

    public int getObfuscatedOffset(int deobfOffset) {
        return DecompiledClassSource.getOffset(this.remappedIndex, this.obfuscatedIndex, deobfOffset);
    }

    public int getDeobfuscatedOffset(int obfOffset) {
        return DecompiledClassSource.getOffset(this.obfuscatedIndex, this.remappedIndex, obfOffset);
    }

    private static int getOffset(SourceIndex fromIndex, SourceIndex toIndex, int fromOffset) {
        int relativeOffset = 0;
        Iterator<Token> fromTokenItr = fromIndex.referenceTokens().iterator();
        Iterator<Token> toTokenItr = toIndex.referenceTokens().iterator();
        while (fromTokenItr.hasNext() && toTokenItr.hasNext()) {
            Token fromToken = fromTokenItr.next();
            Token toToken = toTokenItr.next();
            if (fromToken.end > fromOffset) break;
            relativeOffset = toToken.end - fromToken.end;
        }
        return fromOffset + relativeOffset;
    }

    public String toString() {
        return this.remappedIndex.getSource();
    }
}

