/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.java.decompiler.main.ClassWriter;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AnnotationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.TypeAnnotation;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.struct.StructMember;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.StructRecordComponent;
import org.jetbrains.java.decompiler.struct.attr.StructAnnotationAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructAnnotationParameterAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructTypeAnnotationAttribute;
import org.jetbrains.java.decompiler.struct.consts.LinkConstant;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericFieldDescriptor;
import org.jetbrains.java.decompiler.util.Key;
import org.jetbrains.java.decompiler.util.TextBuffer;

public final class RecordHelper {
    public static boolean isHiddenRecordMethod(StructClass cl, StructMethod mt, RootStatement root) {
        if (cl.getRecordComponents() == null) {
            return false;
        }
        return RecordHelper.isSyntheticRecordMethod(mt, root) || RecordHelper.isDefaultRecordMethod(mt, root) || mt.getName().equals("<init>") && !RecordHelper.hasAnnotations(mt) && RecordHelper.isDefaultRecordConstructor(cl, root);
    }

    public static boolean isHiddenRecordField(List<StructRecordComponent> components, StructField fd) {
        if (components == null) {
            return false;
        }
        for (StructRecordComponent component : components) {
            if (!component.getName().equals(fd.getName()) || !component.getDescriptor().equals(fd.getDescriptor()) || fd.hasModifier(8)) continue;
            return true;
        }
        return false;
    }

    public static void appendRecordComponents(TextBuffer buffer, StructClass cl, List<StructRecordComponent> components, int indent) {
        buffer.pushNewlineGroup(indent, 1);
        buffer.appendPossibleNewline();
        buffer.pushNewlineGroup(indent, 0);
        for (int i = 0; i < components.size(); ++i) {
            StructRecordComponent cd = components.get(i);
            if (i > 0) {
                buffer.append(",").appendPossibleNewline(" ");
            }
            boolean varArgComponent = i == components.size() - 1 && RecordHelper.isVarArgRecord(cl);
            RecordHelper.recordComponentToJava(buffer, cl, cd, i, varArgComponent);
        }
        buffer.popNewlineGroup();
        buffer.appendPossibleNewline("", true);
        buffer.popNewlineGroup();
    }

    private static Exprent getSimpleReturnValue(RootStatement root) {
        Statement block = root.getFirst();
        if (!(block instanceof BasicBlockStatement)) {
            return null;
        }
        List<Exprent> exprents = block.getExprents();
        if (exprents.isEmpty()) {
            return null;
        }
        Exprent exit = exprents.get(0);
        if (!(exit instanceof ExitExprent)) {
            return null;
        }
        return ((ExitExprent)exit).getValue();
    }

    private static boolean isSyntheticRecordMethod(StructMethod mt, RootStatement root) {
        String name = mt.getName();
        String descriptor = mt.getDescriptor();
        if (!(name.equals("equals") && descriptor.equals("(Ljava/lang/Object;)Z") || name.equals("hashCode") && descriptor.equals("()I") || name.equals("toString") && descriptor.equals("()Ljava/lang/String;"))) {
            return false;
        }
        Exprent value = RecordHelper.getSimpleReturnValue(root);
        if (!(value instanceof InvocationExprent)) {
            return false;
        }
        LinkConstant bootstrapMethod = ((InvocationExprent)value).getBootstrapMethod();
        if (bootstrapMethod == null) {
            return false;
        }
        return "java/lang/runtime/ObjectMethods".equals(bootstrapMethod.classname) && "bootstrap".equals(bootstrapMethod.elementname);
    }

    private static boolean isDefaultRecordMethod(StructMethod mt, RootStatement root) {
        Exprent value = RecordHelper.getSimpleReturnValue(root);
        if (!(value instanceof FieldExprent)) {
            return false;
        }
        FieldExprent fieldExprent = (FieldExprent)value;
        Exprent instance = fieldExprent.getInstance();
        if (!(instance instanceof VarExprent)) {
            return false;
        }
        return ((VarExprent)instance).getIndex() == 0 && fieldExprent.getName().equals(mt.getName());
    }

    private static boolean isDefaultRecordConstructor(StructClass cl, RootStatement root) {
        List<StructRecordComponent> components = cl.getRecordComponents();
        if (components == null) {
            return false;
        }
        Statement block = root.getFirst();
        if (!(block instanceof BasicBlockStatement)) {
            return false;
        }
        List<Exprent> exprents = block.getExprents();
        if (exprents.size() != components.size()) {
            return false;
        }
        int lastIndex = 0;
        for (int i = 0; i < components.size(); ++i) {
            StructRecordComponent component = components.get(i);
            Exprent assignment = exprents.get(i);
            if (!(assignment instanceof AssignmentExprent)) {
                return false;
            }
            Exprent left = ((AssignmentExprent)assignment).getLeft();
            if (!(left instanceof FieldExprent)) {
                return false;
            }
            if (!component.getName().equals(((FieldExprent)left).getName())) {
                return false;
            }
            Exprent fieldInstance = ((FieldExprent)left).getInstance();
            if (!(fieldInstance instanceof VarExprent) || ((VarExprent)fieldInstance).getIndex() != 0) {
                return false;
            }
            Exprent right = ((AssignmentExprent)assignment).getRight();
            if (!(right instanceof VarExprent)) {
                return false;
            }
            int index = ((VarExprent)right).getIndex();
            if (index <= lastIndex) {
                return false;
            }
            lastIndex = index;
        }
        return true;
    }

    private static StructMethod getCanonicalConstructor(StructClass cl) {
        String canonicalConstructorDescriptor = cl.getRecordComponents().stream().map(StructField::getDescriptor).collect(Collectors.joining("", "(", ")V"));
        return cl.getMethod("<init>", canonicalConstructorDescriptor);
    }

    private static StructMethod getGetter(StructClass cl, StructRecordComponent rc) {
        return cl.getMethod(rc.getName(), "()" + rc.getDescriptor());
    }

    private static boolean isVarArgRecord(StructClass cl) {
        StructMethod init = RecordHelper.getCanonicalConstructor(cl);
        return init != null && init.hasModifier(128);
    }

    private static Set<TextBuffer> getRecordComponentAnnotations(StructClass cl, StructRecordComponent cd, int param) {
        LinkedHashSet<String> annotations = new LinkedHashSet<String>();
        LinkedHashSet<TextBuffer> buffers = new LinkedHashSet<TextBuffer>();
        ArrayList<StructMember> members = new ArrayList<StructMember>();
        members.add(cd);
        StructMethod getter = RecordHelper.getGetter(cl, cd);
        if (getter != null) {
            members.add(getter);
        }
        for (StructMember member : members) {
            StructGeneralAttribute attribute;
            for (Key<?> key : ClassWriter.ANNOTATION_ATTRIBUTES) {
                attribute = (StructAnnotationAttribute)member.getAttribute(key);
                if (attribute == null) continue;
                for (AnnotationExprent annotationExprent : ((StructAnnotationAttribute)attribute).getAnnotations()) {
                    TextBuffer text = annotationExprent.toJava(-1);
                    if (!annotations.add(text.convertToStringAndAllowDataDiscard())) continue;
                    buffers.add(text);
                }
            }
            Key<?>[] keyArray = ClassWriter.TYPE_ANNOTATION_ATTRIBUTES;
            int n = keyArray.length;
            for (int i = 0; i < n; ++i) {
                Key<?> key;
                key = keyArray[i];
                attribute = (StructTypeAnnotationAttribute)member.getAttribute(key);
                if (attribute == null) continue;
                for (TypeAnnotation typeAnnotation : ((StructTypeAnnotationAttribute)attribute).getAnnotations()) {
                    TextBuffer text;
                    int type;
                    if (!typeAnnotation.isTopLevel() || (type = typeAnnotation.getTargetType()) != 19 && type != 22 || !annotations.add((text = typeAnnotation.getAnnotation().toJava(-1)).convertToStringAndAllowDataDiscard())) continue;
                    buffers.add(text);
                }
            }
        }
        StructMethod constr = RecordHelper.getCanonicalConstructor(cl);
        if (constr == null) {
            return buffers;
        }
        for (Key<?> key : ClassWriter.PARAMETER_ANNOTATION_ATTRIBUTES) {
            List<List<AnnotationExprent>> paramAnnotations;
            StructAnnotationParameterAttribute attribute = (StructAnnotationParameterAttribute)constr.getAttribute(key);
            if (attribute == null || param >= (paramAnnotations = attribute.getParamAnnotations()).size()) continue;
            for (AnnotationExprent annotationExprent : paramAnnotations.get(param)) {
                TextBuffer text = annotationExprent.toJava(-1);
                if (!annotations.add(text.convertToStringAndAllowDataDiscard())) continue;
                buffers.add(text);
            }
        }
        return buffers;
    }

    private static void recordComponentToJava(TextBuffer buffer, StructClass cl, StructRecordComponent cd, int param, boolean varArgComponent) {
        Set<TextBuffer> annotations = RecordHelper.getRecordComponentAnnotations(cl, cd, param);
        for (TextBuffer annotation : annotations) {
            buffer.appendText(annotation).append(' ');
        }
        VarType fieldType = new VarType(cd.getDescriptor(), false);
        GenericFieldDescriptor descriptor = cd.getSignature();
        if (descriptor != null) {
            fieldType = descriptor.type;
        }
        buffer.appendCastTypeName(varArgComponent ? fieldType.decreaseArrayDim() : fieldType);
        if (varArgComponent) {
            buffer.append("...");
        }
        buffer.append(' ');
        buffer.appendField(cd.getName(), true, cl.qualifiedName, cd.getName(), cd.getDescriptor());
    }

    private static boolean hasAnnotations(StructMethod mt) {
        return mt.getAttribute(StructGeneralAttribute.ATTRIBUTE_RUNTIME_INVISIBLE_ANNOTATIONS) != null || mt.getAttribute(StructGeneralAttribute.ATTRIBUTE_RUNTIME_VISIBLE_ANNOTATIONS) != null;
    }

    public static void fixupCanonicalConstructor(MethodWrapper mw, StructClass cl) {
        if (cl.getRecordComponents() == null) {
            return;
        }
        if (mw.methodStruct != RecordHelper.getCanonicalConstructor(cl)) {
            return;
        }
        MethodDescriptor md = mw.desc();
        int params = md.params.length;
        if (params != cl.getRecordComponents().size()) {
            return;
        }
        int varidx = 1;
        for (int i = 0; i < cl.getRecordComponents().size(); ++i) {
            mw.varproc.setClashingName(new VarVersionPair(varidx, 0), cl.getRecordComponents().get(i).getName());
            varidx += md.params[i].stackSize;
        }
    }
}

