/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.config;

import cuchaz.enigma.config.ConfigContainer;
import cuchaz.enigma.config.ConfigSection;
import cuchaz.enigma.gui.config.Decompiler;
import cuchaz.enigma.gui.config.LookAndFeel;
import cuchaz.enigma.gui.config.OldConfigImporter;
import cuchaz.enigma.gui.util.ScaleUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.Optional;
import java.util.OptionalInt;

public final class UiConfig {
    private static final ConfigContainer ui = ConfigContainer.getOrCreate((String)"enigma/enigmaui");
    private static final ConfigContainer swing = ConfigContainer.getOrCreate((String)"enigma/enigmaswing");
    private static ConfigSection runningSwing;

    private UiConfig() {
    }

    public static void snapshotConfig() {
        runningSwing = swing.data().copy();
    }

    public static void save() {
        ui.save();
        swing.save();
    }

    public static String getLanguage() {
        return ui.data().section("General").setIfAbsentString("Language", "en_us");
    }

    public static void setLanguage(String language) {
        ui.data().section("General").setString("Language", language);
    }

    public static float getScaleFactor() {
        return (float)swing.data().section("General").setIfAbsentDouble("Scale Factor", 1.0);
    }

    public static float getActiveScaleFactor() {
        return (float)runningSwing.section("General").setIfAbsentDouble("Scale Factor", 1.0);
    }

    public static void setScaleFactor(float scale) {
        swing.data().section("General").setDouble("Scale Factor", (double)scale);
    }

    public static int[] getLayout() {
        return swing.data().section("Main Window").getIntArray("Layout").orElseGet(() -> new int[]{-1, -1, -1, -1});
    }

    public static void setLayout(int leftV, int left, int right, int rightH) {
        swing.data().section("Main Window").setIntArray("Layout", new int[]{leftV, left, right, rightH});
    }

    public static LookAndFeel getLookAndFeel() {
        return (LookAndFeel)swing.data().section("Themes").setIfAbsentEnum(LookAndFeel::valueOf, "Current", (Enum)LookAndFeel.NONE);
    }

    public static LookAndFeel getActiveLookAndFeel() {
        return (LookAndFeel)runningSwing.section("Themes").setIfAbsentEnum(LookAndFeel::valueOf, "Current", (Enum)LookAndFeel.NONE);
    }

    public static void setLookAndFeel(LookAndFeel laf) {
        swing.data().section("Themes").setEnum("Current", (Enum)laf);
    }

    public static Decompiler getDecompiler() {
        return (Decompiler)ui.data().section("Decompiler").setIfAbsentEnum(Decompiler::valueOf, "Current", (Enum)Decompiler.VINEFLOWER);
    }

    public static void setDecompiler(Decompiler d) {
        ui.data().section("Decompiler").setEnum("Current", (Enum)d);
    }

    private static Color fromComponents(int rgb, double alpha) {
        int rgba = rgb & 0xFFFFFF | (int)(alpha * 255.0) << 24;
        return new Color(rgba, true);
    }

    private static Color getThemeColorRgba(String colorName) {
        ConfigSection s = runningSwing.section("Themes").section(UiConfig.getActiveLookAndFeel().name()).section("Colors");
        return UiConfig.fromComponents(s.getRgbColor(colorName).orElse(0), s.getDouble(String.format("%s Alpha", colorName)).orElse(0.0));
    }

    private static Color getThemeColorRgb(String colorName) {
        ConfigSection s = runningSwing.section("Themes").section(UiConfig.getActiveLookAndFeel().name()).section("Colors");
        return new Color(s.getRgbColor(colorName).orElse(0));
    }

    public static Color getObfuscatedColor() {
        return UiConfig.getThemeColorRgba("Obfuscated");
    }

    public static Color getObfuscatedOutlineColor() {
        return UiConfig.getThemeColorRgba("Obfuscated Outline");
    }

    public static Color getProposedColor() {
        return UiConfig.getThemeColorRgba("Proposed");
    }

    public static Color getProposedOutlineColor() {
        return UiConfig.getThemeColorRgba("Proposed Outline");
    }

    public static Color getDeobfuscatedColor() {
        return UiConfig.getThemeColorRgba("Deobfuscated");
    }

    public static Color getDeobfuscatedOutlineColor() {
        return UiConfig.getThemeColorRgba("Deobfuscated Outline");
    }

    public static Color getEditorBackgroundColor() {
        return UiConfig.getThemeColorRgb("Editor Background");
    }

    public static Color getHighlightColor() {
        return UiConfig.getThemeColorRgb("Highlight");
    }

    public static Color getCaretColor() {
        return UiConfig.getThemeColorRgb("Caret");
    }

    public static Color getSelectionHighlightColor() {
        return UiConfig.getThemeColorRgb("Selection Highlight");
    }

    public static Color getStringColor() {
        return UiConfig.getThemeColorRgb("String");
    }

    public static Color getNumberColor() {
        return UiConfig.getThemeColorRgb("Number");
    }

    public static Color getOperatorColor() {
        return UiConfig.getThemeColorRgb("Operator");
    }

    public static Color getDelimiterColor() {
        return UiConfig.getThemeColorRgb("Delimiter");
    }

    public static Color getTypeColor() {
        return UiConfig.getThemeColorRgb("Type");
    }

    public static Color getIdentifierColor() {
        return UiConfig.getThemeColorRgb("Identifier");
    }

    public static Color getTextColor() {
        return UiConfig.getThemeColorRgb("Text");
    }

    public static Color getLineNumbersForegroundColor() {
        return UiConfig.getThemeColorRgb("Line Numbers Foreground");
    }

    public static Color getLineNumbersBackgroundColor() {
        return UiConfig.getThemeColorRgb("Line Numbers Background");
    }

    public static Color getLineNumbersSelectedColor() {
        return UiConfig.getThemeColorRgb("Line Numbers Selected");
    }

    public static boolean useCustomFonts() {
        return swing.data().section("Themes").section(UiConfig.getActiveLookAndFeel().name()).section("Fonts").setIfAbsentBool("Use Custom", false);
    }

    public static boolean activeUseCustomFonts() {
        return runningSwing.section("Themes").section(UiConfig.getActiveLookAndFeel().name()).section("Fonts").setIfAbsentBool("Use Custom", false);
    }

    public static void setUseCustomFonts(boolean b) {
        swing.data().section("Themes").section(UiConfig.getActiveLookAndFeel().name()).section("Fonts").setBool("Use Custom", b);
    }

    public static Optional<Font> getFont(String name) {
        Optional spec = swing.data().section("Themes").section(UiConfig.getActiveLookAndFeel().name()).section("Fonts").getString(name);
        return spec.map(Font::decode);
    }

    public static Optional<Font> getActiveFont(String name) {
        Optional spec = runningSwing.section("Themes").section(UiConfig.getActiveLookAndFeel().name()).section("Fonts").getString(name);
        return spec.map(Font::decode);
    }

    public static void setFont(String name, Font font) {
        swing.data().section("Themes").section(UiConfig.getLookAndFeel().name()).section("Fonts").setString(name, UiConfig.encodeFont(font));
    }

    public static Font getDefaultFont() {
        return UiConfig.getActiveFont("Default").orElseGet(() -> ScaleUtil.scaleFont(Font.decode("Dialog").deriveFont(1)));
    }

    public static void setDefaultFont(Font font) {
        UiConfig.setFont("Default", font);
    }

    public static Font getDefault2Font() {
        return UiConfig.getActiveFont("Default 2").orElseGet(() -> ScaleUtil.scaleFont(Font.decode("Dialog")));
    }

    public static void setDefault2Font(Font font) {
        UiConfig.setFont("Default 2", font);
    }

    public static Font getSmallFont() {
        return UiConfig.getActiveFont("Small").orElseGet(() -> ScaleUtil.scaleFont(Font.decode("Dialog")));
    }

    public static void setSmallFont(Font font) {
        UiConfig.setFont("Small", font);
    }

    public static Font getEditorFont() {
        return UiConfig.getActiveFont("Editor").orElseGet(UiConfig::getFallbackEditorFont);
    }

    public static void setEditorFont(Font font) {
        UiConfig.setFont("Editor", font);
    }

    public static Font getFallbackEditorFont() {
        return ScaleUtil.scaleFont(Font.decode("Monospaced").deriveFont(12.0f));
    }

    public static String encodeFont(Font font) {
        int style = font.getStyle();
        String s = style == 3 ? "bolditalic" : (style == 2 ? "italic" : (style == 1 ? "bold" : "plain"));
        return String.format("%s-%s-%s", font.getName(), s, font.getSize());
    }

    public static Dimension getWindowSize(String window, Dimension fallback) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        ConfigSection section = swing.data().section(window);
        OptionalInt width = section.getInt(String.format("Width %s", screenSize.width));
        OptionalInt height = section.getInt(String.format("Height %s", screenSize.height));
        if (width.isPresent() && height.isPresent()) {
            return new Dimension(width.getAsInt(), height.getAsInt());
        }
        return fallback;
    }

    public static void setWindowSize(String window, Dimension dim) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        ConfigSection section = swing.data().section(window);
        section.setInt(String.format("Width %s", screenSize.width), dim.width);
        section.setInt(String.format("Height %s", screenSize.height), dim.height);
    }

    public static Point getWindowPos(String window, Point fallback) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        ConfigSection section = swing.data().section(window);
        OptionalInt x = section.getInt(String.format("X %s", screenSize.width));
        OptionalInt y = section.getInt(String.format("Y %s", screenSize.height));
        if (x.isPresent() && y.isPresent()) {
            int ix = x.getAsInt();
            int iy = y.getAsInt();
            if (ix < 0 || iy < 0 || ix > screenSize.width || iy > screenSize.height) {
                return fallback;
            }
            return new Point(ix, iy);
        }
        return fallback;
    }

    public static void setWindowPos(String window, Point rect) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        ConfigSection section = swing.data().section(window);
        section.setInt(String.format("X %s", screenSize.width), rect.x);
        section.setInt(String.format("Y %s", screenSize.height), rect.y);
    }

    public static boolean isFullscreen(String window) {
        return swing.data().section(window).setIfAbsentBool("Fullscreen", false);
    }

    public static void setFullscreen(String window, boolean fullscreen) {
        swing.data().section(window).setBool("Fullscreen", fullscreen);
    }

    public static String getLastSelectedDir() {
        return swing.data().section("File Dialog").getString("Selected").orElse("");
    }

    public static void setLastSelectedDir(String directory) {
        swing.data().section("File Dialog").setString("Selected", directory);
    }

    public static String getLastTopLevelPackage() {
        return swing.data().section("Mapping Stats").getString("Top-Level Package").orElse("");
    }

    public static void setLastTopLevelPackage(String topLevelPackage) {
        swing.data().section("Mapping Stats").setString("Top-Level Package", topLevelPackage);
    }

    public static boolean shouldIncludeSyntheticParameters() {
        return swing.data().section("Mapping Stats").setIfAbsentBool("Synthetic Parameters", false);
    }

    public static void setIncludeSyntheticParameters(boolean b) {
        swing.data().section("Mapping Stats").setBool("Synthetic Parameters", b);
    }

    public static void setLookAndFeelDefaults(LookAndFeel laf, boolean isDark) {
        ConfigSection s = swing.data().section("Themes").section(laf.name()).section("Colors");
        if (!isDark) {
            s.setIfAbsentRgbColor("Line Numbers Foreground", 0x333300);
            s.setIfAbsentRgbColor("Line Numbers Background", 0xEEEEFF);
            s.setIfAbsentRgbColor("Line Numbers Selected", 0xCCCCEE);
            s.setIfAbsentRgbColor("Obfuscated", 0xFFDCDC);
            s.setIfAbsentDouble("Obfuscated Alpha", 1.0);
            s.setIfAbsentRgbColor("Obfuscated Outline", 0xA05050);
            s.setIfAbsentDouble("Obfuscated Outline Alpha", 1.0);
            s.setIfAbsentRgbColor("Proposed", 0);
            s.setIfAbsentDouble("Proposed Alpha", 0.15);
            s.setIfAbsentRgbColor("Proposed Outline", 0);
            s.setIfAbsentDouble("Proposed Outline Alpha", 0.75);
            s.setIfAbsentRgbColor("Deobfuscated", 0xDCFFDC);
            s.setIfAbsentDouble("Deobfuscated Alpha", 1.0);
            s.setIfAbsentRgbColor("Deobfuscated Outline", 0x50A050);
            s.setIfAbsentDouble("Deobfuscated Outline Alpha", 1.0);
            s.setIfAbsentRgbColor("Editor Background", 0xFFFFFF);
            s.setIfAbsentRgbColor("Highlight", 0x3333EE);
            s.setIfAbsentRgbColor("Caret", 0);
            s.setIfAbsentRgbColor("Selection Highlight", 0);
            s.setIfAbsentRgbColor("String", 0xCC6600);
            s.setIfAbsentRgbColor("Number", 0x999933);
            s.setIfAbsentRgbColor("Operator", 0);
            s.setIfAbsentRgbColor("Delimiter", 0);
            s.setIfAbsentRgbColor("Type", 0);
            s.setIfAbsentRgbColor("Identifier", 0);
            s.setIfAbsentRgbColor("Text", 0);
        } else {
            s.setIfAbsentRgbColor("Line Numbers Foreground", 0xA4A4A3);
            s.setIfAbsentRgbColor("Line Numbers Background", 0x313335);
            s.setIfAbsentRgbColor("Line Numbers Selected", 0x606366);
            s.setIfAbsentRgbColor("Obfuscated", 0xFF5555);
            s.setIfAbsentDouble("Obfuscated Alpha", 0.3);
            s.setIfAbsentRgbColor("Obfuscated Outline", 0xFF5555);
            s.setIfAbsentDouble("Obfuscated Outline Alpha", 0.5);
            s.setIfAbsentRgbColor("Proposed", 0x606366);
            s.setIfAbsentDouble("Proposed Alpha", 0.3);
            s.setIfAbsentRgbColor("Proposed Outline", 0x606366);
            s.setIfAbsentDouble("Proposed Outline Alpha", 0.5);
            s.setIfAbsentRgbColor("Deobfuscated", 5307003);
            s.setIfAbsentDouble("Deobfuscated Alpha", 0.3);
            s.setIfAbsentRgbColor("Deobfuscated Outline", 5307003);
            s.setIfAbsentDouble("Deobfuscated Outline Alpha", 0.5);
            s.setIfAbsentRgbColor("Editor Background", 2632246);
            s.setIfAbsentRgbColor("Highlight", 16742854);
            s.setIfAbsentRgbColor("Caret", 0xF8F8F2);
            s.setIfAbsentRgbColor("Selection Highlight", 0xF8F8F2);
            s.setIfAbsentRgbColor("String", 15858316);
            s.setIfAbsentRgbColor("Number", 12424185);
            s.setIfAbsentRgbColor("Operator", 0xF8F8F2);
            s.setIfAbsentRgbColor("Delimiter", 0xF8F8F2);
            s.setIfAbsentRgbColor("Type", 0xF8F8F2);
            s.setIfAbsentRgbColor("Identifier", 0xF8F8F2);
            s.setIfAbsentRgbColor("Text", 0xF8F8F2);
        }
    }

    static {
        if (!swing.existsOnDisk() && !ui.existsOnDisk()) {
            OldConfigImporter.doImport();
        }
        UiConfig.snapshotConfig();
    }
}

