/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.dialog;

import cuchaz.enigma.gui.util.GuiUtil;
import cuchaz.enigma.gui.util.ScaleUtil;
import cuchaz.enigma.utils.I18n;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class CrashDialog {
    private static CrashDialog instance = null;
    private JFrame frame = new JFrame(String.format(I18n.translate((String)"crash.title"), "Enigma"));
    private JTextArea text;

    private CrashDialog(JFrame parent) {
        Container pane = this.frame.getContentPane();
        pane.setLayout(new BorderLayout());
        JLabel label = new JLabel(String.format(I18n.translate((String)"crash.summary"), "Enigma"));
        label.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        pane.add((Component)label, "North");
        this.text = new JTextArea();
        this.text.setTabSize(2);
        pane.add((Component)new JScrollPane(this.text), "Center");
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 2));
        JButton exportButton = new JButton(I18n.translate((String)"crash.export"));
        exportButton.addActionListener(event -> {
            JFileChooser chooser = new JFileChooser();
            chooser.setSelectedFile(new File("enigma_crash.log"));
            if (chooser.showSaveDialog(null) == 0) {
                try {
                    File file = chooser.getSelectedFile();
                    FileWriter writer = new FileWriter(file);
                    writer.write(CrashDialog.instance.text.getText());
                    writer.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        });
        buttonsPanel.add(exportButton);
        buttonsPanel.add(Box.createHorizontalGlue());
        buttonsPanel.add(GuiUtil.unboldLabel(new JLabel(I18n.translate((String)"crash.exit.warning"))));
        JButton ignoreButton = new JButton(I18n.translate((String)"crash.ignore"));
        ignoreButton.addActionListener(event -> this.frame.setVisible(false));
        buttonsPanel.add(ignoreButton);
        JButton exitButton = new JButton(I18n.translate((String)"crash.exit"));
        exitButton.addActionListener(event -> System.exit(1));
        buttonsPanel.add(exitButton);
        pane.add((Component)buttonsPanel, "South");
        this.frame.setSize(ScaleUtil.getDimension(600, 400));
        this.frame.setLocationRelativeTo(parent);
        this.frame.setDefaultCloseOperation(2);
    }

    public static void init(JFrame parent) {
        instance = new CrashDialog(parent);
    }

    public static void show(Throwable ex) {
        StringWriter buf = new StringWriter();
        ex.printStackTrace(new PrintWriter(buf));
        String report = buf.toString();
        CrashDialog.instance.text.setText(report);
        CrashDialog.instance.frame.doLayout();
        CrashDialog.instance.frame.setVisible(true);
    }
}

