/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.dialog;

import cuchaz.enigma.ProgressListener;
import cuchaz.enigma.gui.dialog.CrashDialog;
import cuchaz.enigma.gui.util.GridBagConstraintsBuilder;
import cuchaz.enigma.gui.util.GuiUtil;
import cuchaz.enigma.gui.util.ScaleUtil;
import cuchaz.enigma.utils.I18n;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.util.concurrent.CompletableFuture;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class ProgressDialog
implements ProgressListener,
AutoCloseable {
    private final JDialog dialog;
    private final JLabel labelTitle = new JLabel();
    private final JLabel labelText = GuiUtil.unboldLabel(new JLabel());
    private final JProgressBar progress = new JProgressBar();

    public ProgressDialog(JFrame parent) {
        this.dialog = new JDialog((Frame)parent, String.format(I18n.translate((String)"progress.operation"), "Enigma"));
        Container pane = this.dialog.getContentPane();
        pane.setLayout(new GridBagLayout());
        GridBagConstraintsBuilder cb = GridBagConstraintsBuilder.create().insets(2).anchor(17).fill(1).weight(1.0, 0.0);
        pane.add((Component)this.labelTitle, cb.pos(0, 0).build());
        pane.add((Component)this.labelText, cb.pos(0, 1).build());
        pane.add((Component)this.progress, cb.pos(0, 2).weight(1.0, 1.0).build());
        this.labelTitle.setText("Idle");
        this.labelText.setText("Idle");
        this.progress.setPreferredSize(ScaleUtil.getDimension(0, 20));
        this.dialog.setResizable(false);
        this.reposition();
        this.dialog.setDefaultCloseOperation(0);
    }

    private void reposition() {
        this.dialog.pack();
        Dimension size = this.dialog.getSize();
        this.dialog.setMinimumSize(size);
        size.width = ScaleUtil.scale(400);
        this.dialog.setSize(size);
        this.dialog.setLocationRelativeTo(this.dialog.getParent());
    }

    public static CompletableFuture<Void> runOffThread(JFrame parent, ProgressRunnable runnable) {
        return CompletableFuture.supplyAsync(() -> {
            ProgressDialog progress = new ProgressDialog(parent);
            progress.dialog.setVisible(true);
            progress.dialog.dispose();
            progress.dialog.setVisible(true);
            progress.reposition();
            return progress;
        }, SwingUtilities::invokeLater).thenAcceptAsync(progress -> {
            try (ProgressDialog progressDialog = progress;){
                runnable.run((ProgressListener)progress);
            }
            catch (Throwable e) {
                CrashDialog.show(e);
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void close() {
        SwingUtilities.invokeLater(this.dialog::dispose);
    }

    public void init(int totalWork, String title) {
        SwingUtilities.invokeLater(() -> {
            this.labelTitle.setText(title);
            this.progress.setMinimum(0);
            this.progress.setMaximum(totalWork);
            this.progress.setValue(0);
        });
    }

    public void step(int numDone, String message) {
        SwingUtilities.invokeLater(() -> {
            this.labelText.setText(message);
            if (numDone != -1) {
                this.progress.setValue(numDone);
                this.progress.setIndeterminate(false);
            } else {
                this.progress.setIndeterminate(true);
            }
        });
    }

    public static interface ProgressRunnable {
        public void run(ProgressListener var1) throws Exception;
    }
}

