/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.panels;

import cuchaz.enigma.EnigmaProject;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.classhandle.ClassHandle;
import cuchaz.enigma.classhandle.ClassHandleError;
import cuchaz.enigma.events.ClassHandleListener;
import cuchaz.enigma.gui.BrowserCaret;
import cuchaz.enigma.gui.EditableType;
import cuchaz.enigma.gui.Gui;
import cuchaz.enigma.gui.GuiController;
import cuchaz.enigma.gui.config.LookAndFeel;
import cuchaz.enigma.gui.config.Themes;
import cuchaz.enigma.gui.config.UiConfig;
import cuchaz.enigma.gui.elements.EditorPopupMenu;
import cuchaz.enigma.gui.events.EditorActionListener;
import cuchaz.enigma.gui.events.ThemeChangeListener;
import cuchaz.enigma.gui.highlight.BoxHighlightPainter;
import cuchaz.enigma.gui.highlight.SelectionHighlightPainter;
import cuchaz.enigma.gui.util.GridBagConstraintsBuilder;
import cuchaz.enigma.gui.util.ScaleUtil;
import cuchaz.enigma.source.DecompiledClassSource;
import cuchaz.enigma.source.RenamableTokenType;
import cuchaz.enigma.source.Token;
import cuchaz.enigma.translation.mapping.EntryRemapper;
import cuchaz.enigma.translation.mapping.EntryResolver;
import cuchaz.enigma.translation.mapping.ResolutionStrategy;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.utils.I18n;
import cuchaz.enigma.utils.Result;
import de.sciss.syntaxpane.DefaultSyntaxKit;
import de.sciss.syntaxpane.SyntaxDocument;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import org.jetbrains.annotations.Nullable;

public class EditorPanel {
    private final JPanel ui = new JPanel();
    private final JEditorPane editor = new JEditorPane();
    private final JScrollPane editorScrollPane = new JScrollPane(this.editor);
    private final EditorPopupMenu popupMenu;
    private final JLabel decompilingLabel = new JLabel(I18n.translate((String)"editor.decompiling"), 0);
    private final JProgressBar decompilingProgressBar = new JProgressBar(0, 100);
    private final JLabel errorLabel = new JLabel();
    private final JTextArea errorTextArea = new JTextArea();
    private final JScrollPane errorScrollPane = new JScrollPane(this.errorTextArea);
    private final JButton retryButton = new JButton(I18n.translate((String)"prompt.retry"));
    private DisplayMode mode = DisplayMode.INACTIVE;
    private final GuiController controller;
    private final Gui gui;
    private EntryReference<Entry<?>, Entry<?>> cursorReference;
    private EntryReference<Entry<?>, Entry<?>> nextReference;
    private boolean mouseIsPressed = false;
    private boolean shouldNavigateOnClick;
    public LookAndFeel editorLaf;
    private int fontSize = 12;
    private Map<RenamableTokenType, BoxHighlightPainter> boxHighlightPainters;
    private final List<EditorActionListener> listeners = new ArrayList<EditorActionListener>();
    private final ThemeChangeListener themeChangeListener;
    private ClassHandle classHandle;
    private DecompiledClassSource source;
    private boolean settingSource;

    public EditorPanel(final Gui gui) {
        this.gui = gui;
        this.controller = gui.getController();
        this.editor.setEditable(false);
        this.editor.setSelectionColor(new Color(31, 46, 90));
        this.editor.setCaret(new BrowserCaret());
        this.editor.addCaretListener(event -> this.onCaretMove(event.getDot(), this.mouseIsPressed));
        this.editor.setCaretColor(UiConfig.getCaretColor());
        this.editor.setContentType("text/enigma-sources");
        this.editor.setBackground(UiConfig.getEditorBackgroundColor());
        DefaultSyntaxKit kit = (DefaultSyntaxKit)this.editor.getEditorKit();
        kit.toggleComponent(this.editor, "de.sciss.syntaxpane.components.TokenMarker");
        this.editorScrollPane.getVerticalScrollBar().setUnitIncrement(this.editor.getFontMetrics(this.editor.getFont()).getHeight());
        this.popupMenu = new EditorPopupMenu(this, gui);
        this.editor.setComponentPopupMenu(this.popupMenu.getUi());
        this.decompilingLabel.setFont(ScaleUtil.getFont(this.decompilingLabel.getFont().getFontName(), 1, 26));
        this.decompilingProgressBar.setIndeterminate(true);
        this.errorTextArea.setEditable(false);
        this.errorTextArea.setFont(ScaleUtil.getFont("Monospaced", 0, 10));
        this.boxHighlightPainters = Themes.getBoxHighlightPainters();
        this.editor.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                EditorPanel.this.mouseIsPressed = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                switch (e.getButton()) {
                    case 3: {
                        EditorPanel.this.editor.setCaretPosition(EditorPanel.this.editor.viewToModel(e.getPoint()));
                        break;
                    }
                    case 4: {
                        gui.getController().openPreviousReference();
                        break;
                    }
                    case 5: {
                        gui.getController().openNextReference();
                    }
                }
                EditorPanel.this.mouseIsPressed = false;
            }
        });
        this.editor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.isControlDown()) {
                    EditorPanel.this.shouldNavigateOnClick = false;
                    if (EditorPanel.this.popupMenu.handleKeyEvent(event)) {
                        return;
                    }
                    switch (event.getKeyCode()) {
                        case 116: {
                            if (EditorPanel.this.classHandle == null) break;
                            EditorPanel.this.classHandle.invalidate();
                            break;
                        }
                        case 70: {
                            break;
                        }
                        case 61: 
                        case 107: 
                        case 521: {
                            EditorPanel.this.offsetEditorZoom(2);
                            break;
                        }
                        case 45: 
                        case 109: {
                            EditorPanel.this.offsetEditorZoom(-2);
                            break;
                        }
                        default: {
                            EditorPanel.this.shouldNavigateOnClick = true;
                        }
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent event) {
                EntryReference<Entry<?>, Entry<?>> ref = EditorPanel.this.getCursorReference();
                if (ref == null) {
                    return;
                }
                if (!EditorPanel.this.controller.project.isRenamable(ref)) {
                    return;
                }
                if (!event.isControlDown() && !event.isAltDown() && Character.isJavaIdentifierPart(event.getKeyChar())) {
                    String packageName;
                    EnigmaProject project = gui.getController().project;
                    EntryReference reference = (EntryReference)project.getMapper().deobfuscate(EditorPanel.this.cursorReference);
                    Entry entry = reference.getNameableEntry();
                    Object name = String.valueOf(event.getKeyChar());
                    if (entry instanceof ClassEntry && ((ClassEntry)entry).getParent() == null && (packageName = ((ClassEntry)entry).getPackageName()) != null) {
                        name = packageName + "/" + (String)name;
                    }
                    gui.startRename(EditorPanel.this, (String)name);
                }
            }

            @Override
            public void keyReleased(KeyEvent event) {
                EditorPanel.this.shouldNavigateOnClick = event.isControlDown();
            }
        });
        this.retryButton.addActionListener(_e -> this.redecompileClass());
        this.themeChangeListener = (laf, boxHighlightPainters) -> {
            if (this.editorLaf == null || this.editorLaf != laf) {
                this.editor.updateUI();
                this.editor.setBackground(UiConfig.getEditorBackgroundColor());
                if (this.editorLaf != null) {
                    this.classHandle.invalidateMapped();
                }
                this.editorLaf = laf;
            }
            this.boxHighlightPainters = boxHighlightPainters;
        };
        this.ui.putClientProperty(EditorPanel.class, this);
    }

    @Nullable
    public static EditorPanel byUi(Component ui) {
        Object prop;
        if (ui instanceof JComponent && (prop = ((JComponent)ui).getClientProperty(EditorPanel.class)) instanceof EditorPanel) {
            return (EditorPanel)prop;
        }
        return null;
    }

    public void setClassHandle(ClassHandle handle) {
        ClassEntry old = null;
        if (this.classHandle != null) {
            old = this.classHandle.getRef();
            this.classHandle.close();
        }
        this.setClassHandle0(old, handle);
    }

    private void setClassHandle0(ClassEntry old, ClassHandle handle) {
        this.setDisplayMode(DisplayMode.IN_PROGRESS);
        this.setCursorReference(null);
        handle.addListener(new ClassHandleListener(){

            public void onDeobfRefChanged(ClassHandle h, ClassEntry deobfRef) {
                SwingUtilities.invokeLater(() -> EditorPanel.this.listeners.forEach(l -> l.onTitleChanged(EditorPanel.this, EditorPanel.this.getFileName())));
            }

            public void onMappedSourceChanged(ClassHandle h, Result<DecompiledClassSource, ClassHandleError> res) {
                EditorPanel.this.handleDecompilerResult(res);
            }

            public void onInvalidate(ClassHandle h, ClassHandleListener.InvalidationType t) {
                SwingUtilities.invokeLater(() -> {
                    if (t == ClassHandleListener.InvalidationType.FULL) {
                        EditorPanel.this.setDisplayMode(DisplayMode.IN_PROGRESS);
                    }
                });
            }

            public void onDeleted(ClassHandle h) {
                SwingUtilities.invokeLater(() -> EditorPanel.this.gui.closeEditor(EditorPanel.this));
            }
        });
        handle.getSource().thenAcceptAsync(this::handleDecompilerResult, SwingUtilities::invokeLater);
        this.classHandle = handle;
        this.listeners.forEach(l -> l.onClassHandleChanged(this, old, handle));
    }

    public void setup() {
        Themes.addListener(this.themeChangeListener);
    }

    public void destroy() {
        Themes.removeListener(this.themeChangeListener);
        this.classHandle.close();
    }

    private void redecompileClass() {
        if (this.classHandle != null) {
            this.classHandle.invalidate();
        }
    }

    private void handleDecompilerResult(Result<DecompiledClassSource, ClassHandleError> res) {
        if (res.isOk()) {
            this.setSource((DecompiledClassSource)res.unwrap());
        } else {
            this.displayError((ClassHandleError)res.unwrapErr());
        }
        this.nextReference = null;
    }

    public void displayError(ClassHandleError t) {
        this.setDisplayMode(DisplayMode.ERRORED);
        String str = switch (t.type) {
            default -> throw new IncompatibleClassChangeError();
            case ClassHandleError.Type.DECOMPILE -> "editor.decompile_error";
            case ClassHandleError.Type.REMAP -> "editor.remap_error";
        };
        this.errorLabel.setText(I18n.translate((String)str));
        this.errorTextArea.setText(t.getStackTrace());
        this.errorTextArea.setCaretPosition(0);
    }

    public void setDisplayMode(DisplayMode mode) {
        if (this.mode == mode) {
            return;
        }
        this.ui.removeAll();
        switch (mode.ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                this.decompilingProgressBar.setIndeterminate(false);
                this.decompilingProgressBar.setIndeterminate(true);
                this.ui.setLayout(new GridBagLayout());
                GridBagConstraintsBuilder cb = GridBagConstraintsBuilder.create().insets(2);
                this.ui.add((Component)this.decompilingLabel, cb.pos(0, 0).anchor(15).build());
                this.ui.add((Component)this.decompilingProgressBar, cb.pos(0, 1).anchor(11).build());
                break;
            }
            case 2: {
                this.ui.setLayout(new GridLayout(1, 1, 0, 0));
                this.ui.add(this.editorScrollPane);
                break;
            }
            case 3: {
                this.ui.setLayout(new GridBagLayout());
                GridBagConstraintsBuilder cb = GridBagConstraintsBuilder.create().insets(2).weight(1.0, 0.0).anchor(17);
                this.ui.add((Component)this.errorLabel, cb.pos(0, 0).build());
                this.ui.add((Component)new JSeparator(0), cb.pos(0, 1).fill(2).build());
                this.ui.add((Component)this.errorScrollPane, cb.pos(0, 2).weight(1.0, 1.0).fill(1).build());
                this.ui.add((Component)this.retryButton, cb.pos(0, 3).weight(0.0, 0.0).anchor(13).build());
                break;
            }
        }
        this.ui.validate();
        this.ui.repaint();
        this.mode = mode;
    }

    public void offsetEditorZoom(int zoomAmount) {
        int newResult = this.fontSize + zoomAmount;
        if (newResult > 8 && newResult < 72) {
            this.fontSize = newResult;
            this.editor.setFont(ScaleUtil.getFont(this.editor.getFont().getFontName(), 0, this.fontSize));
        }
    }

    public void resetEditorZoom() {
        this.fontSize = 12;
        this.editor.setFont(ScaleUtil.getFont(this.editor.getFont().getFontName(), 0, this.fontSize));
    }

    public void onCaretMove(int pos, boolean fromClick) {
        Entry referenceEntry;
        if (this.settingSource) {
            return;
        }
        if (this.controller.project == null) {
            return;
        }
        EntryRemapper mapper = this.controller.project.getMapper();
        Token token = this.getToken(pos);
        this.setCursorReference(this.getReference(token));
        Entry entry = referenceEntry = this.cursorReference != null ? this.cursorReference.entry : null;
        if (referenceEntry != null && this.shouldNavigateOnClick && fromClick) {
            this.shouldNavigateOnClick = false;
            Entry navigationEntry = referenceEntry;
            if (this.cursorReference.context == null) {
                EntryResolver resolver = mapper.getObfResolver();
                navigationEntry = resolver.resolveFirstEntry(referenceEntry, ResolutionStrategy.RESOLVE_ROOT);
            }
            this.controller.navigateTo(navigationEntry);
        }
    }

    private void setCursorReference(EntryReference<Entry<?>, Entry<?>> ref) {
        this.cursorReference = ref;
        this.popupMenu.updateUiState();
        this.listeners.forEach(l -> l.onCursorReferenceChanged(this, ref));
    }

    public Token getToken(int pos) {
        if (this.source == null) {
            return null;
        }
        return this.source.getIndex().getReferenceToken(pos);
    }

    @Nullable
    public EntryReference<Entry<?>, Entry<?>> getReference(Token token) {
        if (this.source == null) {
            return null;
        }
        return this.source.getIndex().getReference(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSource(DecompiledClassSource source) {
        this.setDisplayMode(DisplayMode.SUCCESS);
        if (source == null) {
            return;
        }
        try {
            this.settingSource = true;
            int newCaretPos = 0;
            if (this.source != null && this.source.getEntry().equals(source.getEntry())) {
                int caretPos = this.editor.getCaretPosition();
                if (this.source.getTokenStore().isCompatible(source.getTokenStore())) {
                    newCaretPos = this.source.getTokenStore().mapPosition(source.getTokenStore(), caretPos);
                } else {
                    if (this.getCursorReference() != null && this.nextReference == null) {
                        this.nextReference = this.getCursorReference();
                    }
                    float scale = (float)source.toString().length() / (float)this.source.toString().length();
                    newCaretPos = (int)((float)caretPos * scale);
                }
            }
            this.source = source;
            this.editor.getHighlighter().removeAllHighlights();
            this.editor.setText(source.toString());
            Document document = this.editor.getDocument();
            if (document instanceof SyntaxDocument) {
                SyntaxDocument syntaxDocument = (SyntaxDocument)document;
                syntaxDocument.clearUndos();
            }
            if (this.source != null) {
                this.editor.setCaretPosition(newCaretPos);
            }
            this.setHighlightedTokens(source.getHighlightedTokens());
            this.setCursorReference(this.getReference(this.getToken(this.editor.getCaretPosition())));
        }
        finally {
            this.settingSource = false;
        }
        if (this.nextReference != null) {
            this.showReference0(this.nextReference);
            this.nextReference = null;
        }
    }

    public void setHighlightedTokens(Map<RenamableTokenType, ? extends Collection<Token>> tokens) {
        this.editor.getHighlighter().removeAllHighlights();
        if (this.boxHighlightPainters != null) {
            BoxHighlightPainter proposedPainter = this.boxHighlightPainters.get(RenamableTokenType.PROPOSED);
            for (RenamableTokenType type : tokens.keySet()) {
                BoxHighlightPainter painter = this.boxHighlightPainters.get(type);
                if (painter == null) continue;
                for (Token token : tokens.get(type)) {
                    BoxHighlightPainter tokenPainter;
                    EntryReference<Entry<?>, Entry<?>> reference = this.getReference(token);
                    if (reference != null) {
                        EditableType t = EditableType.fromEntry(reference.entry);
                        boolean editable = t == null || this.gui.isEditable(t);
                        tokenPainter = editable ? painter : proposedPainter;
                    } else {
                        tokenPainter = painter;
                    }
                    this.addHighlightedToken(token, tokenPainter);
                }
            }
        }
        this.editor.validate();
        this.editor.repaint();
    }

    private void addHighlightedToken(Token token, Highlighter.HighlightPainter tokenPainter) {
        try {
            this.editor.getHighlighter().addHighlight(token.start, token.end, tokenPainter);
        }
        catch (BadLocationException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public EntryReference<Entry<?>, Entry<?>> getCursorReference() {
        return this.cursorReference;
    }

    public void showReference(EntryReference<Entry<?>, Entry<?>> reference) {
        if (this.mode == DisplayMode.SUCCESS) {
            this.showReference0(reference);
        } else if (this.mode != DisplayMode.ERRORED) {
            this.nextReference = reference;
        }
    }

    private void showReference0(EntryReference<Entry<?>, Entry<?>> reference) {
        if (this.source == null) {
            return;
        }
        if (reference == null) {
            return;
        }
        List<Token> tokens = this.controller.getTokensForReference(this.source, reference);
        if (tokens.isEmpty()) {
            System.err.println(String.format("WARNING: no tokens found for %s in %s", reference, this.classHandle.getRef()));
        } else {
            this.gui.showTokens(this, tokens);
        }
    }

    public void navigateToToken(Token token) {
        if (token == null) {
            throw new IllegalArgumentException("Token cannot be null!");
        }
        this.navigateToToken(token, SelectionHighlightPainter.INSTANCE);
    }

    private void navigateToToken(final Token token, final Highlighter.HighlightPainter highlightPainter) {
        Document document = this.editor.getDocument();
        int clampedPosition = Math.min(Math.max(token.start, 0), document.getLength());
        this.editor.setCaretPosition(clampedPosition);
        this.editor.grabFocus();
        try {
            Rectangle start = this.editor.modelToView(token.start);
            Rectangle end = this.editor.modelToView(token.end);
            if (start == null || end == null) {
                return;
            }
            Rectangle show = start.union(end);
            show.grow(start.width * 10, start.height * 6);
            SwingUtilities.invokeLater(() -> this.editor.scrollRectToVisible(show));
        }
        catch (BadLocationException ex) {
            if (!this.settingSource) {
                throw new RuntimeException(ex);
            }
            return;
        }
        Timer timer = new Timer(200, new ActionListener(){
            private int counter = 0;
            private Object highlight = null;

            @Override
            public void actionPerformed(ActionEvent event) {
                if (this.counter % 2 == 0) {
                    try {
                        this.highlight = EditorPanel.this.editor.getHighlighter().addHighlight(token.start, token.end, highlightPainter);
                    }
                    catch (BadLocationException badLocationException) {}
                } else if (this.highlight != null) {
                    EditorPanel.this.editor.getHighlighter().removeHighlight(this.highlight);
                }
                if (this.counter++ > 6) {
                    Timer timer = (Timer)event.getSource();
                    timer.stop();
                }
            }
        });
        timer.start();
    }

    public void addListener(EditorActionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(EditorActionListener listener) {
        this.listeners.remove(listener);
    }

    public JPanel getUi() {
        return this.ui;
    }

    public JEditorPane getEditor() {
        return this.editor;
    }

    public DecompiledClassSource getSource() {
        return this.source;
    }

    public ClassHandle getClassHandle() {
        return this.classHandle;
    }

    public String getFileName() {
        ClassEntry classEntry = this.classHandle.getDeobfRef() != null ? this.classHandle.getDeobfRef() : this.classHandle.getRef();
        return classEntry.getSimpleName();
    }

    public void retranslateUi() {
        this.popupMenu.retranslateUi();
    }

    private static enum DisplayMode {
        INACTIVE,
        IN_PROGRESS,
        SUCCESS,
        ERRORED;

    }
}

