/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui;

import cuchaz.enigma.gui.node.ClassSelectorClassNode;
import cuchaz.enigma.gui.node.ClassSelectorPackageNode;
import cuchaz.enigma.translation.mapping.EntryRemapper;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class NestedPackages {
    private final DefaultMutableTreeNode root = new DefaultMutableTreeNode();
    private final Map<String, DefaultMutableTreeNode> packageToNode = new HashMap<String, DefaultMutableTreeNode>();
    private final Map<ClassEntry, ClassSelectorClassNode> classToNode = new HashMap<ClassEntry, ClassSelectorClassNode>();
    private final EntryRemapper remapper;
    private final Comparator<TreeNode> comparator;

    public NestedPackages(Iterable<ClassEntry> entries, Comparator<ClassEntry> entryComparator, EntryRemapper remapper) {
        this.remapper = remapper;
        this.comparator = (a, b) -> {
            if (a instanceof ClassSelectorPackageNode) {
                ClassSelectorPackageNode pA = (ClassSelectorPackageNode)a;
                if (b instanceof ClassSelectorPackageNode) {
                    ClassSelectorPackageNode pB = (ClassSelectorPackageNode)b;
                    return pA.getPackageName().compareTo(pB.getPackageName());
                }
                return -1;
            }
            if (a instanceof ClassSelectorClassNode) {
                ClassSelectorClassNode cA = (ClassSelectorClassNode)a;
                if (b instanceof ClassSelectorClassNode) {
                    ClassSelectorClassNode cB = (ClassSelectorClassNode)b;
                    return entryComparator.compare(cA.getClassEntry(), cB.getClassEntry());
                }
                return 1;
            }
            return 0;
        };
        for (ClassEntry entry : entries) {
            this.addEntry(entry);
        }
    }

    public void addEntry(ClassEntry entry) {
        ClassEntry translated = this.remapper.deobfuscate(entry);
        ClassSelectorClassNode me = new ClassSelectorClassNode(entry, translated);
        this.classToNode.put(entry, me);
        this.insert(this.getPackage(translated.getPackageName()), me);
    }

    public DefaultMutableTreeNode getPackage(String packageName) {
        DefaultMutableTreeNode node = this.packageToNode.get(packageName);
        if (packageName == null) {
            return this.root;
        }
        if (node == null) {
            node = new ClassSelectorPackageNode(packageName);
            this.insert(this.getPackage(ClassEntry.getParentPackage(packageName)), node);
            this.packageToNode.put(packageName, node);
        }
        return node;
    }

    public DefaultMutableTreeNode getRoot() {
        return this.root;
    }

    public TreePath getPackagePath(String packageName) {
        DefaultMutableTreeNode node = this.packageToNode.getOrDefault(packageName, this.root);
        return new TreePath(node.getPath());
    }

    public ClassSelectorClassNode getClassNode(ClassEntry entry) {
        return this.classToNode.get(entry);
    }

    public void removeClassNode(ClassEntry entry) {
        ClassSelectorClassNode node = this.classToNode.remove(entry);
        if (node != null) {
            node.removeFromParent();
            for (DefaultMutableTreeNode packageNode = (DefaultMutableTreeNode)node.getParent(); packageNode != null && packageNode.getChildCount() == 0; packageNode = (DefaultMutableTreeNode)packageNode.getParent()) {
                DefaultMutableTreeNode theNode = packageNode;
                theNode.removeFromParent();
                if (!(theNode instanceof ClassSelectorPackageNode)) continue;
                ClassSelectorPackageNode pn = (ClassSelectorPackageNode)theNode;
                this.packageToNode.remove(pn.getPackageName());
            }
        }
    }

    public Collection<DefaultMutableTreeNode> getPackageNodes() {
        return this.packageToNode.values();
    }

    private void insert(DefaultMutableTreeNode parent, MutableTreeNode child) {
        int index = 0;
        Enumeration<TreeNode> children = parent.children();
        while (children.hasMoreElements() && this.comparator.compare(children.nextElement(), child) < 0) {
            ++index;
        }
        parent.insert(child, index);
    }
}

