/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.utils.validation;

import cuchaz.enigma.utils.validation.Message;
import cuchaz.enigma.utils.validation.ParameterizedMessage;
import cuchaz.enigma.utils.validation.Validatable;
import java.io.PrintStream;
import java.util.Arrays;

public class PrintValidatable
implements Validatable {
    public static final PrintValidatable INSTANCE = new PrintValidatable();

    @Override
    public void addMessage(ParameterizedMessage message) {
        PrintValidatable.formatMessage(System.out, message);
    }

    public static void formatMessage(PrintStream w, ParameterizedMessage message) {
        String text = message.getText();
        String longText = message.getLongText();
        String type = switch (message.message.type) {
            default -> throw new IncompatibleClassChangeError();
            case Message.Type.INFO -> "info";
            case Message.Type.WARNING -> "warning";
            case Message.Type.ERROR -> "error";
        };
        w.printf("%s: %s\n", type, text);
        if (!longText.isEmpty()) {
            Arrays.stream(longText.split("\n")).forEach(s -> w.printf("  %s\n", s));
        }
    }

    @Override
    public void clearMessages() {
    }
}

